#include "dcVShaderConstants.HLSL"
#include "dcOutputPos.HLSL"

float Timer;

//#define REFLECTION
//#define SHADOWMAP
//#define CHEAPREFLECTION

struct VS_OUTPUT{
    float4 Pos				: POSITION;

	float2 BumpTex0			: TEXCOORD0;
	float2 BumpTex1			: TEXCOORD1;
	
	dcNormalData(Normal, TEXCOORD2);
};

struct VS_INPUT{
    float3 Pos				: POSITION;
    float2 BaseTex			: TEXCOORD0;
#ifdef INSTANCED
	float4x4 World			: TEXCOORD1;
#endif
};

VS_OUTPUT main(const VS_INPUT Input){
#ifdef INSTANCED
	float4x4 World = Input.World;
#endif
	// Setup
	float3 Pos = mul(float4(Input.Pos, 1), World);

	// Output
    VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), ViewProj);

	Out.BumpTex0 = Input.BaseTex + float2(Timer / 15.1f, 0);
	Out.BumpTex1 = Input.BaseTex + float2(0, Timer / 17.4f);

	OutputNormalData(float3(0, 1, 0));
    OutputPosData(Pos);
    return Out;
}