#include "dcVShaderConstants.HLSL"
#include "dcOutputPos.HLSL"

float Timer;
float4x4 AlphaLightMatrix;

//#define REFLECTION
//#define SHADOWMAP
//#define CHEAPREFLECTION

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float4 Tex				: TEXCOORD0;
#ifdef COMPLETE
	float3 WorldPos			: TEXCOORD1;
#endif
};

struct VS_INPUT{
    float3 Pos				: POSITION;
#ifdef INSTANCED
	float4x4 World			: TEXCOORD1;
#endif
};

VS_OUTPUT main(const VS_INPUT Input){
#ifdef INSTANCED
	float4x4 World = Input.World;
#endif
	// Setup
	float3 Pos = mul(float4(Input.Pos, 1), (float4x3)World);

	// Output
    VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), ViewProj);
	Out.Tex = mul(Out.Pos, AlphaLightMatrix);
#ifdef COMPLETE
	Out.WorldPos = Pos;
#endif
    return Out;
}