sampler2D NormalTex;
sampler2D ProjTex;

sampler2D WaterEffectTex;
samplerCUBE ReflectionTex;

float3 WaterColor;
float3 CamPos;

struct PS_INPUT{
	float4 Tex				: TEXCOORD0;
#ifdef COMPLETE
	float3 Pos				: TEXCOORD1;
#endif
};

struct PS_OUTPUT{
    float4 Color			: COLOR;
};

PS_OUTPUT main(const PS_INPUT Input){
#ifndef PS14
	float2 Tex = Input.Tex.xy / Input.Tex.w;
#else
	float2 Tex = tex2Dproj(ProjTex, Input.Tex);
#endif
	float3 Normal = (tex2Dproj(NormalTex, Input.Tex) - 0.5f) * 2;
	
	float3 N = Normal;
	Tex += N.xy * 0.025f;
	
#ifndef SKYONLY
	float4 Reflection = tex2D(WaterEffectTex, Tex);
	Reflection.rgb *= WaterColor;
	
	if (Reflection.a < 0.5f){
		Reflection.a = 0;
	}	
#else
	float4 Reflection = 0;
#endif
	
#ifdef COMPLETE
	//if (Reflection.a == 0){
		// Reflection
		float3 N = Normal;
		float3 V = CamPos - Input.Pos;
		
		float3 R = 2 * dot(N, V) * N - V;
		
		Reflection = texCUBE(ReflectionTex, R);
	//}
#endif
	
	PS_OUTPUT Out;
	Out.Color = Reflection * 0.75;
	return Out;
}