sampler2D Tex0;
sampler2D Tex1;
sampler2D Tex7;	// bumpmap

#include "dcOutputPos.HLSL"

struct PS_INPUT{
    float2 BumpTex0			: TEXCOORD0;
	float2 BumpTex1			: TEXCOORD1;
	
	dcNormalData(Normal, TEXCOORD2);
};

#include "dcMRT.HLSL"

PS_OUTPUT main(const PS_INPUT Input){
	// Compute normal
	float3 N0 = (tex2D(Tex7, Input.BumpTex0) - 0.5f) * 2;
	float3 N1 = (tex2D(Tex7, Input.BumpTex1) - 0.5f) * 2;
	
	
	
#ifndef HQ_POSNORMAL
	float3 Normal = (((N0 + N1) / 2) - 0.5f) * 2;
#else
	float3 Normal = (N0 + N1) / 2;
#endif
		
	PS_OUTPUT Out;
	OutputColor(0);
	OutputNormalEx(Normal, Input.Normal);
	OutputMaterial(0.5);

	return Out;
}