// transformations
float4x4 World;

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float2 Tex[4]			: TEXCOORD0;
};

struct VS_INPUT{
    float2 Pos				: POSITION;
    float2 Tex				: TEXCOORD0;
};

static float2 TexelKernel[4] = {
    { -0.5, -0.5 },
    { -0.5,  0.5 },

    {  0.5, -0.5 },
    {  0.5,  0.5 },
};

float2 InvTexSize;

VS_OUTPUT main(const VS_INPUT Input){
	float2 P;
	P.x = Input.Pos.x * World[0][0] + Input.Pos.y * World[0][1] + World[0][3];
	P.y = Input.Pos.x * World[1][0] + Input.Pos.y * World[1][1] + World[1][3];
	
	VS_OUTPUT Out;
    Out.Pos = float4(P, 0, 1);
    for (int i = 0; i < 4; i++){
		Out.Tex[i] = Input.Tex + TexelKernel[i] * InvTexSize;
	}                              

    return Out;
}