sampler2D MinTex;
sampler2D MaxTex;

struct PS_INPUT{
    float2 Tex[4]		: TEXCOORD0;
};

struct PS_OUTPUT{
    float4 Min			: COLOR0;
    float4 Max			: COLOR1;
};

PS_OUTPUT main(const PS_INPUT Input){
	float4 Min = 0;
	float4 Max = 0;

    for (int i = 0; i < 4; i++){
        float4 MinSample = tex2D(MinTex, Input.Tex[i]);
        float4 MaxSample = tex2D(MaxTex, Input.Tex[i]);
        
        Min = lerp(Min, lerp(MinSample, min(Min, MinSample), Min.a), MinSample.a);
        Max = lerp(Max, lerp(MaxSample, max(Max, MaxSample), Max.a), MaxSample.a);
        
        /*if (MinSample.a != 0){
			if (Min.a != 0){
				Min = min(Min, MinSample);
			}
			else Min = MinSample;
		}
		if (MaxSample.a != 0){
			if (Max.a != 0){
				Max = max(Max, MaxSample);
			}
			else Max = MaxSample;
		}*/
    }
    
    PS_OUTPUT Out;
    Out.Min = Min;
    Out.Max = Max;
    
	return Out;
}