// transformations
float4x4 AlphaLightMatrix;

struct VS_OUTPUT{
    float4 Pos				: POSITION;

	float2 Tex				: TEXCOORD0;
};

struct VS_INPUT{
    float3 Pos				: POSITION;
};

VS_OUTPUT main(const VS_INPUT Input){
	float2 Tex = mul(float4(Input.Pos, 1), AlphaLightMatrix);
	
	VS_OUTPUT Out;
    Out.Pos = float4(Input.Pos, 1);
	Out.Tex = Tex;
	return Out;
}
