sampler2D Tex0;

struct PS_INPUT{
    float2 Tex				: TEXCOORD0;
};

struct PS_OUTPUT{
    float4 Color			: COLOR;
};

//#define HORIZONTAL

#ifdef HORIZONTAL
static float2 TexelKernel[13] = {
	{ -6, 0 },
	{ -5, 0 },
	{ -4, 0 },
	{ -3, 0 },
	{ -2, 0 },
	{ -1, 0 },
	{  0, 0 },
	{  1, 0 },
	{  2, 0 },
	{  3, 0 },
	{  4, 0 },
	{  5, 0 },
	{  6, 0 },
};

//static float InvTexSize = 1.0f / 800;

#endif

#ifdef VERTICAL
static float2 TexelKernel[13] = {
	{ 0, -6 },
	{ 0, -5 },
	{ 0, -4 },
	{ 0, -3 },
	{ 0, -2 },
	{ 0, -1 },
	{ 0,  0 },
	{ 0,  1 },
	{ 0,  2 },
	{ 0,  3 },
	{ 0,  4 },
	{ 0,  5 },
	{ 0,  6 },
};

#endif

static float BlurWeights[13] = {
	0.002216,
	0.008764,
	0.026995,
	0.064759,
	0.120985,
	0.176033,
	0.199471,
	0.176033,
	0.120985,
	0.064759,
	0.026995,
	0.008764,
	0.002216,
};

float InvTexSize;

PS_OUTPUT main(const PS_INPUT Input){
	float4 Color = 0;

    for (int i = 0; i < 13; i++){
        Color += tex2D(Tex0, Input.Tex + (TexelKernel[i] * InvTexSize)) * BlurWeights[i];
    }
    
    PS_OUTPUT Out;
    Out.Color = Color;
	return Out;
}