#include "dcVShaderConstants.HLSL"

#include "dcOutputPos.HLSL"

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    
	float2 Tex              : TEXCOORD0;
	dcNormalData(Normal, TEXCOORD1);
};

struct VS_INPUT{
    float3 Pos              : POSITION;
    float3 Normal           : NORMAL;
    float2 Tex              : TEXCOORD0;
    
#ifdef INSTANCED
	float4x4 World			: TEXCOORD1;
#endif
};

float Timer;

VS_OUTPUT main(const VS_INPUT Input){
#ifdef INSTANCED
	float4x4 World = Input.World;
#endif

	float3 Pos = mul(float4(Input.Pos, 1), World);
	float3 Normal = mul(Input.Normal, (float3x3)World);
	
	float Offset = Timer * 8;
	
	Pos += Normal * sin(Offset + Input.Tex.x * 11);
	Pos += Normal * sin(Offset + Input.Tex.x + Input.Tex.y * 13);
	Pos += Normal * sin(Offset + Input.Tex.x - Input.Tex.y * 17);
	
	Pos.y += sin(Offset + Input.Tex.x * 19);
	Pos.y += sin(Offset + Input.Tex.x + Input.Tex.y * 29);
	Pos.y += sin(Offset + Input.Tex.x - Input.Tex.y * 31);
	
	VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), ViewProj);
	Out.Tex = Input.Tex;

	OutputNormalData(Normal);
	OutputPosData(Pos);

    return Out;
}