// transformations
float4x4 AlphaLightMatrix;

float4x4 InvViewProj;
float3 CamPos;

float2 TexScale;

struct VS_OUTPUT{
    float4 Pos				: POSITION;
	float2 Tex				: TEXCOORD0;
	float3 ViewDir			: TEXCOORD1;
};

struct VS_INPUT{
    float3 Pos				: POSITION;
};

float3 GetVirtualPos(float2 ScreenPos){
	float Depth = 0.5f;

	float4 Pos;
	Pos.xy = ScreenPos;
	Pos.z = Depth;
	Pos.w = 1;
	
	Pos = mul(Pos, InvViewProj);
	return Pos.xyz / Pos.w;
}

VS_OUTPUT main(const VS_INPUT Input){
	VS_OUTPUT Out;
    Out.Pos = float4(Input.Pos, 1);
	Out.Tex = mul(Out.Pos, AlphaLightMatrix) * TexScale;
	
	float3 VirtualPos = GetVirtualPos(Out.Pos.xy);
    Out.ViewDir = CamPos - VirtualPos;

    return Out;
}