sampler2D Tex0;

struct PS_INPUT{
    float2 Tex				: TEXCOORD0;
};

struct PS_OUTPUT{
    float4 Color			: COLOR;
};

static float2 TexelKernel[16] = {
    { 1.5,  -1.5 },
    { 1.5,  -0.5 },
    { 1.5,   0.5 },
    { 1.5,   1.5 },

    { 0.5,  -1.5 },
    { 0.5,  -0.5 },
    { 0.5,   0.5 },
    { 0.5,   1.5 },

    {-0.5,  -1.5 },
    {-0.5,  -0.5 },
    {-0.5,   0.5 },
    {-0.5,   1.5 },

    {-1.5,  -1.5 },
    {-1.5,  -0.5 },
    {-1.5,   0.5 },
    {-1.5,   1.5 },
};

//static float2 InvTexSize = float2(1.0f / 800, 1.0f / 600);

float2 InvTexSize;

float BloomStart;
float InvBloomRange;

PS_OUTPUT main(const PS_INPUT Input){
	float4 Color = 0;

    for (int i = 0; i < 16; i++){
        Color += tex2D(Tex0, Input.Tex + (TexelKernel[i] * InvTexSize));
    }
    
    PS_OUTPUT Out;
    Out.Color = ((Color / 16) - BloomStart) * InvBloomRange;
	return Out;
}