#include "dcCubeNormalize.HLSL"

// Pixel data
sampler2D NormalTex;
sampler2D RenderTex;

// Light data
float3 LightDir;
float3 LightColor;

// Pixel input
struct PS_INPUT{
	float2 Tex0				: TEXCOORD0;
	float2 Tex1				: TEXCOORD1;
};

// Pixel output
struct PS_OUTPUT{
	float4 Color			: COLOR0;
};

PS_OUTPUT main(const PS_INPUT Input){
	float2 Tex0 = Input.Tex0;
	float2 Tex1 = Input.Tex1;

	// Normal data
	float4 NormalData = tex2D(NormalTex, Tex0);
	float3 Normal = (NormalData.xyz - 0.5f) * 2;
	
	// Compute diffuse
	float Dot = clamp(dot(LightDir, Normal), 0, 1);
	float3 Diffuse = LightColor * Dot;
	
	float4 Render = tex2D(RenderTex, Input.Tex1);

	PS_OUTPUT Out;
	Out.Color.rgb = Diffuse * Render.rgb;
	Out.Color.a = Render.a;

	return Out;
}