// transformations
float4x4 World : register(c0);

//#define SampleOffset 0
//#define SampleCount 6

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float2 Tex[SampleCount]	: TEXCOORD0;
};

struct VS_INPUT{
    float2 Pos				: POSITION;
    float4 Color			: COLOR0;
    float2 Tex				: TEXCOORD0;
};

//#define HORIZONTAL

#ifdef HORIZONTAL
static float2 TexelKernel[13] = {
	{ -6, 0 },
	{ -5, 0 },
	{ -4, 0 },
	{ -3, 0 },
	{ -2, 0 },
	{ -1, 0 },
	{  0, 0 },
	{  1, 0 },
	{  2, 0 },
	{  3, 0 },
	{  4, 0 },
	{  5, 0 },
	{  6, 0 },
};

//static float InvTexSize = 1.0f / 800;

#endif

#ifdef VERTICAL
static float2 TexelKernel[13] = {
	{ 0, -6 },
	{ 0, -5 },
	{ 0, -4 },
	{ 0, -3 },
	{ 0, -2 },
	{ 0, -1 },
	{ 0,  0 },
	{ 0,  1 },
	{ 0,  2 },
	{ 0,  3 },
	{ 0,  4 },
	{ 0,  5 },
	{ 0,  6 },
};

#endif
float2 InvTexSize;

VS_OUTPUT main(const VS_INPUT Input){
	float2 P;
	P.x = Input.Pos.x * World[0][0] + Input.Pos.y * World[0][1] + World[0][3];
	P.y = Input.Pos.x * World[1][0] + Input.Pos.y * World[1][1] + World[1][3];
	
	VS_OUTPUT Out;
    Out.Pos = float4(P, 0, 1);
    for (int i = 0; i < SampleCount; i++){
		Out.Tex[i] = Input.Tex + (TexelKernel[i + SampleOffset] * InvTexSize);
		//Out.Tex[i] /= InvTexSize;
	}                              

    return Out;
}