sampler2D Tex0;

//#define SampleOffset 0
//#define SampleCount 6

struct PS_INPUT{
    float2 Tex[SampleCount]	: TEXCOORD0;
};

struct PS_OUTPUT{
    float4 Color			: COLOR;
};

static float BlurWeights[13] = {
	0.002216,
	0.008764,
	0.026995,
	0.064759,
	0.120985,
	0.176033,
	0.199471,
	0.176033,
	0.120985,
	0.064759,
	0.026995,
	0.008764,
	0.002216,
};

float2 InvTexSize;

PS_OUTPUT main(const PS_INPUT Input){
	float4 Color = 0;

    for (int i = 0; i < SampleCount; i++){
        Color += tex2D(Tex0, Input.Tex[i]) * BlurWeights[SampleOffset + i] * 1.25;	// Compensate for limited precision in ps14
    }
    
    PS_OUTPUT Out;
    Out.Color = Color;;
	return Out;
}