sampler2D RenderTex;
sampler2D DiffuseTex;
sampler2D SpecularTex;
sampler2D MaterialTex;

sampler2D NormalTex;

float3 FogColor;
float4 LerpFogColor;

float3 Ambient;

struct PS_INPUT{
	float2 Tex0				: TEXCOORD0;
	float2 Tex1				: TEXCOORD1;
	float2 Tex2				: TEXCOORD2;
};

struct PS_OUTPUT{
	float4 Color			: COLOR0;
};

#include "dcOutputPos.HLSL"
#include "dcCubeNormalize.HLSL"

PS_OUTPUT main(const PS_INPUT Input){
	// Texture lookups
	float4 Render = tex2D(RenderTex, Input.Tex0);
	float3 Color = tex2D(DiffuseTex, Input.Tex1);
	Color += Ambient * Render.rgb;

	float4 NormalData = tex2D(NormalTex, Input.Tex2);

	// Color
#ifndef ALPHA
	Color = lerp(Render.rgb, Color, Render.a);
#else
	//Render.a = 1;
	Color *= Render.a;
#endif

	// Fogging
	float Fogging = NormalData.w;
	
#ifdef ADDFOG
	Render.rgb += FogColor * Fogging * Render.a;
#endif
	
#ifdef LERPFOG
	Color = lerp(Color, LerpFogColor.rgb, clamp(Fogging * LerpFogColor.a * Render.a, 0, 1));
#endif
		
	// Output
	PS_OUTPUT Out;
	Out.Color.rgb = Color;
#ifdef ALPHA
	Out.Color.a = Render.a;
#else
	Out.Color.a = 1;
#endif
	
	return Out;
}
