// transformations
float4x4 World;
float4x4 ViewProj;
float4x4 AlphaLightMatrix;
float3 CamPos;

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float4 ShadowColor		: COLOR0;
	float4 Tex				: TEXCOORD0;
	float3 ViewDir			: TEXCOORD1;
	float4x4 ShadowMatrix	: TEXCOORD2;
};

struct VS_INPUT{
    float3 Pos				: POSITION;
    float4 ShadowColor		: COLOR0;
    float4x4 ShadowMatrix	: TEXCOORD0;
};

VS_OUTPUT main(const VS_INPUT Input){
	VS_OUTPUT Out;
    Out.Pos = mul(float4(Input.Pos, 1), ViewProj);
    Out.ShadowColor = Input.ShadowColor;
	Out.Tex = mul(Out.Pos, AlphaLightMatrix);
	Out.ViewDir = Input.Pos - CamPos;
	Out.ShadowMatrix = Input.ShadowMatrix;
	
	return Out;
}