// Pixel data
sampler2D PosTex;
sampler2D NormalTex;
sampler2D Shadow;

#define HQ_POSNORMAL

// Utility functions
#include "dcOutputPos.HLSL"

// Pixel input
struct PS_INPUT{
	float4 ShadowColor		: COLOR0;
	float4 Tex				: TEXCOORD0;
	float3 ViewDir			: TEXCOORD1;
	float4x4 ShadowMatrix	: TEXCOORD2;
};

// Pixel output
struct PS_OUTPUT{
	float4 Color			: COLOR;
};

PS_OUTPUT main(const PS_INPUT Input){
	float4 NormalData = tex2Dproj(NormalTex, Input.Tex);
	
	float3 Pos = UnpackPos(NormalData.w, Input.ViewDir);
	
	float3 Normal = NormalData.xyz;
	
	float4 LightProj = mul(float4(Pos, 1), Input.ShadowMatrix);
	
	float4 Color = tex2Dproj(Shadow, LightProj) * Input.ShadowColor;

	PS_OUTPUT Out;
	Out.Color = Color;
	
	if (Normal.y < 0.707f){
		Out.Color.a = 0;
	}
	
	if (LightProj.z / LightProj.w <= 0){
		Out.Color.a = 0;
	}
	
	//Out.Color.rgb = Pos;
	//Out.Color.a = 1;
	
	
	return Out;
}