// transformations
float4x4 World;
float4x4 ViewProj;
float4x4 AlphaLightMatrix;
float3 CamPos;

float4x4 DecalMatrix;
float3 DecalDir;

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float4 Color			: COLOR0;
    
    float4 Tex				: TEXCOORD0;
#ifdef HQ_POSNORMAL
	float3 ViewDir			: TEXCOORD1;
#endif
};

struct VS_INPUT{
    float3 Pos				: POSITION;
    float3 Normal			: NORMAL;
};

VS_OUTPUT main(const VS_INPUT Input){
	float3 Pos = mul(float4(Input.Pos, 1), World);
	float3 Normal = mul(Input.Normal, World);

	VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), ViewProj);
#ifdef HQ_POSNORMAL
	Out.Tex = mul(Out.Pos, AlphaLightMatrix);
	Out.ViewDir = Pos - CamPos;
	Out.Color = 1;
#else
	Out.Tex = mul(float4(Pos, 1), DecalMatrix);
	if (dot(Normal, DecalDir) <= 0){
		Out.Color = 0;
	}
	else Out.Color = 1;
#endif
	
	return Out;
}