// Pixel data
sampler2D NormalTex;
sampler2D DecalTexture;
float4x4 DecalMatrix;
float3 DecalDir;

//#define HQ_POSNORMAL

// Utility functions
#include "dcOutputPos.HLSL"

// Pixel input 
struct PS_INPUT{
	float4 Tex				: TEXCOORD0;
	float4 Color			: COLOR0;
	
#ifdef HQ_POSNORMAL
	float3 ViewDir			: TEXCOORD1;
#endif
};

// Pixel output
struct PS_OUTPUT{
	float4 Color			: COLOR;
};

PS_OUTPUT main(const PS_INPUT Input){
#ifdef HQ_POSNORMAL
	float4 NormalData = tex2Dproj(NormalTex, Input.Tex);
	float3 Pos = UnpackPos(NormalData.w, Input.ViewDir);
	float3 Normal = NormalData.xyz;
	
	float4 LightProj = mul(float4(Pos, 1), DecalMatrix);
#else
	float4 LightProj = Input.Tex;
#endif
	float4 Color = tex2D(DecalTexture, LightProj.xy);
	if (LightProj.z >= 1 || LightProj.z <= 0){
		Color = 0;
	}
#ifdef HQ_POSNORMAL
	if (dot(Normal, DecalDir) <= 0){
		Color = 0;
	}
#endif

	Color *= Input.Color;

	PS_OUTPUT Out;
	Out.Color = Color;
	return Out;
}