#include "dcVShaderConstants.HLSL"

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float4 Diffuse			: COLOR0;
	float2 Tex              : TEXCOORD0;
};

struct VS_INPUT{
    float3 Pos              : POSITION;
    float2 Tex              : TEXCOORD0;
#ifdef INSTANCED
	float4x4 World			: TEXCOORD1;
#endif
};

VS_OUTPUT main(const VS_INPUT Input){
#ifdef INSTANCED
	float4x4 World = Input.World;
#endif
	float3 Pos = mul(float4(Input.Pos, 1), World);

	VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), ViewProj);
	Out.Diffuse = float4(1, 1, 1, MatDiffuse.a);
	Out.Tex = Input.Tex;
    return Out;
}