#include "dcVShaderConstants.HLSL"

float4x4 AlphaLightMatrix;

struct VS_OUTPUT{
    float4 Pos				: POSITION;
#ifndef LIGHT
    float4 Color			: COLOR0;
	float2 Tex              : TEXCOORD0;
#else
	float4 Tex				: TEXCOORD0;
	float3 WorldPos			: TEXCOORD1;
#endif
};

struct VS_INPUT{
    float3 Pos              : POSITION;
    
    float4 Color0			: COLOR0;
    float4 Color1			: COLOR1;
    
    float2 Tex              : TEXCOORD0;
    
    float3 Gravity			: TEXCOORD1;
    float3 StartVel			: TEXCOORD2;
    float4 Timing			: TEXCOORD3;
    float3 Sizing			: TEXCOORD4;
};

float Timer;

VS_OUTPUT main(const VS_INPUT Input){
	// Data unpacking
	float StartTime = Input.Timing.x;
	float FadeStart = Input.Timing.y;
	float FadeSpeed = Input.Timing.z;
	float TTL = Input.Timing.w;
	
	float Width = Input.Sizing.x;
	float GrowStart = Input.Sizing.y;
	float GrowSpeed = Input.Sizing.z;

	// Data
	float T = max(Timer - StartTime, 0);
	float3 A = Input.Gravity.xyz;
	float3 V0 = Input.StartVel.xyz;
	
	// S(T) = S(0) + V(0)T + 1/2AT^2
	float3 Pos = Input.Pos + (V0 * T) + (0.5f * A * T * T);
	
	// V(T) = V(0) + A(T)
	float3 Vel = V0 + A * T;
	
	float3 Dir = normalize(Vel);
	
	float3 CamDir = normalize(Pos - CamPos);

	float3 Axis = normalize(cross(CamDir, Dir));
	
	if (T >= GrowStart){
		Width += Width * (T - GrowStart) * GrowSpeed;
	}
	
#ifndef LIGHT
	Pos += Axis * Width;
#else
	Pos += Axis * Width * 15;
#endif
	
	float4 Color = lerp(Input.Color0, Input.Color1, clamp((T - FadeStart * TTL) / (FadeSpeed * TTL), 0, 1));
	if (Timer - StartTime <= 0){
		Color.a = 0;
	}

	VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), ViewProj);
#ifndef LIGHT
    Out.Color = Color;
	Out.Tex = Input.Tex;
#else
	Out.Tex = mul(Out.Pos, AlphaLightMatrix);
	Out.WorldPos = Pos;
#endif

    return Out;
}