#include "dcVShaderConstants.HLSL"

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float4 Color			: COLOR0;
	float2 Tex              : TEXCOORD0;
};

struct VS_INPUT{
    float3 Pos              : POSITION;
    
    float4 Color0			: COLOR0;
    float4 Color1			: COLOR1;
    
    float2 Tex              : TEXCOORD0;
    
    float4 Gravity			: TEXCOORD1;
    float4 StartVel			: TEXCOORD2;
    float4 Timing			: TEXCOORD3;
    float4 Sizing			: TEXCOORD4;
};

float Timer;

VS_OUTPUT main(const VS_INPUT Input){
	// Data unpacking
	float StartTime = Input.Timing.x;
	float FadeStart = Input.Timing.y;
	float FadeSpeed = Input.Timing.z;
	float TTL = Input.Timing.w;
	
	float2 Size = Input.Sizing.xy;
	float GrowStart = Input.Sizing.z;
	float GrowSpeed = Input.Sizing.w;
	
	float StartRoll = Input.StartVel.w;
	float RollSpeed = Input.Gravity.w;

	// Data
	float T = Timer - StartTime;
	float3 A = Input.Gravity.xyz;
	float3 V0 = Input.StartVel.xyz;
	
	// S(T) = S(0) + V(0)T + 1/2AT^2
	float3 Pos = Input.Pos + (V0 * T) + (0.5f * A * T * T);

	Pos = mul(float4(Pos, 1), (float4x3)View);
	
	if (T < TTL){
		if (T >= GrowStart){
			Size += Size * (T - GrowStart) * GrowSpeed;
		}
		
		float Roll = StartRoll + (RollSpeed * T);
		
		float2x2 RollMatrix;
		RollMatrix[0][0] =  cos(Roll);
		RollMatrix[1][0] = -sin(Roll);
		RollMatrix[0][1] =  sin(Roll);
		RollMatrix[1][1] =  cos(Roll);
		
		Size = mul(Size, RollMatrix);
		
		Pos.xy += Size;
	}
	
	float4 Color = lerp(Input.Color0, Input.Color1, clamp((T - FadeStart * TTL) / (FadeSpeed * TTL), 0, 1));

	VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), Proj);
    Out.Color = Color;
	Out.Tex = Input.Tex;

    return Out;
}