#include "dcVShaderConstants.HLSL"

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float4 Diffuse			: COLOR0;
	float2 Tex              : TEXCOORD0;
};

struct VS_INPUT{
    float3 Pos              : POSITION;
	float4 Diffuse			: COLOR0;
    float2 Tex              : TEXCOORD0;
};

VS_OUTPUT main(const VS_INPUT Input){
	float3 Pos = mul(float4(Input.Pos, 1), (float4x3)View);

	VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), Proj);
	Out.Diffuse = Input.Diffuse;
	Out.Tex = Input.Tex;
    return Out;
}