// ---------------------------------------------------
// Created by EASO
// 	Must be kept in synch with FIFA EASO IDL 
//
// Edit history:
// 	DSEWELL  4:20 p.m. 25/08/2003 : Updated language map
// 	DSEWELL 10:06 a.m. 12/09/2003 : Added getSKU(...) handler by way of GetInstallLanguageAsString in FIFA IDL
// ---------------------------------------------------

function _debug (str)
{
	// alert (str); //comment this out to stop debug  alerts ..
}

function GameAPI()
{
	this.numTeams = 32 ;
	this._gi = window.external.GameInterface;
	_debug (" hey,  debugging the game api");
}

GameAPI.prototype.getLanguage = function () 
{
	if ("GetLanguageAsString" in this._gi )
	{
		strLang = this._gi.GetLanguageAsString();
		// mapping from FIFA string language codes to EASO codes
		if( strLang == "eng" ) return "en";  // English
		if( strLang == "fre" ) return "fr";  // French
		if( strLang == "ita" ) return "it";  // Italian
		if( strLang == "ger" ) return "de";  // German
		if( strLang == "spa" ) return "es";  // Spanish
		if( strLang == "dut" ) return "nl";  // Dutch
		if( strLang == "swe" ) return "sv";  // Swedish
		if( strLang == "por" ) return "pt";  // Portuguese
		if( strLang == "pol" ) return "pl";  // Polish
		if( strLang == "kor" ) return "ko";  // Korean
		if( strLang == "brp" ) return "pt2"; // Brazilian Portuguese
		if( strLang == "jpn" ) return "ja";  // Japanese
		if( strLang == "nor" ) return "no";  // Norwegian
		if( strLang == "dan" ) return "da";  // Danish
		if( strLang == "gre" ) return "el";  // Greek
		// FIFA does not support Finnish (fi)	
		alert( "Did not recognise FIFA lang code " + strLang + " using en" );
		return "en";
	}
	else
	{   
		alert( "FIFA uses the GetLanguageAsString interface. However this api call is missing");
		// backward compatible ..
		iLan = this._gi.GetLanguage(  );
        	if (iLan ==0)
           		return "en";
        	else if (iLan ==1)
           		return "fr"; //fix this
       		else if (iLan ==2)
           		return "ge"; //fix this
	}
}

GameAPI.prototype.getRegKey = function () 
{
	 return this._gi.GetRegKey(  );
}

GameAPI.prototype.setMyPlayerId = function (sId)
{
	_debug ("setMyPlayerId: " + sId );	 
	return this._gi.SetMyPlayerId( sId  );
}
GameAPI.prototype.setOpponentPlayerId = function (sId)
{
	_debug ("setOpponentPlayerId: " + sId );	 
	return this._gi.SetOpponentPlayerId( sId  );
}

GameAPI.prototype.getPlayerIP = function ()
{
	_debug ("get playerIp");	 
	return this._gi.GetPlayerIP(  );
}

 
GameAPI.prototype.setPeerIP = function (  sAddress )
{
	_debug ("setPeerIP" + sAddress );
	this._gi.SetPeerIP( sAddress);
}


GameAPI.prototype.setPeerLocalIP = function (  sAddress )
{
	_debug ("setPeerLocalIP" + sAddress );
	this._gi.SetPeerLocalIP( sAddress);
}


GameAPI.prototype.setIsGameHost = function (  bHost )
{
	_debug ("setIsGameHost" + bHost );
	this._gi.SetIsGameHost( bHost);
}

GameAPI.prototype.setEASOGameType = function (  eType )
{
 	_debug ("setEASOGameType" + eType );
	this._gi.SetIsTournament( eType);
}

GameAPI.prototype.setIsProPlay = function (  bOn )
{
 	_debug ("setIsProPlay" + bOn );
	this._gi.SetIsProPlay( bOn);
}

GameAPI.prototype.play = function ( )
{
	_debug ("play()" );
	this._gi.Play( );
}

GameAPI.prototype.quit = function ()
{
	_debug ("quit()" );
	this._gi.Quit( );
}

GameAPI.prototype.setUserName = function ( sName )
{
	_debug ("setUserName" +sName );
	this._gi.SetUserName  ( sName);
}

GameAPI.prototype.setOpponentUserName = function ( sName )
{
	_debug ("setUserName" +sName );
	this._gi.SetOpponentUserName  ( sName);
}


GameAPI.prototype.setAudioCallback = function (  callback)
{
	_debug ("setting audio callback " + callback);
	this._gi.SetAudioCallback( callback);
}

GameAPI.prototype.setLeagueId = function (   nLeagueId )
{
	_debug ("setLeagueId" + nLeagueId );
	var lid = parseInt(nLeagueId) ;
	this._gi.setLeagueId(  lid );
}

GameAPI.prototype.setTeamId = function (   nTeamID )
{
	_debug ("setTeamId" + nTeamID );
	var tid = parseInt(nTeamID) ;
	this._gi.SetTeamId(  tid );
}

GameAPI.prototype.setOpponentLeagueId = function (   nLeagueId )
{
	_debug ("setOpponentLeagueId" + nLeagueId );
	var lid = parseInt(nLeagueId) ;
	this._gi.setOpponentLeagueId(  lid );
}

GameAPI.prototype.setOpponentTeamId = function (   nTeamID )
{
	_debug ("setOpponentTeamId" + nTeamID );
	var tid = parseInt(nTeamID) ;
	this._gi.SetOpponentTeamId(  tid );
}
 

GameAPI.prototype.getMajorVersion = function ()
{
	return this._gi.GetMajorVersion();
}

GameAPI.prototype.getLeagues = function()
{
	return this._gi.GetLeagues () 
}

GameAPI.prototype.getTeams = function ( leagueId) 
{
	team =  this._gi.GetTeams( leagueId );
	_debug ("got Team " + team + " for  league" + leagueId );   
	return this._gi.GetTeams( leagueId );
}

GameAPI.prototype.getSKU = function () 
{
	//return this._gi.GetSKU; // For clarity this method has been renamed

	if ("GetInstallLanguageAsString" in this._gi )
	{
		strLang = this._gi.GetInstallLanguageAsString();
		// The language codes are in flux so we are only providing the korean special case.
		if( strLang == "na"  ) return "na";  // North American (EN_UK-NA CD with system region set to North American area)
		if( strLang == "kor" ) return "ko";  // Korean
		if( strLang == "eng" ) return "en";  // English (fall back for non-specialcase)
		return "en"; // Failsafe
	}
	else
	{
		alert( "getSKU calls GetInstallLanguageAsString on FIFA - this function was not found however. Returning english code.");
		return "en";
	}
}





GameAPI.prototype.setHalfLength = function (  nLength ) 
{
        _debug ("setHalfLength" +nLength );
	this._gi.SetHalfLength( nLength);
}

GameAPI.prototype.setSkill = function (  eLevel ) 
{
	_debug ("setSkeill " + eLevel);
	this._gi.SetSkill( eLevel);
}
GameAPI.prototype.setInjuries = function (  bOn ) 
{	
	_debug ("swtInjuries " + bOn );
	this._gi.SetInjuries( bOn);
}
GameAPI.prototype.setBookings = function (  bOn ) 
{
	_debug ("setBookings" + bOn );
	this._gi.SetBookings( bOn);
}
GameAPI.prototype.setSpeed = function (  iSpeed ) 
{
	_debug ("setSpeed" + iSpeed );
	this._gi.SetSpeed( iSpeed);
}

GameAPI.prototype.setGameKey = function (sGKey) 
{
	_debug ("setGameKey" + sGKey);
 	this._gi.SetGKey(sGKey);
}

GameAPI.prototype.setDemangler = function (demangler)
{
	_debug ("setDemangler=" + demangler);
	this._gi.SetDemanglerServer(demangler);
}

GameAPI.prototype.setHostAddress = function (sHost)
{
	_debug ("setHostAddress = " + sHost);
	this._gi.SetLobbyServer(sHost);
}
