function connect(roomSettings, playerSettings, lkey, roomKey)
{
	try {
		spWrap.Disconnect();
		var rSettings = xmlToSetting(roomSettings) ;
		var pSettings =  xmlToSetting(playerSettings) ;
		spWrap.Connect(rSettings, pSettings, lkey, roomKey, "pogo");
		rSettings = pSettings = roomSettings = playerSettings = lkey = roomKey = null ;
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}


function disconnect()
{
	try {
		spWrap.Disconnect() ;
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function sendChat(amsg)
{
	var msg = decodeURIComponent(amsg) ;
	try {
		spWrap.SendChat(msg,1);
		msg = null ;
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function createGame(gameState, playerState)
{
	try {
		var gameSetting = xmlToSetting(gameState);
		var playerSetting = xmlToSetting(playerState);
		spWrap.CreateGame(gameSetting,playerSetting);
		gameState = playerState = gameSetting = playerSetting = null ; 
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function leaveGame()
{
	try {
		spWrap.LeaveGame();
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function joinGame(gameId, playerState)
{
	try {
		var playerSetting = xmlToSetting(playerState);
		spWrap.JoinGame(gameId, playerSetting);
		gameId = playerState = null ;
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function watchGame(gameId, playerState)
{
	try {
		var playerSetting = xmlToSetting(playerState);
		spWrap.WatchGame(gameId,playerSetting);
		gameId = playerState = null ; 
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function setGameState(gameState,playerState)
{
	try {
		var gameSetting = xmlToSetting(gameState);
		var playerSetting = xmlToSetting(playerState);
		spWrap.SetGameState(gameSetting, playerSetting);
		gameState = playerState = null ; 
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function setPlayerRoomState(state)
{
	try {
		var setting = xmlToSetting(state);
		spWrap.SetPlayerRoomState(setting);
		state = null ;
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function dismissPlayer(playerId) 
{
	try {
		spWrap.DismissPlayer(playerId);
		playerId = null ;
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function askServerToLaunchGame()
{
	try {
		spWrap.LaunchGame();
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}

function setMode(mode)
{
	try {
		spWrap.SetMode(mode);
		state = null ;
	} catch (err) {
		easoMain.SetVariable("_JSErrorCode", ERR_DLL_NOT_REGISTERED);
	}	
}
