
spWrap.setFlashEventListener	= function(sVarSpec)
{
	if (!sVarSpec) {
		sVarSpec = "/mcContent1:mpEvent";
	};
	this.asel = sVarSpec;
	return this.asel;
};
spWrap.getFlashEventListener	= function()
{
	return this.asel;
};
spWrap.sendFlashEvent			= function()
{
	easoMain.SetVariable((this.asel+".fireEvent"), (new Date()).getTime());
};

spWrap.setIsGoingIntoGame			= function(bool)
{
	this.playingGame 	= (bool) ? true : false;
};
spWrap.getIsGoingIntoGame			= function()
{
	return this.playingGame;
};
spWrap.playingGame	= false;

spWrap.setFlashEventListener();

function spWrap::OnConnectionError(code,errorMsg) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_CONNECTION_ERROR);
	easoMain.SetVariable((this.asel+".errorCode"), code);
	easoMain.SetVariable((this.asel+".errorMessage"), errorMsg);
	code=errorMsg=null ;
	this.sendFlashEvent();
}

function spWrap::OnError(errorMsg) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_ERROR);
	easoMain.SetVariable((this.asel+".errorMessage"), errorMsg);
	errorMsg = null ;
	this.sendFlashEvent();
}

function spWrap::OnErrorReceived(errorCode,msg,isFatal) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_ERROR_RECEIVED);
	easoMain.SetVariable((this.asel+".errorCode"), errorCode);
	easoMain.SetVariable((this.asel+".errorMessage"), msg);
	easoMain.SetVariable((this.asel+".errorIsFatal"), isFatal);
	errorCode=msg=isFatal=null ;
	this.sendFlashEvent();
}

function spWrap::OnChatReceived(playerId,amsg,channel) {
	var msg = encodeURIComponent(amsg);
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_CHAT_RECEIVED);
	easoMain.SetVariable((this.asel+".playerId"), playerId);
	easoMain.SetVariable((this.asel+".chatMessage"), msg);
	easoMain.SetVariable((this.asel+".chatChannel"), channel);
	playerId=msg=channel=null ;
	this.sendFlashEvent();
}

function spWrap::OnGameRemoved(gameId) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_GAME_REMOVED);
	easoMain.SetVariable((this.asel+".gameId"), gameId);
	gameId = null ;
	this.sendFlashEvent();
}

function spWrap::OnGameStateUpdate(gameId,state) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_GAME_STATE_UPDATE);
	easoMain.SetVariable((this.asel+".gameId"), gameId);
	easoMain.SetVariable((this.asel+".state"), settingToXML(state));
	gameId=state=null;
	this.sendFlashEvent();
}

function spWrap::OnInitialization(playerId,maxGames,maxPlayers,maxPlayersInGames,flags,serverTime) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_INITIALIZATION);
	easoMain.SetVariable((this.asel+".playerId"), playerId);
	easoMain.SetVariable((this.asel+".maxGames"), maxGames);
	easoMain.SetVariable((this.asel+".maxPlayers"), maxPlayers);
	easoMain.SetVariable((this.asel+".maxPlayersInGames"), maxPlayersInGames);
	easoMain.SetVariable((this.asel+".flags"), flags);
	easoMain.SetVariable((this.asel+".serverTime"), serverTime);
	playerId=maxGames=maxPlayers=maxPlayersInGames=flags=serverTime=null;
	this.sendFlashEvent();
}

function spWrap::OnLaunchGame(errorCode,gameId,launchCount,joinType) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_LAUNCH_GAME);
	easoMain.SetVariable((this.asel+".gameId"), gameId);
	easoMain.SetVariable((this.asel+".launchCount"), launchCount);
	easoMain.SetVariable((this.asel+".joinType"), joinType);
	errorCode=gameId=launchCount=joinType=null;
	this.sendFlashEvent();
}

function spWrap::OnLoadState(state) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_LOAD_STATE);
	easoMain.SetVariable((this.asel+".loadState"), state);
	state=null;
	this.sendFlashEvent();
}

function spWrap::OnNewGame(gameId,settings) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_NEW_GAME);
	easoMain.SetVariable((this.asel+".gameId"), gameId);
	easoMain.SetVariable((this.asel+".settings"), settingToXML(settings));
	gameId=settings=null;
	this.sendFlashEvent();
}

function spWrap::OnNewPlayer(playerId,playerName,playerInfo) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_NEW_PLAYER);
	easoMain.SetVariable((this.asel+".playerId"), playerId);
	easoMain.SetVariable((this.asel+".playerName"), playerName);
	easoMain.SetVariable((this.asel+".playerInfo"), settingToXML(playerInfo));
	playerId=playerName=playerInfo=null;
	this.sendFlashEvent();
}

function spWrap::OnPlayerEntersGame(playerId,gameId,settings) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_PLAYER_ENTERS_GAME);
	easoMain.SetVariable((this.asel+".playerId"), playerId);
	easoMain.SetVariable((this.asel+".gameId"), gameId);
	easoMain.SetVariable((this.asel+".settings"), settingToXML(settings));
	playerId=gameId=settings=null;
	this.sendFlashEvent();
}

function spWrap::OnPlayerGameStateUpdate(playerId,gameId,state) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_PLAYER_GAME_STATE_UPDATE);
	easoMain.SetVariable((this.asel+".playerId"), playerId);
	easoMain.SetVariable((this.asel+".gameId"), gameId);
	easoMain.SetVariable((this.asel+".state"), settingToXML(state));
	playerId=gameId=state=null;
	sendFlashEvent();
}

function spWrap::OnPlayerLeavesGame(playerId,gameId,reason) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_PLAYER_LEAVES_GAME);
	easoMain.SetVariable((this.asel+".playerId"), playerId);
	easoMain.SetVariable((this.asel+".gameId"), gameId);
	easoMain.SetVariable((this.asel+".reason"), reason);
	playerId=gameId=reason=null;
	this.sendFlashEvent();
}

function spWrap::OnPlayerLeavesRoom(playerId) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_PLAYER_LEAVES_ROOM);
	easoMain.SetVariable((this.asel+".playerId"), playerId);
	playerId=null;
	this.sendFlashEvent();
}

function spWrap::OnPlayerRoomStateUpdate(playerId,state) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_PLAYER_ROOM_STATE_UPDATE);
	easoMain.SetVariable((this.asel+".playerId"), playerId);
	easoMain.SetVariable((this.asel+".state"), settingToXML(state));
	playerId=state=null;
	this.sendFlashEvent();
}

function spWrap::OnQueryGameResponse(gameId,errorcode,refId,response) {
	gameId=errorCode=refId=response=null;
}

function spWrap::OnReconnected() {
}

function spWrap::OnRoomStateUpdate(state) {
	easoMain.SetVariable((this.asel+".eventId"), EVENT_ON_ROOM_STATE_UPDATE);
	easoMain.SetVariable((this.asel+".state"), settingToXML(state));
	state=null;
	this.sendFlashEvent();
}


