function Dictionary()
{
	this._items		= new Array();
	this._nextID	= -1;
};

Dictionary.prototype.getItem			= function(idx)
{
	if (isNaN(parseInt(idx))) { return null; }
	if (!this._items[idx]) { return null; };
	return this._items[idx];
};
Dictionary.prototype.getNamedItem		= function(name)
{
	if (typeof(name) != "string") { return null; };
	if (!this._items[parseInt(this._items[name])]) { return null; };
	return this._items[parseInt(this._items[name])];
};
Dictionary.prototype.addItem			= function(item)
{
	var strID	 		= "d_" + this._nextID;
	this._items.push(item);
	this._items[strID] 		= this._items.length-1;
	this._nextID++;
	return strID;
};
Dictionary.prototype.addNamedItem		= function(name, item)
{
	if (typeof(name) != "string") { return;  }
	if (isNaN(parseInt(this._items[name]))) {
		this._items.push(item);
		this._items[name]	= this._items.length -1;
		this._nextID++;
	} else {
		this._items[parseInt(this._items[name])] = item;
	};
	return this._items.length -1;
};
Dictionary.prototype.setNamedItem		= function(name, item)
{
	if (typeof(name) != "string") { return; };
	if (this._items[parseInt(this._items[name])]) {
		this._items[parseInt(this._items[name])] = item;
	};
};
Dictionary.prototype.setItem			= function(idx, item)
{
	if ( (!isNaN(parseInt(idx))) && (this._items[idx]) ){
		this._items[idx]		= item;
	};
};
Dictionary.prototype.removeItem			= function(idx)
{
	if (isNaN(parseInt(idx))) { return; };
	if (!this._items[idx]) { return; };
	var item;
	for (item in this._items)
	{
		if (isNaN(item)) {
			if (this._items[item] == idx) {
				delete this._items[item];
				break;
			};
		};
	};
	item = null;
	for (item in this._items)
	{
		if (isNaN(item)) {
			if (this._items[item] > idx) {
				this._items[item] = parseInt(this._items[item]) -1;
			};
		};
	};
	this._items.splice(idx, 1);
};
Dictionary.prototype.removeNamedItem	= function(name)
{
	this.removeItem(this._items[name]);
};
Dictionary.prototype.removeAll			= function()
{
	this._items.length 	= 0;
	this._items			= new Array();
};

Dictionary.prototype.contains		= function(item)
{

};
Dictionary.prototype.indexOf		= function(name)
{
	if (typeof(name) != "string") { return -1;  }
	if (isNaN(parseInt(this._items[name]))) { return -1; }
	return parseInt(this._items[name]);
};

Dictionary.prototype.getLength		= function()
{
	return this._items.length;
};


Dictionary.prototype.equals			= function(dict)
{
	if (dict === this) { return true; };
	if (dict == this) { return true; };
	if (!(dict instanceof Dictionary)) { return false; };
	if (this._items.length != dict._items.length) { return false; };
	for (var idx = (this._items.length -1); idx >= 0; idx--)
	{
		//alert(dict._items[idx].valueOf());
		//alert(this._items[idx].valueOf());
		if (dict._items[idx].valueOf() != this._items[idx].valueOf()) { return false; };
	};
	return true;
};

