; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
; 

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.


[command]
name = "slash2"
command = F,F
time = 15

[command]
name = "bushin"
command = a+b
time = 15

[command]
name = "Ballena"
command = a+c
time = 15

[Remap]
[command]
name = "Perros"
command = c+y
time = 15

[command]
name = "SHARINGANM"
command = c+x
time = 15

[command]
name = "Sharingan Off"
command = y+a
time = 15

a = a
[command]
name = "Sharongan On"
command = a+y
time = 15


[command]
name = "Doton"
command = B,a
time = 15

[command]
name = "Suiton"
command = B,b
time = 15

[command]
name = "cunai boom"
command = B,c
time = 15


[command]
name = "Combocar"
command = B,y
time = 15


[Command]
name = "holdc"
command = /$c
time = 1


[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.

command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
;-| Super Motions |--------------------------------------------------------

;-| Special Motions |------------------------------------------------------

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1


[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]


;Ballena
[State -1, Ballena]
type = ChangeState
value = 720
triggerall = helper, stateno != (730)
triggerall = power>= 2800
triggerall = command = "Ballena"
trigger1 = (statetype = s) && ctrl


;slash2
[State -1, slash2]
type = ChangeState
value = 290
triggerall = power>= 300
triggerall = command = "slash2"
trigger1 = (statetype = s) && ctrl


;bushin
[State -1, bushin]
type = ChangeState
value = 3900
triggerall = command = "bushin"
triggerall = power> 1200
triggerall = numhelper(20000) < 1
triggerall = helper, stateno != (20000)
trigger1 = (statetype = s) && ctrl


;Perros
[State -1, Perros]
type = ChangeState
value = 650
triggerall = helper, stateno != (660)
triggerall = helper, stateno != (670)
triggerall = helper, stateno != (680)
triggerall = power>= 1800
triggerall = command = "Perros"
trigger1 = (statetype = s) && ctrl


;Mang. Sharingan
[State -1, SHARINGANM]
type = ChangeState
value = 600
triggerall = helper, stateno != (602)
triggerall = power>= 5000
triggerall = life<= 800
triggerall = command = "SHARINGANM"
trigger1 = (statetype = s) && ctrl



;Suiton
[State -1, Suiton]
type = ChangeState
value = 460
triggerall = helper, stateno != (461)
triggerall = power>= 3000
triggerall = command = "Suiton"
trigger1 = (statetype = s) && ctrl


;Sharin Activado
[State -1, Sharin Activado]
type = ChangeState
value = 440
triggerall = power>= 1500
triggerall = var(6) = 0
triggerall = command = "Sharongan On"
trigger1 = (statetype = s) && ctrl

;Sharin Descativado
[State -1, Sharin Descativado]
type = ChangeState
value = 450
triggerall = var(6) = 1
triggerall = command = "Sharingan Off"
trigger1 = (statetype = s) && ctrl


;Doton
[State -1, Doton]
type = ChangeState
value = 418
triggerall = helper, stateno != (419)
triggerall = helper, stateno != (420)
triggerall = power>= 2000
triggerall = command = "Doton"
trigger1 = (statetype = s) && ctrl


;CombocarPerros
[State -1, Combocar]
type = ChangeState
value = 410
triggerall = helper, stateno != (413)
triggerall = helper, stateno != (414)
triggerall = helper, stateno != (415)
triggerall = helper, stateno != (416)
triggerall = helper, stateno != (417)
triggerall = power>=1800
triggerall = command = "Combocar"
trigger1 = (statetype = s) && ctrl

;cunai boomba
[State -1, cunai EX]
type = ChangeState
value = 240
triggerall = POWER > 800
triggerall = command = "cunai boom"
trigger1 = (statetype = s) && ctrl

;===========================================================================
;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
; Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;combo1-1
[State -1, combo1]
type = ChangeState
value = 200
triggerall = command = "a"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;combo cunai-1
[State -1, combo-cunai1]
type = ChangeState
value = 203
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl

;combo cunai-2
[State -2, comco-cunai1]
type = ChangeState
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 203
value = 204

;combo cunai-3
[State -3, combo-cunai1]
type = ChangeState
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
trigger1 = statetype = S
trigger1 = time > 5
trigger1 = ctrl
trigger2 = stateno = 204
value = 205
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
; Omoto Renge
[State -1, omoto]
type = ChangeState
value = 400
triggerall = power>=  3200
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
; Golpe en el aire
[State -1, Golpe en el aire]
type = ChangeState
value = 209
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
; Agarre
[State -1,agarre]
type = ChangeState
value = 210
triggerall = command = "b"
trigger1 = statetype = S
trigger1 = ctrl
;--------------------------------------------------------------------------
; Cunai en el aire
[State -1, Cunai-Aerea]
type = ChangeState
value = 220
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
; cunai
[State -1,Cunai]
type = ChangeState
value = 230
triggerall = helper, stateno != (231)
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;Katon
[State -1, Katon]
type = ChangeState
value = 250
triggerall = helper, stateno != (253)
triggerall = power>= 2200
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------

; Fire Boll
[State -1, Fire Boll]
type = ChangeState
value = 260
triggerall = helper, stateno != (261)
triggerall = helper, stateno != (262)
triggerall = power>=  3100
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------

;katon aire
[State -1, katon aire]
type = ChangeState
value = 263
triggerall = command = "c"
triggerall = power >= 2000
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; suelo
[State -1, Suelo]
type = ChangeState
value = 270
triggerall = power>=  1900
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
; Cunai explosiva Aire
[State -1, Cunai explosiva Aire]
type = ChangeState
value = 280
triggerall = power > 800
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
; Chakra
[State -1, Chakra]
type = ChangeState
value = 300
triggerall = helper, stateno != (300)
triggerall = command = "hold_z"
triggerall = power < 8000
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Rasengan
[State -1, rasengan]
type = ChangeState
value = 430
triggerall = power>= 1000
triggerall = command = "hold_b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;--------------------------------------------------------------------------
; Pared De Perros
[State -1, Pared De Perros]
type = ChangeState
value = 405
triggerall = power>= 3400
triggerall = helper, stateno != (406)
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
; Super Velocidad
[State -1, SLASH1]
type = ChangeState
value = 470
triggerall = power>= 300
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl

;--------------------------------------------------------------------------
; Raikiris
[State -1, Raikiri]
type = ChangeState
value = 500
triggerall = power>=  4200
triggerall = command = "hold_s"
trigger1 = statetype != A
trigger1 = ctrl
;--------------------------------------------------------------------------
;Katon Aire
;[State -1, Katon aire]
;type = ChangeState
;value = 700
;triggerall = power>= 1600
;triggerall = command = "holdc"
;trigger1 = statetype = A
;trigger1 = ctrl
;--------------------------------------------------------------------------
; Sustitucion
[State -1, Substitution]
type = ChangeState
value = 990
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = var(51) = 1
trigger2 = random = (600,800]
trigger2 = statetype = S
trigger2 = ctrl
trigger2 = p2dist x < 30
trigger2 = power >= 0
;--------------------------------------------------------------------------

