; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;
[Command]
name = "TripleKFPalm"
command = ~D, DF, F, D, DF, F, x
time = 20

[Command]
name = "TripleKFPalm"   ;Same name as above
command = ~D, DF, F, D, DF, F, y
time = 20

[Command]
name = "SmashKFUpper"
command = ~D, DB, B, D, DB, B, x;~F, D, DF, F, D, DF, x
time = 20

[Command]
name = "SmashKFUpper"   ;Same name as above
command = ~D, DB, B, D, DB, B, y;~F, D, DF, F, D, DF, y
time = 20

;-| Special Motions |------------------------------------------------------
[Command]
name = "upper_x"
command = ~F, D, DF, x

[Command]
name = "upper_y"
command = ~F, D, DF, y

[Command]
name = "upper_xy"
command = ~F, D, DF, x+y

[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y

[Command]
name = "QCB_x"
command = ~D, DB, B, x

[Command]
name = "QCB_y"
command = ~D, DB, B, y

[Command]
name = "QCB_xy"
command = ~D, DB, B, x+y

[Command]
name = "FF_ab"
command = F, F, a+b

[Command]
name = "FF_a"
command = F, F, a

[Command]
name = "FF_b"
command = F, F, b

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Super Motions |---------------------------------------------------------
[Command]
name = "wan xiang1"
command = ~D, DF, F,c
time = 20

[Command]
name = "wan xiang2"
command = ~D, DB, B,c
time = 20

[Command]
name = "ren jian"
command = ~D, DF, F, a
time = 20

[Command]
name = "di yu"
command = ~D, DB, B, b
time = 20

[Command]
name = "xiu luo"
command = ~D, DF, F, y
time = 20

[Command]
name = "xiu luo2"
command = ~D, DB, B, y
time = 20

[Command]
name = "chu sheng"
command = ~D, DF, F, x
time = 20

[Command]
name = "e gui"
command = ~D, DB, B, a
time = 20

[Command]
name = "super shinra"
command = ~D, DF, F,z
time = 20

[Command]
name = "di bao"
command = ~D, DB, B,z
time = 20

[Command]
name = "chu sheng2"
command = ~D, DB, B,x
time = 20

[Command]
name = "chu sheng3"
command = ~D, DF, F,b
time = 20

[Command]
name = "konan"
command = b+y
time = 1


;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "s"
command = s
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "start"
command = s
time = 1

[Command]
name = "z"
command = z
time = 1


;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holds";Required (do not remove)
command = /$s
time = 1

[Command]
name = "UP" ;Required (do not remove)
command = U
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1


;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]
;---------------------------------------------------------------------------
;konan
[State -1]
type = Changestate
value = 8300
triggerall = command = "konan" && power >= 300
trigger1 = statetype = S
trigger1 = ctrl

;lunhuiyan on
[State -1, on]
type = ChangeState
value = 440
triggerall = power>= 100
triggerall = var(6) = 0
triggerall = command = "s"
trigger1 = (statetype = C) && ctrl

;lunhuiyan off
[State -1, off]
type = ChangeState
value = 450
triggerall = var(6) = 1
triggerall = command = "s"
trigger1 = (statetype = C) && ctrl

[State -1]
type = Changestate
value = 4200
triggerall = command = "di bao" && power >= 3000 && life <= 5000000
trigger1 = statetype = S
trigger1 = ctrl

[State -1]
type = Changestate
value = 8200
triggerall = command = "chu sheng3" && power >= 1000
trigger1 = statetype = S && p2bodydist x < 120
trigger1 = ctrl

[State -1]
type = Changestate
value = 8500
triggerall = command = "chu sheng3" && power >= 1000
trigger1 = statetype = S && p2bodydist x > 120
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 3999
triggerall = command = "di yu" && power >= 1000 && life <= 500000
trigger1 = statetype = S
trigger1 = ctrl

[State -1]
type = Changestate
value = 4999
triggerall = command = "di yu" && power >= 1000 && life >= 500
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 4000
triggerall = command = "wan xiang1" && power >= 1500
trigger1 = statetype = S
trigger1 = ctrl

[State -1]
type = Changestate
value = 4520
triggerall = command = "wan xiang2" && power >= 1500
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 3700
triggerall = command = "e gui" && power >= 1000
trigger1 = statetype = S && p2bodydist x > 50
trigger1 = ctrl

[State -1]
type = Changestate
value = 3530
triggerall = command = "e gui" && power >= 1000
trigger1 = statetype = S && p2bodydist x < 50
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 3600
triggerall = command = "chu sheng" && power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 3300
triggerall = command = "xiu luo" && power >= 1000
trigger1 = statetype = S
trigger1 = ctrl

; six paths
[State -1, Ssix paths]
type = ChangeState
value = 5530
triggerall = command = "z" && power >= 1500
trigger1 = statetype = C
trigger1 = ctrl

; Shinra Tensei
[State -1, Shinra Tensei]
type = ChangeState
value = 2500
triggerall = command = "c" && power >= 1000
trigger1 = statetype = C
trigger1 = ctrl

; Super Shinra Tensei
[State -1]
type = Changestate
value = 900
triggerall = command = "super shinra" && power >= 3000 && life <= 5000000
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 3200
triggerall = command = "ren jian" && power >= 1000
trigger1 = statetype = S && p2bodydist x < 30
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 3000
triggerall = command = "chu sheng2" && power >= 1000
trigger1 = statetype = S
trigger1 = ctrl

[State -1]
type = Changestate
value = 3320
triggerall = command = "xiu luo2" && power >= 1000
trigger1 = statetype = S
trigger1 = ctrl

[State -1]
type = Changestate
value = 3100
triggerall = command = "ren jian" && power >= 1000
trigger1 = statetype = S && p2bodydist x > 30
trigger1 = ctrl
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 208
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 206
trigger2 = time >= 10
;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 207
triggerall = command = "c" && numhelper(1239810) = 0
trigger1 = statetype != A
trigger1 = ctrl

[State -1, Air Weapon]
type = ChangeState
value = 380
trigger1 = command = "c"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1]
type = Changestate
value = 206
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
; Stand Light Punch
[State -1, c 1]
type = ChangeState
value = 200
triggerall = command = "x"
trigger1 = statetype != A
trigger1 = ctrl

[State -1,c 2]
type = ChangeState
value = 250
triggerall = command = "x"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 200

[State -1,c 3]
type = ChangeState
value = 255
triggerall = command = "x"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 250

[State -1,c 4]
type = ChangeState
value = 256
triggerall = command = "x"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 255

[State -1,c 5]
type = ChangeState
value = 257
triggerall = command = "x"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 256

;-----------------------------------------------------------------------------
; Stand Light Punch
[State -1, c 1]
type = ChangeState
value = 204
triggerall = command = "y"
trigger1 = statetype != A
trigger1 = ctrl

[State -1,c 2]
type = ChangeState
value = 205
triggerall = command = "y"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 204

[State -1,c 3]
type = ChangeState
value = 275
triggerall = command = "y"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 205

;-------------------------------------------------------------------
; Stand Light Punch
[State -1, c 1]
type = ChangeState
value = 228
triggerall = command = "a"
trigger1 = statetype != A
trigger1 = ctrl

[State -1,c 2]
type = ChangeState
value = 229
triggerall = command = "a"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 228

[State -1,c 3]
type = ChangeState
value = 230
triggerall = command = "a"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 229

[State -1,c 3]
type = ChangeState
value = 265
triggerall = command = "a"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 230
;=========================================================================
; Stand Light Punch
[State -1, c 1]
type = ChangeState
value = 200
triggerall = command = "b"
trigger1 = statetype != A
trigger1 = ctrl

[State -1,c 2]
type = ChangeState
value = 204
triggerall = command = "b"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 200

[State -1,c 3]
type = ChangeState
value = 545
triggerall = command = "b"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 204

;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 9998
triggerall = power < 3000
trigger1 = command = "hold_a" && command = "hold_x"
trigger1= statetype = S
trigger1= ctrl = 1
-----------------------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 302
triggerall = command = "z"
trigger1 = (stateno = 150 || stateno = 151) && power >= 200
trigger2 = (stateno = 152 || stateno = 153) && power >= 200
------------------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 302
Triggerall = alive
triggerall = power >= 200
triggerall = stateno != [120,155]
triggerall = command = "z"
trigger1 = movetype = H
trigger2 = stateno = 5030
trigger3 = stateno = 5035
;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl
;--------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 301
triggerall = command = "z" && power >= 100
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 300
triggerall = command = "z" && power >= 100
trigger1 = statetype != A
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 111
triggerall = command = "UP" 
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1, Wall Jump]
type = ChangeState
value = 46
triggerall = backedgebodydist <= 1 && backedgebodydist > -1
triggerall = command = "holdfwd"
triggerall = var(0) = 0
triggerall = Pos Y < -30
trigger1 = StateType = A
trigger1 = Ctrl
trigger1 = Vel X <= 0
