; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
[command]
name = "a+b"
command = a+b
time = 15

[Command]
name = "AI1"
command = D,B,D,B,D,B,UF, x+y
time = 1

[Command]
name = "AI2"
command = UF,D,B,D,B,D,B,D,B, y
time = 1

[Command]
name = "AI3"
command = D,B,D,B,D,B,D,B, a
time = 1

[Command]
name = "AI4"
command = UB,D,B,D,B,D,B,D,B, b
time = 1

[Command]
name = "AI5"
command = D,B,D,B,D,B,D,B, c
time = 1

[Command]
name = "AI6"
command = D,B,D,B,D,B,D,B, z
time = 1

[Command]
name = "AI7"
command = D,B,D,B,D,B,D,B, a+b+c+x+y+z
time = 1

[Command]
name = "AI8"
command = UF,D,F,D,F,D,F,D,F, x
time = 1

[Command]
name = "AI9"
command = D,F,D,F,D,F,D,F, y
time = 1

[Command]
name = "AI10"
command = UB,D,F,D,F,D,F,D,F, z
time = 1

[Command]
name = "AI11"
command = D,F,D,F,D,F,D,F, a
time = 1

[Command]
name = "AI12"
command = UF,D,F,D,F,D,F,D,F, b
time = 1

[Command]
name = "AI13"
command = D,F,D,F,D,F,D,F, c
time = 1

[Command]
name = "AI14"
command = UB,D,F,D,F,D,F,D,F, a+b+c+x+y+z
time = 1

[Command]
name = "AI15"
command = D,B,D,F,D,B,D,F, x
time = 1

[Command]
name = "AI16"
command = D,B,D,F,D,B,D,F,UF, y
time = 1

[Command]
name = "AI17"
command = D,B,D,F,D,B,D,F, z
time = 1

[Command]
name = "AI18"
command = D,B,D,F,D,B,D,F,UB, a
time = 1

[Command]
name = "AI19"
command = D,B,D,F,D,B,D,F, b
time = 1

[Command]
name = "AI20"
command = D,B,D,F,D,B,D,F, c
time = 1

[Command]
name = "AI21"
command = D,B,D,F,D,B,D,F, x+y+z+a+b+c
time = 1

[Command]
name = "AI22"
command = B,B,B,B,B,B,B,B, x+y+z+a+b+c
time = 1

[Command]
name = "AI23"
command = F,F,F,F,F,F,F,F, x+y+z+a+b+c
time = 1

[Command]
name = "AI24"
command = B,F,B,F,B,F,B,F, x+y+z+a+b+c
time = 1

[Command]
name = "AI25"
command = D,D,D,D,D,D,D,D, x+y+z+a+b+c
time = 1

[Command]
name = "AI26"
command = U,D,U,D,U,D,U,D, x+y+z+a+b+c
time = 1

[Command]
name = "AI27"
command = U,F,U,D,B,F,B,D, x+y+z+a+b+c
time = 1

[Command]
name = "AI28"
command = F,D,F,D,U,D,U,D, x+y+z+a+b+c
time = 1

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------

;-| Special Motions |------------------------------------------------------

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
[State -1, AI On]
type = VarSet
triggerall = var(56) != 1
trigger1 = command = "AI1"
trigger2 = command = "AI2"
trigger3 = command = "AI3"
trigger4 = command = "AI4"
trigger5 = command = "AI5"
trigger6 = command = "AI6"
trigger7 = command = "AI7"
trigger8 = command = "AI8"
trigger9 = command = "AI9"
trigger10 = command = "AI10"
trigger11 = command = "AI11"
trigger12 = command = "AI12"
trigger13 = command = "AI13"
trigger14 = command = "AI14"
trigger15 = command = "AI15"
trigger16 = command = "AI16"
trigger17 = command = "AI17"
trigger18 = command = "AI18"
trigger19 = command = "AI19"
trigger20 = command = "AI20"
trigger21 = command = "AI21"
trigger22 = command = "AI22"
trigger23 = command = "AI23"
trigger24 = command = "AI24"
trigger25 = command = "AI25"
trigger26 = command = "AI26"
trigger27 = command = "AI27"
trigger28 = command = "AI28"
var(56) = 1

;---------------------------------------------------------------------------
[State -1,AI Crouch]
type = changestate
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
trigger1 = statetype != A
trigger1 = pos Y = 0
trigger1 = ctrl
trigger1 = random <= 5
value = 11

;---------------------------------------------------------------------------
[State -1,AI Jump]
type = changestate
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
trigger1 = statetype != A
trigger1 = pos Y > 1
trigger1 = ctrl
trigger1 = random <= 5
value = 40
;---------------------------------------------------------------------------
[State -1,AI Guard]
type = changestate
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
trigger1 = p2bodydist X = [-1,75]
trigger1 = p2movetype = A
trigger1 = statetype = S
trigger1 = movetype != A
trigger1 = random <= 150
trigger1 = ctrl
value = 130
;---------------------------------------------------------------------------
[State -1,AI Kawarimmi]
type = changestate
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = power >= 500
trigger1 = p2bodydist X <= 25
trigger1 = statetype = S
trigger1 = movetype != A
trigger1 = p2statetype = S
trigger1 = p2stateno != [120,155]
trigger1 = random <= 10
trigger1 = ctrl
trigger1 = StateNo = 5000
trigger2 = StateNo = 5001
trigger3 = StateNo = 5010
trigger4 = StateNo = 5011
trigger5 = StateNo = 5020
trigger6 = StateNo = 5030
trigger7 = StateNo = 5035
trigger8 = StateNo = 5050
value = 830

;---------------------------------------------------------------------------
[State -1,AI Stand Light Punch]
type = ChangeState
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = p2Bodydist X <= 15
triggerall = statetype = S
trigger1 = ctrl
trigger1 = random <= 350
value = 200

;---------------------------------------------------------------------------
[State -1,AI Stand Medium Punch]
type = ChangeState
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 100
triggerall = p2Bodydist X <= 15
triggerall = stateno = 200
triggerall = statetype = S
trigger1 = ctrl
value = 210

;---------------------------------------------------------------------------
[State -1,AI Stand Strong Punch]
type = ChangeState
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 100
triggerall = p2Bodydist X <= 15
triggerall = statetype = S
triggerall = stateno = 210
trigger1 = ctrl
value = 220

;---------------------------------------------------------------------------
[State -1,AI Stand Light Kick]
type = ChangeState
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 100
triggerall = stateno = 220
triggerall = p2Bodydist X <= 15
triggerall = statetype = S
trigger1 = ctrl
value = 240

;---------------------------------------------------------------------------
[State -1,AI Grob]
type = ChangeState
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 500
triggerall = power >= 1000
triggerall = p2Bodydist X >= 50
triggerall = statetype = S
trigger1 = ctrl
value = 257

;---------------------------------------------------------------------------
[State -1,AI Lavina]
type = ChangeState
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 650
triggerall = power >= 2000
triggerall = p2Bodydist X >= 100
triggerall = statetype = S
trigger1 = ctrl
value = 259

;---------------------------------------------------------------------------
[State -1,AI Shukaku]
type = ChangeState
value = 263
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 450
triggerall = power >= 1500
triggerall = p2Bodydist X <= 40
trigger1 = statetype = s
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1,AI Fly]
type = ChangeState
value = 1018
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 370
triggerall = power >= 500
triggerall = p2Bodydist X <= 100
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1,AI Chakra]
type = ChangeState
value = 113
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 50
triggerall = power <= 3000
triggerall = p2Bodydist X >= 100
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1,AI Kop'yo]
type = ChangeState
value = 269
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 500
triggerall = power >= 3000
triggerall = p2Bodydist X >= 150
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1,AI Sand Bunshin]
type = ChangeState
value = 1015
Triggerall = Numhelper(16001) < 2
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 400
triggerall = power >= 500
triggerall = p2Bodydist X <= 70
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1,AI Run]
type = ChangeState
value = 100
triggerall = var(56) = 1
triggerall = roundstate = 2
triggerall = P2Life > 0
triggerall = random <= 1
triggerall = p2Bodydist X >= 150
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
; Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = stateno != 100
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Udar 1
[State -1, Udar 1]
type = ChangeState
value =  1036
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = stateno = 220
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
;---------------------------------------------------------------------------
; Udar 2
[State -1, Udar 2]
type = ChangeState
value =  1018250
triggerall = command = "c"
triggerall = command != "holddown"
triggerall = stateno = 220
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
;---------------------------------------------------------------------------
; Udar 3
[State -1, Udar 3]
type = ChangeState
value =  1071
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = stateno = 220
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
;---------------------------------------------------------------------------
; Udar 4
[State -1, Udar 4]
type = ChangeState
value =  1018250
triggerall = command = "a"
triggerall = command = "holdfwd"
triggerall = stateno = 100
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Stand Medium Punch
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = stateno = 200
triggerall = stateno != 100
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact

;---------------------------------------------------------------------------
; Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 220
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = stateno = 210
triggerall = stateno != 100
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact

;---------------------------------------------------------------------------
; Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = stateno = 220
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
;---------------------------------------------------------------------------
; Stand Medium Kick
[State -1, Stand Medium Kick]
type = ChangeState
value = 240
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = stateno = 230
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
;---------------------------------------------------------------------------
; Sand Shuriken
[State -1, Sand Shuriken]
type = ChangeState
value = 250
triggerall = command = "b"
triggerall = power >= 50
triggerall = var(10) = 0
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Teleport
[State -1, Teleport]
type = ChangeState
value = 2
triggerall = command = "c"
triggerall = command != "holddown"
triggerall = power >= 100
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Boll
[State -1, Boll]
type = ChangeState
value = 252
triggerall = command = "z"
triggerall = power >= 100
triggerall = var(10) = 0
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Stones
[State -1, Stones]
type = ChangeState
value = 112211
triggerall = command = "b"
triggerall = stateno = 0
triggerall = var(10) = 1
triggerall = power >= 100
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Grob
[State -1, Grob]
type = ChangeState
value = 257
triggerall = command = "x"
triggerall = command = "holdfwd"
trigger1 = statetype = s
triggerall = power >= 1000
trigger1 = ctrl
;---------------------------------------------------------------------------
; Lavina
[State -1, Lavina]
type = ChangeState
value = 259
triggerall = command = "x"
triggerall = command = "holdback"
trigger1 = statetype = s
triggerall = power >= 2000
trigger1 = ctrl
;---------------------------------------------------------------------------
; Pohoroni
[State -1, Pohoroni]
type = ChangeState
value = 262
triggerall = command = "y"
trigger1 = statetype = C
triggerall = var(10) = 0
triggerall = power >= 3000
trigger1 = ctrl
;---------------------------------------------------------------------------
; Shukaku
[State -1, Shukaku]
type = ChangeState
value = 263
triggerall = command = "x"
trigger1 = statetype = s
triggerall = numhelper(264) < 1
triggerall = power >= 1500
trigger1 = ctrl
;---------------------------------------------------------------------------
; Kopy'o
[State -1, Kop'yo]
type = ChangeState
value = 269
triggerall = command = "x"
trigger1 = statetype = c
triggerall = power >= 3000
trigger1 = ctrl
;---------------------------------------------------------------------------
;Chakra
[State -1, Chakra]
type = ChangeState
value = 113
triggerall = command = "s"
triggerall = power <= 3000
trigger1 = statetype = s
trigger1 = ctrl
;---------------------------------------------------------------------------
; Sand Bunshin
[State -1, Sand Bunshin]
type = ChangeState
value = 1015
Triggerall = Numhelper(16001) < 2
triggerall = command = "a"
triggerall = power >= 500
trigger1 = statetype = c
trigger1 = ctrl
;---------------------------------------------------------------------------
; Kawarimmi
[State -1, Kawarimmi]
Type = ChangeState
Value = 830
Triggerall = Command = "c" & power >=500
Trigger1 = StateNo = 5000
Trigger2 = StateNo = 5001
Trigger3 = StateNo = 5010
Trigger4 = StateNo = 5011
Trigger5 = StateNo = 5020
Trigger6 = StateNo = 5030
Trigger7 = StateNo = 5035
Trigger8 = StateNo = 5050
;---------------------------------------------------------------------------
; Fly
[State -1,Fly]
type = ChangeState
value = 1018
triggerall = power >= 500
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
; SandStone
[State -1,SandStone]
type = ChangeState
value = 1122
triggerall = command = "b"
trigger1 = statetype = c
triggerall = power >= 500
triggerall = var(10) = 0
trigger1 = ctrl
;---------------------------------------------------------------------------
; Desert
[State -1,Desert]
type = ChangeState
value = 1032
triggerall = command = "y"
triggerall = command = "holdfwd"
triggerall = power >= 3000
triggerall = var(10) = 0
trigger1 = statetype = s
trigger1 = ctrl
;---------------------------------------------------------------------------
; Volna
[State -1,Volna]
type = ChangeState
value = 1038
triggerall = command = "y"
triggerall = command = "holdback"
triggerall = power >= 3000
triggerall = var(10) = 0
trigger1 = statetype = s
trigger1 = ctrl
;---------------------------------------------------------------------------
; Tyurma
[State -1,Tyurma]
type = ChangeState
value = 1040
triggerall = command = "c"
triggerall = power >= 0
trigger1 = statetype = c
trigger1 = ctrl
;---------------------------------------------------------------------------
;Wall Run
[state -1, Wall Run]
type = changestate
value = 1053
triggerall = stateno = 50 || stateno = 40
triggerall = command = "holdback"
trigger1 = backedgedist < 5
trigger1 = command = "holdback"
trigger2 = frontedgedist < 5
trigger2 = command = "holdfwd"
;---------------------------------------------------------------------------
[State -1, Wall Jump]
type = ChangeState
value = 48
triggerall = backedgebodydist <= 1 && backedgebodydist > -1
triggerall = command = "holdfwd"
triggerall = var(0) = 0
triggerall = Pos Y < -30
trigger1 = StateType = A
trigger1 = Ctrl
trigger1 = Vel X <= 0
;---------------------------------------------------------------------------
; Sand God of Thunder
[State -1, Sand God of Thunder]
type = ChangeState
value = 1057
triggerall = command = "s"
triggerall = power >= 3000
triggerall = p2stateno != 1018
triggerall = p2statetype = S
trigger1 = statetype = C
trigger1 = ctrl
