; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
a
[command]
name = "sacrifi"
command = B,z
time = 25

[command]
name = "special"
command = D, /c
time = 15

[command]
name = "special2"
command = F, B, /b
time = 15

[command]
name = "fuuton"
command = D,DB,B,x
time = 15


;-| Special Motions |------------------------------------------------------
[Command]
name = "QCB_A"
command = D,DB,B,a
time = 15
[Command]
name = "QCB_B"
command = D,DB,B,b
time = 15
[Command]
name = "QCB_C"
command = D,DB,B,c
time = 15
[Command]
name = "QCB_X"
command = D,DB,B,x
time = 15
[Command]
name = "QCB_Y"
command = D,DB,B,y
time = 30

[Command]
name = "QCB_Z"
command = D,DB,B,z
time = 15
[Command]
name = "QCF_A"
command = D,DF,F,a
time = 15
[Command]
name = "QCF_B"
command = D,DF,F,b
time = 15
[Command]
name = "QCF_C"
command = D,DF,F,c
time = 15
[Command]
name = "QCF_X"
command = D,DF,F,x
time = 15
[Command]
name = "QCF_Y"
command = D,DF,F,y
time = 15

[Command]
name = "QCF_Z"
command = D,DF,F,z
time = 15
;-| Double Tap |-----------------------------------------------------------


[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.

[command]
name = "manda"
command = B,y
time = 25

command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30

[command]
name = "trocadecorpo"
command = B,x
time = 25

[Command]
name = "hold_x"
command = /x

[Command]
name = "hold_y"
command = /y

command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------

;-| Special Motions |------------------------------------------------------

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_s"
command = /$D,s
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

y = y
[command]
name = "wj"
command = /F
time = 15


[command]
name = "WS"
command = /a
time = 15

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

[command]
name = "kawrimi"
command = z
time = 10

[command]
name = "regenerao"
command = x
time = 10

[command]
name = "trocadepele"
command = y
time = 10


;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;---------------------------------------------------------------------------
; Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------

;teleport in air
[state -1, teleport in air]
type = changestate
value = 4100
triggerall = power >= 350
triggerall= command="c"
trigger1 = ctrl
trigger1 = statetype = a
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = command != "holdback"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Punch]
type = ChangeState
value = 198
triggerall = power >= 350
triggerall = command = "z"
triggerall = command != "holdfwd"
triggerall = command != "holddown"
triggerall = command != "holdback"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, 201]
type = ChangeState
value = 220
triggerall = command = "back_a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, 201]
type = ChangeState
value = 201
triggerall = stateno = 200
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 12

[State -1, 202]
type = ChangeState
value = 202
triggerall = stateno = 201
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 10
;---------------------------------------------------------------------------
; Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 270
triggerall = command = "y"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 240
triggerall = Var(35)= 0
triggerall = power >= 1500
triggerall = command = "QCF_C"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Punch]
type = ChangeState
value = 1600
triggerall = command = "QCB_C"
triggerall = power >= 2000
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, 201]
type = ChangeState
value = 271
triggerall = stateno = 270
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 12

[State -1, 202]
type = ChangeState
value = 272
triggerall = stateno = 271
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 8

; Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 273
triggerall = stateno = 272
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl >= 8


[State -1, 201]
type = ChangeState
value = 274
triggerall = stateno = 273
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 8
;---------------------------------------------------------------------------
; Stand Medium Punch
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = command != "holdback"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Stand Medium Punch
[State -1, Stand Medium Punch]
type = ChangeState
value = 160
triggerall = power >= 1200
triggerall = command = "down_s"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
; Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = command = "c"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
trigger1 = statetype = S
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
; Kusanagi
[State -1, Throw]
type = ChangeState
value = 4
triggerall = power >= 3000
triggerall = command = "down_c"
trigger1 = statetype = C
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
; Manda
[State -1, Throw]
type = ChangeState
value = 1500
triggerall = power >= 4000
triggerall = command = "down_z"
trigger1 = statetype = C
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
; Doble serpiente
[State -1, Throw]
type = ChangeState
value = 233
triggerall = power >= 1800
triggerall = command = "down_y"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
; Serpiente
[State -1, Throw]
type = ChangeState
value = 540
triggerall = power >= 100
triggerall = command = "x"
triggerall = stateno != [48, 56]
triggerall = stateno != [411, 415]
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
; Chakra
[State -1, Throw]
type = ChangeState
value = 10000
triggerall = command = "hold_s"
triggerall = power < 4000
trigger1 = statetype = S
trigger1 = stateno != [1050,1075]
trigger1 = ctrl

;===========================================================================
[State -1, Crouching Strong Punch]
type = ChangeState
value = 510000
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
triggerall = stateno = 5110
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Medium Punch
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------


;---------------------------------------------------------------------------
 ; Mueve lenguetazo
[State -1, Running attack]
type = ChangeState
value = 221
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;----------------------------------------
[State -1, Kusanagi]
type = ChangeState
value = 260
trigger1 = command = "QCF_X"
trigger1 = power >= 400
trigger1 = statetype = S
trigger1 = ctrl
;----------------------------------------
;----------------------------------------
[State -1, Kusanagi]
type = ChangeState
value = 660
trigger1 = command = "QCB_Z"
trigger1 = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
;----------------------------------------
;----------------------------------------
[State -1, Kusanagi]
type = ChangeState
value = 530
trigger1 = command = "a"
trigger1 = statetype = C
trigger1 = ctrl
;----------------------------------------
;----------------------------------------
[State -1, Kusanagi]
type = ChangeState
value = 225
triggerall = Var(30)= 0
trigger1 = command = "QCF_Y"
trigger1 = power >= 3000
trigger1 = statetype = S
trigger1 = ctrl
;----------------------------------------
 ; running attack
[State -1, Running attack]
type = ChangeState
value = 1290
triggerall = command = "fuuton"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;----------------------------------------
 ; running attack
[State -1, Running attack]
type = ChangeState
value = 899
triggerall = power >= 1500
triggerall = command = "down_b"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1, kawrimi]
type = ChangeState
value = 730
triggerall = power >=0
triggerall = command = "y"
triggerall = power >= 450
Triggerall = StateType != A
Trigger1 = StateNo = 5000
Trigger2 = StateNo = 5001
Trigger3 = StateNo = 5010
Trigger4 = StateNo = 5011
Trigger5 = StateNo = 5020
Trigger6 = StateNo = 5030
Trigger7 = StateNo = 5035
Trigger8 = StateNo = 5040
Trigger9 = StateNo = 5050
Trigger10 = StateNo = 5070
Trigger11 = StateNo = 5071
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
[State -1, kawrimi]
type = ChangeState
value = 745
triggerall = statetype != A
triggerall = command = "z"
triggerall = power >= 1300
Trigger1 = StateNo = 5000
Trigger2 = StateNo = 5001
Trigger3 = StateNo = 5010
Trigger4 = StateNo = 5011
Trigger5 = StateNo = 5020
Trigger6 = StateNo = 5030
Trigger7 = StateNo = 5035
Trigger8 = StateNo = 5040
Trigger9 = StateNo = 5050
Trigger10 = StateNo = 5070
Trigger11 = StateNo = 5071
;---------------------------------------------------------------------------
 ; running attack
[State -1, Running attack]
type = ChangeState
value = 1000
triggerall = power >= 100
triggerall = command = "x"
triggerall = stateno != [48, 56]
triggerall = stateno != [411, 415]
triggerall = command != "holddown"
triggerall = command != "holdback"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1, regenerao]
type = ChangeState
value = 735
triggerall = command = "x"
triggerall = power >= 250
Triggerall = StateType != A
Trigger1 = StateNo = 5000
Trigger2 = StateNo = 5001
Trigger3 = StateNo = 5010
Trigger4 = StateNo = 5011
Trigger5 = StateNo = 5020
Trigger6 = StateNo = 5030
Trigger7 = StateNo = 5035
Trigger8 = StateNo = 5040
Trigger9 = StateNo = 5050
Trigger10 = StateNo = 5070
Trigger11 = StateNo = 5071
;---------------------------------------------------------------------------
 ; running attack
[State -1, Running attack]
type = ChangeState
value = 531
triggerall = power >= 3000
triggerall = var(23) = 0
triggerall = command = "QCF_Z"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
 ; running attack
[State -1, Running attack]
type = ChangeState
value = 532
triggerall = var(23) = 1
triggerall = command = "QCF_Z"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------
;---------------------------------------------------------------------------
 ; running attack
[State -1, Running attack]
type = ChangeState
value = 740
triggerall = power >= 1000
triggerall = command = "QCB_Y"
triggerall = p2bodydist x > 80
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;-------------------------------------------------------------------
[State -1, 230]
type = ChangeState
value = 230
triggerall = power >= 2500
triggerall = command = "QCB_B"
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = ctrl
trigger1 = var(50) = 0
trigger2 = var(51) = 0
trigger3 = var(52) = 0
trigger4 = var(53) = 0 & power>=3000

;---------------------------------------------------------------------------
; Wall jump
[State -1, Wall Jump]
type = ChangeState
value = 47
trigger1 = command = "wj"
trigger1 = statetype = A
triggerall = backedgebodydist <= 3 && backedgebodydist > -3
triggerall = Pos Y < -30
trigger1 = Vel X <= 0
triggerall = power > 0
trigger1 = ctrl
;------------------------------------------------------------------------------
;---------------------------------------------------------------------------
; Wall jump
[State -1, Wall Jump]
type = ChangeState
value = 48
trigger1 = command = "WS"
trigger1 = statetype = A
triggerall = backedgebodydist <= 3 && backedgebodydist > -3
triggerall = Pos Y < -30
trigger1 = Vel X <= 0
triggerall = power > 0
trigger1 = ctrl
;------------------------------------------------------------------------------
;=======================================
;NEGATIVE STATES (in this instance, the cmd file):
;
[State -1, ]
type = assertspecial
trigger1 = stateno = 48 ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as is.
flag = noairguard
flag2 = nostandguard
flag3 = nocrouchguard

[State -1, Player_NotHit_During_Armor]
type = HitBy
trigger1 = NumHelper(9393) || NumHelper(9394) ;<---Player (YOU) are only hitby the below parameters when these helpers (the actual armor) is active.
trigger2 = var(30)=1
triggerall = stateno = 48  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = SCA,AT

[State -1, SprPriority_During_Armor_When_Idle]
type = SprPriority
trigger1 = movetype=I ;<----YOUR sprite priority is the below parameter if your movetype is idle
trigger2 = var(30)=1
triggerall = stateno = 48;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = -1

[State -1, Attack_Taker]
type = Helper ;<-----acts as the bodyguard of YOU. The actual armor.....a helper.
triggerall = !NumHelper(9393) ;&& var(30)=1  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this portion of this trigger nulled.
trigger1 = MoveType != H
triggerall = stateno = 48
stateno = 9393 ;<----stateno of helper definitions
id = 9393

[State -1, damage_during_armor]
type = poweradd
trigger1 = NumHelper(9393)
trigger1 = Helper(9393),gethitvar(hitcount)=1 ;<----cannot be on the same line as the 1st trigger1 for some odd reason...
value = -Helper(9393),GetHitVar(Damage) ;<----gives damage that the helper bodyguard takes to YOU
kill = 1 ;<----controls whether you can be killed when above helper is active
;=======================================
;NEGATIVE STATES (in this instance, the cmd file):
;
[State -1, ]
type = assertspecial
trigger1 = stateno = 55 ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as is.
flag = noairguard
flag2 = nostandguard
flag3 = nocrouchguard

[State -1, Player_NotHit_During_Armor]
type = HitBy
trigger1 = NumHelper(9393) || NumHelper(9394) ;<---Player (YOU) are only hitby the below parameters when these helpers (the actual armor) is active.
trigger2 = var(30)=1
triggerall = stateno = 55  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = SCA,AT

[State -1, SprPriority_During_Armor_When_Idle]
type = SprPriority
trigger1 = movetype=I ;<----YOUR sprite priority is the below parameter if your movetype is idle
trigger2 = var(30)=1
triggerall = stateno = 55;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = -1

[State -1, Attack_Taker]
type = Helper ;<-----acts as the bodyguard of YOU. The actual armor.....a helper.
triggerall = !NumHelper(9393) ;&& var(30)=1  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this portion of this trigger nulled.
trigger1 = MoveType != H
triggerall = stateno = 55
stateno = 9393 ;<----stateno of helper definitions
id = 9393

[State -1, damage_during_armor]
type = poweradd
trigger1 = NumHelper(9393)
trigger1 = Helper(9393),gethitvar(hitcount)=1 ;<----cannot be on the same line as the 1st trigger1 for some odd reason...
value = -Helper(9393),GetHitVar(Damage)*2 ;<----gives damage that the helper bodyguard takes to YOU
kill = 1 ;<----controls whether you can be killed when above helper is active
;=======================================
;NEGATIVE STATES (in this instance, the cmd file):
;
[State -1, ]
type = assertspecial
trigger1 = stateno = 56 ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as is.
flag = noairguard
flag2 = nostandguard
flag3 = nocrouchguard

[State -1, Player_NotHit_During_Armor]
type = HitBy
trigger1 = NumHelper(9393) || NumHelper(9394) ;<---Player (YOU) are only hitby the below parameters when these helpers (the actual armor) is active.
trigger2 = var(30)=1
triggerall = stateno = 56  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = SCA,AT

[State -1, SprPriority_During_Armor_When_Idle]
type = SprPriority
trigger1 = movetype=I ;<----YOUR sprite priority is the below parameter if your movetype is idle
trigger2 = var(30)=1
triggerall = stateno = 56;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = -1

[State -1, Attack_Taker]
type = Helper ;<-----acts as the bodyguard of YOU. The actual armor.....a helper.
triggerall = !NumHelper(9393) ;&& var(30)=1  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this portion of this trigger nulled.
trigger1 = MoveType != H
triggerall = stateno = 56
stateno = 9393 ;<----stateno of helper definitions
id = 9393

[State -1, damage_during_armor]
type = poweradd
trigger1 = NumHelper(9393)
trigger1 = Helper(9393),gethitvar(hitcount)=1 ;<----cannot be on the same line as the 1st trigger1 for some odd reason...
value = -Helper(9393),GetHitVar(Damage)*2 ;<----gives damage that the helper bodyguard takes to YOU
kill = 1 ;<----controls whether you can be killed when above helper is active

;=======================================
;NEGATIVE STATES (in this instance, the cmd file):
;
[State -1, ]
type = assertspecial
trigger1 = stateno = [415,416] ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as is.
flag = noairguard
flag2 = nostandguard
flag3 = nocrouchguard

[State -1, Player_NotHit_During_Armor]
type = HitBy
trigger1 = NumHelper(9393) || NumHelper(9394) ;<---Player (YOU) are only hitby the below parameters when these helpers (the actual armor) is active.
trigger2 = var(30)=1
triggerall = stateno = [415,416]  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = SCA,AT

[State -1, SprPriority_During_Armor_When_Idle]
type = SprPriority
trigger1 = movetype=I ;<----YOUR sprite priority is the below parameter if your movetype is idle
trigger2 = var(30)=1
triggerall = stateno = [415,416];<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = -1

[State -1, Attack_Taker]
type = Helper ;<-----acts as the bodyguard of YOU. The actual armor.....a helper.
triggerall = !NumHelper(9393) ;&& var(30)=1  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this portion of this trigger nulled.
trigger1 = MoveType != H
triggerall = stateno = [415,416]
stateno = 9393 ;<----stateno of helper definitions
id = 9393

[State -1, damage_during_armor]
type = poweradd
trigger1 = NumHelper(9393)
trigger1 = Helper(9393),gethitvar(hitcount)=1 ;<----cannot be on the same line as the 1st trigger1 for some odd reason...
value = -Helper(9393),GetHitVar(Damage)*2 ;<----gives damage that the helper bodyguard takes to YOU
kill = 1 ;<----controls whether you can be killed when above helper is active

;-----Sistema de plataformas para stages KM
;=======================================
;NEGATIVE STATES (in this instance, the cmd file):
;
[State -1, ]
type = assertspecial
trigger1 = stateno = 1059 ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as is.
flag = noairguard
flag2 = nostandguard
flag3 = nocrouchguard

[State -1, Player_NotHit_During_Armor]
type = HitBy
trigger1 = NumHelper(9393) || NumHelper(9394) ;<---Player (YOU) are only hitby the below parameters when these helpers (the actual armor) is active.
trigger2 = var(30)=1
triggerall = stateno = 1059  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = SCA,AT

[State -1, SprPriority_During_Armor_When_Idle]
type = SprPriority
trigger1 = movetype=I ;<----YOUR sprite priority is the below parameter if your movetype is idle
trigger2 = var(30)=1
triggerall = stateno = 1059;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = -1

[State -1, Attack_Taker]
type = Helper ;<-----acts as the bodyguard of YOU. The actual armor.....a helper.
triggerall = !NumHelper(9393) ;&& var(30)=1  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this portion of this trigger nulled.
trigger1 = MoveType != H
triggerall = stateno = 1059
stateno = 9393 ;<----stateno of helper definitions
id = 9393

[State -1, damage_during_armor]
type = poweradd
trigger1 = NumHelper(9393)
trigger1 = Helper(9393),gethitvar(hitcount)=1 ;<----cannot be on the same line as the 1st trigger1 for some odd reason...
value = -Helper(9393),GetHitVar(Damage)*2 ;<----gives damage that the helper bodyguard takes to YOU
kill = 1 ;<----controls whether you can be killed when above helper is active

;-----Sistema de plataformas para stages KM

;=======================================
;NEGATIVE STATES (in this instance, the cmd file):
;
[State -1, ]
type = assertspecial
trigger1 = stateno = 1071 ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as is.
flag = noairguard
flag2 = nostandguard
flag3 = nocrouchguard

[State -1, Player_NotHit_During_Armor]
type = HitBy
trigger1 = NumHelper(9393) || NumHelper(9394) ;<---Player (YOU) are only hitby the below parameters when these helpers (the actual armor) is active.
trigger2 = var(30)=1
triggerall = stateno = 1071  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = SCA,AT

[State -1, SprPriority_During_Armor_When_Idle]
type = SprPriority
trigger1 = movetype=I ;<----YOUR sprite priority is the below parameter if your movetype is idle
trigger2 = var(30)=1
triggerall = stateno = 1071;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = -1

[State -1, Attack_Taker]
type = Helper ;<-----acts as the bodyguard of YOU. The actual armor.....a helper.
triggerall = !NumHelper(9393) ;&& var(30)=1  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this portion of this trigger nulled.
trigger1 = MoveType != H
triggerall = stateno = 1071
stateno = 9393 ;<----stateno of helper definitions
id = 9393

[State -1, damage_during_armor]
type = poweradd
trigger1 = NumHelper(9393)
trigger1 = Helper(9393),gethitvar(hitcount)=1 ;<----cannot be on the same line as the 1st trigger1 for some odd reason...
value = -Helper(9393),GetHitVar(Damage)*2 ;<----gives damage that the helper bodyguard takes to YOU
kill = 1 ;<----controls whether you can be killed when above helper is active

;-----Sistema de plataformas para stages KM
;=======================================
;NEGATIVE STATES (in this instance, the cmd file):
;
[State -1, ]
type = assertspecial
trigger1 = stateno = 10540 ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as is.
flag = noairguard
flag2 = nostandguard
flag3 = nocrouchguard

[State -1, Player_NotHit_During_Armor]
type = HitBy
trigger1 = NumHelper(9393) || NumHelper(9394) ;<---Player (YOU) are only hitby the below parameters when these helpers (the actual armor) is active.
trigger2 = var(30)=1
triggerall = stateno = 10540  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = SCA,AT

[State -1, SprPriority_During_Armor_When_Idle]
type = SprPriority
trigger1 = movetype=I ;<----YOUR sprite priority is the below parameter if your movetype is idle
trigger2 = var(30)=1
triggerall = stateno = 10540;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this trigger as nulled.
value = -1

[State -1, Attack_Taker]
type = Helper ;<-----acts as the bodyguard of YOU. The actual armor.....a helper.
triggerall = !NumHelper(9393) ;&& var(30)=1  ;<----Mode variable goes here. If Armor is active all the time or if you do not have a mode var, keep this portion of this trigger nulled.
trigger1 = MoveType != H
triggerall = stateno = 10540
stateno = 9393 ;<----stateno of helper definitions
id = 9393

[State -1, damage_during_armor]
type = poweradd
trigger1 = NumHelper(9393)
trigger1 = Helper(9393),gethitvar(hitcount)=1 ;<----cannot be on the same line as the 1st trigger1 for some odd reason...
value = -Helper(9393),GetHitVar(Damage)*2 ;<----gives damage that the helper bodyguard takes to YOU
kill = 1 ;<----controls whether you can be killed when above helper is active

;-----Sistema de plataformas para stages KM
