; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
; 

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[command]
name = "juugo"
command = a+y
time = 15

[command]
name = "bra"
command = /$B,z
time = 15

[command]
name = "bumeram2"
command = /$F,x
time = 15

[command]
name = "CASCADA"
command = b+z
time = 15

[Remap]
[command]
name = "delfines"
command = B,F,y
time = 15

x = x
[command]
name = "bushin"
command = c+x
time = 15

y = y
[command]
name = "cunai"
command = /$F,y
time = 15

z = z
[command]
name = "Teletransportacion"
command = /$B,b
time = 15

a = a
[command]
name = "superdragon"
command = a,z
time = 15

s = s

;-| Default Values |-------------------------------------------------------
[command]
name = "Tiburon"
command = /$B,c
time = 15

[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.

;-| Super Motions |--------------------------------------------------------

;-| Special Motions |------------------------------------------------------
[command]
name = "Suiton"
command = c+z
time = 15


[command]
name = "kirin"
command = b+y
time = 15


[Command]
name = "charge"
command = /a

[Command]
name = "charge 1"
command = /x

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;------------------------------------------------------------------------------

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

[State -2, AI Sand Shield (Attack)]
type = ChangeState
value = 1204
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 30
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 1202

[State -1, AI Sand Shield (Attack)]
type = ChangeState
value = 1203
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 30
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 1202

[State -1, AI Sand Shield (Defence)]
type = ChangeState
value = 1200
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 30
trigger1 = statetype = S
trigger1 = ctrl

;juugo
[State -1, juugo]
type = ChangeState
value = 420
triggerall = command = "juugo"
triggerall = power > 3400
trigger1 = (statetype = s) && ctrl


<--------------------------------->;bra
[State -1, bra]
type = ChangeState
value = 7111
triggerall = command = "bra"
trigger1 = (statetype = s) && ctrl


;bumeram2
[State -1, bumeram2]
type = ChangeState
value = 1509
triggerall = command = "bumeram2"
triggerall = power> 900
trigger1 = (statetype = s) && ctrl


;CASCADA
[State -1, CASCADA]
type = ChangeState
value = 30000
triggerall = command = "CASCADA"
triggerall = power> 2000
trigger1 = (statetype = s) && ctrl


;delfines
[State -1, delfines]
type = ChangeState
value = 432
triggerall = command = "delfines"
triggerall = power> 1600
trigger1 = (statetype = s) && ctrl


;bushin
[State -1, bushin]
type = ChangeState
value = 3900
triggerall = command = "bushin"
triggerall = power> 1200
triggerall = numhelper(20000) < 4
trigger1 = (statetype = s) && ctrl


;cunai
[State -1, cunai]
type = ChangeState
value = 500
triggerall = command = "cunai"
trigger1 = (statetype = s) && ctrl

; Sand Shield (Attack)
[State -1,Sand Shield (Attack)]
type = ChangeState
value = 1203
triggerall = command = "hold_s"
triggerall = command = "a"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 1202

; Sand Shield (Attack)
[State -2,Sand Shield (Attack)]
type = ChangeState
value = 1204
triggerall = command = "hold_s"
triggerall = command = "b"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 1202

;---------------------------------------------------------------------------
; Sand Shield (Defence)
[State -1,Sand Shield (Defence)]
type = ChangeState
value = 1200
triggerall = command = "hold_s"
triggerall = statetype = S
triggerall = power >= 1000
triggerall = Var(50) = 0
trigger1 = ctrl

;teletransportacion
[State -1, teletransportacion]
type = ChangeState
value = 70
triggerall = command = "Teletransportacion"
trigger1 = (statetype = s) && ctrl


; counter
[State -1, Substitution/Kawarimi no Jutsu]
type = ChangeState
value = 323
triggerall = statetype = s
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = power >= 500
trigger1 = movetype = H
trigger1 = MatchOver = 0

; counter
[State -1, Substitution/Kawarimi no Jutsu]
type = ChangeState
value = 323
triggerall = stateno != 323
triggerall = statetype = a
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = power >= 500
trigger1 = movetype = H
trigger1 = MatchOver = 0



;super Dragon
[State -1, super Dragon]
type = ChangeState
value = 2000
triggerall = command = "superdragon"
triggerall = power > 4400
triggerall = life < 8588888888888
trigger1 = (statetype = s) && ctrl

;Tiburon
[State -1, Tiburon]
type = ChangeState
value = 122
triggerall = command = "Tiburon"
trigger1 = (statetype = s) && ctrl
triggerall = power > 1800

;Suiton
[State -1, Suiton]
type = ChangeState
value = 777
triggerall = command = "Suiton"
triggerall = power > 1500
trigger1 = (statetype = s) && ctrl


;Espadabumeram
[State -1, SwordAttack]
type = ChangeState
value = 260
Triggerall = command = "x"
Triggerall = command != "holdup"
triggerall = power > 700
trigger1 = statetype = C
trigger1 = ctrl



;dragon
[State -1, dragon]
type = ChangeState
value = 112
triggerall = command = "kirin"
trigger1 = (statetype = s) && ctrl
triggerall = power > 3000


;===========================================================================
;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------


;Chacra
[State -1]
type = ChangeState
value = 311
triggerall = ctrl = 1
trigger1 = command = "charge"
trigger1 = command = "charge 1"
trigger1 = statetype = S

;-----------------------
; Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = command = "y" || command = "z"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 10
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 10
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;===========================================================================
;---------------------------------------------------------------------------
; Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "s"
triggerall = command = "holddown"
triggerall = power > 3800
triggerall = Life < 99999999999999999999999
trigger1 = statetype != A
trigger1 = ctrl

;--------------------------------------------------------------------------
;Combo 1
 ;a1
[State -1, Punch]
type = ChangeState
value = 230
triggerall = var(0) = 0
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdup"
triggerall = command != "holdback"
triggerall = statetype = s
trigger1 = ctrl
;---------------------------------------------------------------------------
; a2
[State -1, HeadButt]
type = ChangeState
value = 240
triggerall = var(0) = 0
triggerall = command = "a"
triggerall = statetype = s
trigger1 = stateno = 230
trigger1 = time >= 8
;---------------------------------------------------------------------------

; a2
[State -1, Heavy Punch]
type = ChangeState
value = 220
triggerall = var(0) = 0
triggerall = command = "a"
triggerall = statetype = s
trigger1 = stateno = 240
trigger1 = time >= 8
;----------------------------------------------------------------------------
;Combo2
;Stand Light kick
[State -1, Punch]
type = ChangeState
value = 221
triggerall = var(0) = 0
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = stateno != 221
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1, Head]
type = ChangeState
value = 222
triggerall = var(0) = 0
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = stateno = 221
trigger1 = time >= 10


;---------------------------------------------------------------------------
;combo3
[State -1, Punch]
type = ChangeState
value = 223
triggerall = var(0) = 0
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = stateno != 223
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1, Head]
type = ChangeState
value = 224
triggerall = var(0) = 0
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = stateno = 223
trigger1 = time >= 10

;---------------------------------------------------------------------------
; Stand Medium Punch
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 220
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Standing Medium Kick
[State -1, Standing Medium Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = 250
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;--------------------------------------------------------------------------
;olas
[State -1, Crouching Light Kick]
type = ChangeState
value = 53
triggerall = command = "a"
triggerall = command = "holddown"
triggerall = power > 2700
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
; Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
; Crouching Medium Punch
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = power > 1400
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 1994
triggerall = command = "z"
triggerall = command = "holddown"
triggerall = power > 1000
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
; Crouching Medium Kick
[State -1, Crouching Medium Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Tiburones
[State -1, Crouching Strong Kick]
type = ChangeState
value = 57
triggerall = command = "c"
triggerall = command = "holddown"
triggerall = power > 2100
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
; Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Medium Punch
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 620
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Medium Kick
[State -1, Jump Medium Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = 650
triggerall = command = "c"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------

