; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Special Motions |-----------------------------------------------------------
[command]
name = "QCF_A"
command = D,DF,F,a
time = 20

[command]
name = "QCB_B"
command = D,DB,B,b
time = 20

[command]
name = "QCF_B"
command = D,DF,F,b
time = 20

[command]
name = "QCF_C"
command = D,DF,F,c
time = 20

[command]
name = "QCF_X"
command = D,DF,F,x
time = 20

[command]
name = "QCB_X"
command = D,DB,B,x
time = 20

[command]
name = "QCF_X2"
command = ~D, DF, F, D, DF, F, x
time = 45

[command]
name = "QCF_Y"
command = D,DF,F,y
time = 20

[command]
name = "QCF_Y2"
command = ~D, DF, F, D, DF, F, y
time = 45

[command]
name = "QCF_Z"
command = D,DF,F,z
time = 20

[command]
name = "QCF_Z2"
command = ~D, DF, F, D, DF, F, z
time = 20

[command]
name = "QCB_Z"
command = D,DB,B,z
time = 20

;-| Single Button |-------------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |------------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;-| Hold Button |---------------------------------------------------------------
[Command]
name = "holda"
command = /a
time = 1

[Command]
name = "holdb"
command = /b
time = 1

[Command]
name = "holdc"
command = /c
time = 1

[Command]
name = "holdx"
command = /x
time = 1

[Command]
name = "holdy"
command = /y
time = 1

[Command]
name = "holdz"
command = /z
time = 1

[Command]
name = "holdstart"
command = /s
time = 1

;-| CPU |-----------------------------------------------------------------------

[Command]
name = "a2"
command = a
time = 1

[Command]
name = "b2"
command = b
time = 1

[Command]
name = "c2"
command = c
time = 1

[Command]
name = "x2"
command = x
time = 1

[Command]
name = "y2"
command = y
time = 1

[Command]
name = "z2"
command = z
time = 1

[Command]
name = "start2"
command = s
time = 1

[Command]
name = "holdfwd2"
command = /$F
time = 1

[Command]
name = "holdback2"
command = /$B
time = 1

[Command]
name = "holdup2"
command = /$U
time = 1

[Command]
name = "holddown2"
command = /$D
time = 1

[Command]
name = "holda2"
command = /a
time = 1

[Command]
name = "holdb2"
command = /b
time = 1

[Command]
name = "holdc2"
command = /c
time = 1

[Command]
name = "holdx2"
command = /x
time = 1

[Command]
name = "holdy2"
command = /y
time = 1

[Command]
name = "holdz2"
command = /z
time = 1

[Command]
name = "holdstart2"
command = /s
time = 1

[Command]
name = "recovery2"
command = x+y
time = 1

;-| Double Tap |----------------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

[command]
name = "UP"
command = ~U
time = 15

;-| 2/3 Button Combination |----------------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |--------------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1


;///////////////////////////////////////////////////////////////////////////////

[Statedef -1]

;///////////////////////////////////////////////////////////////////////////////

[State -1,Paper Clone Jutsu]
type = ChangeState
value = 1065
triggerall = command = "QCB_X"
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1,Paper Jutsu: The Angel]
type = ChangeState
value = 1070
triggerall = command = "QCF_Y2"
triggerall = power >= 3000
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1,Explosive Bouquet]
type = ChangeState
value = 1040
triggerall = command = "QCF_X2"
triggerall = power >= 2500
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1,Shower Of Sharp Papers]
type = ChangeState
value = 1060
triggerall = command = "QCB_Z"
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1,Explosive-Papers]
type = ChangeState
value = 1047
triggerall = command = "QCF_Z"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1,Hiper-Paper Drill]
type = ChangeState
value = 1045
triggerall = command = "QCB_B"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1,Shikigami No Mai]
type = ChangeState
value = 1000
triggerall = command = "QCF_A"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1,Paper Drill]
type = ChangeState
value = 1010
triggerall = command = "QCF_B"
triggerall = power >= 1200
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1,Paper Wings]
type = ChangeState
value = 1020
triggerall = command = "QCF_C"
triggerall = power >= 1200
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1,Swirl Paper]
type = ChangeState
value = 1030
triggerall = command = "QCF_Y"
triggerall = power >= 1200
triggerall = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

[State -1, Chakra Charge]
type = ChangeState
value = 700
triggerall = power < 3000
trigger1 = command = "start2" 
trigger1 = statetype != A
trigger1 = ctrl

;///////////////////////////////////////////////////////////////////////////////

;-------------------------------------------------------------------------------
; Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value =200
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;-------------------------------------------------------------------------------
[State -1, Run Forward]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;-------------------------------------------------------------------------------

[State -1, Run Back]
type = ChangeState
value = 100
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl


;-------------------------------------------------------------------------------
; Stand Medium Punch
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = command = "b"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 =stateno = 200

;-------------------------------------------------------------------------------
; Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 210

;-------------------------------------------------------------------------------
; Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 220
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 230
trigger3 = stateno = 210
trigger4 = stateno = 240

;-------------------------------------------------------------------------------
;Throw-Opponent
[State -1, Throw-Opponent]
type = ChangeState
value = 800
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;-------------------------------------------------------------------------------
;/Swirl Paper/
[State -1, /Swirl Paper/]
type = ChangeState
value = 820
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2=stateno=230&&movecontact
trigger3=stateno=250&&movecontact
trigger4=stateno=200&&movecontact
trigger5=stateno=220&&movecontact
trigger6=stateno=210&&movecontact
trigger7=stateno=400&&movecontact

;-------------------------------------------------------------------------------
; Paper Throw I
[State -1, Paper Throw]
type = ChangeState
value = 400
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2=stateno=430
trigger3=stateno=220

;-------------------------------------------------------------------------------
;Explosive Paper Clone
[State -1, Explosive Paper Clone]
type = ChangeState
value = 900
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2=stateno=200&&movecontact
trigger3=stateno=210&&movecontact
trigger4=stateno=220&&movecontact
trigger5=stateno=240&&movecontact
trigger6=stateno=250&&movecontact

;-------------------------------------------------------------------------------
; Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2=stateno=610&&movecontact
trigger3=stateno=620&&movecontact

;-------------------------------------------------------------------------------
;Jump Medium Punch
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = command = "a" && command =  "UP"
trigger1 = statetype = A
trigger1 = ctrl
trigger2=stateno=600&&movecontact
trigger3=stateno=620&&movecontact

;-------------------------------------------------------------------------------
;Paper Throw(Air)
[State -1, Paper Throw(Air)]
type = ChangeState
value = 429
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl

;-------------------------------------------------------------------------------
;Crouching light Kick
[State -1, Crouching light Kick]
type = ChangeState
value = 240
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 210
trigger3 = stateno = 230

;-------------------------------------------------------------------------------
;Crouching Medium Kick
[State -1, Crouching Medium Kick]
type = ChangeState
value = 432
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2=stateno=240

;-------------------------------------------------------------------------------

;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 210
trigger3 = stateno = 230
trigger4 = stateno = 240
trigger5 = stateno = 430

;-------------------------------------------------------------------------------

