; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
; 

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------


[Defaults]


; Default value for the "time" parameter of a Command. Minimum 1.
[command]
name = "Drake"
command = D,D,y
time = 20

[command]
name = "Storm"
command = F,B,x
time = 30

[command]
name = "Brus"
command = D,D,a
time = 20

[command]
name = "Tree"
command = D,F,a
time = 24

[command]
name = "DorBunshin"
command = D,F,b
time = 24

[command]
name = "Chidori"
command = D,F,F,b
time = 30

[command]
name = "Hokage"
command = D,F,D,a
time = 30

[command]
name = "Wood"
command = D,B,D,a
time = 30

[command]
name = "WGloud"
command = B,F,y
time = 30

[command]
name = "Fish"
command = D,B,b
time = 26

[command]
name = "Arm"
command = D,D,b
time = 26

[command]
name = "Summon"
command = D,D,c
time = 26

[command]
name = "Summoning"
command = D,D,F,c
time = 30

[command]
name = "BigWatDragon"
command = D,B,F,b
time = 30

[command]
name = "WatDragon"
command = D,F,B,b
time = 30

[command]
name = "MWaterDragon"
command = D,B,c
time = 24

[command]
name = "FireDragon"
command = D,B,D,c
time = 30

[command]
name = "BFDragon"
command = D,F,c
time = 24

[command]
name = "IceDragon"
command = D,F,F,c
time = 30

[command]
name = "WindDragon"
command = D,F,D,c
time = 30

[command]
name = "Class"
command = D,B,a
time = 24

[command]
name = "Hosenka"
command = D,B,y
time = 20

[command]
name = "Kawarimi"
command = D,B,z
time = 15

[command]
name = "HosenkaBird"
command = D,B,D,y
time = 30

[command]
name = "New"
command = D,F,D,y
time = 30

[command]
name = "TsukiemiBomb"
command = D,D,x
time = 30

[command]
name = "TsukiemiRaven"
command = D,F,x
time = 30

[command]
name = "TsukiemiAmaterasu"
command = D,B,x
time = 30

[command]
name = "RisingSun"
command = F,D,x
time = 30

[command]
name = "Suasano"
command = B,D,x
time = 30


command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.

[command]
name = "cool"
command = D,F,y
time = 15

command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;


;-| Special Motions |------------------------------------------------------

[Command]
name = "RCB"
command = D,F, c
time = 20

[Command]
name = "RBC"
command = B, c
time = 20

[Command]
name = "QCF_y"
command = B, b
time = 20

[Command]
name = "QCB_y"
command = B, a
time = 20

[Command]
name = "QCF_x+y"
command = F, b
time = 30


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd"
command = $F,c
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1


;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
; Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = command = "y" || command = "z"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 10
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 10
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;===========================================================================
;---------------------------------------------------------------------------
; Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "s"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
trigger1 = statetype != A
trigger1 = ctrl
triggerall = power >= 1500

[State -1, Mangekyo]
type = ChangeState
value = 1121
triggerall = command = "s"
triggerall = command = "holdfwd"
trigger1 = statetype != A
trigger1 = ctrl
triggerall = power >= 1500

[State -1, MaMangekyo]
type = ChangeState
value = 1123
triggerall = command = "s"
triggerall = command = "holdback"
trigger1 = statetype != A
trigger1 = ctrl
triggerall = power >= 3000

[State -1, MaMadara]
type = ChangeState
value = 1125
triggerall = command = "s"
triggerall = command = "holddown"
trigger1 = statetype != A
trigger1 = ctrl
triggerall = power >= 5000

;---------------------------------------------------------------------------

; Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "Storm"
triggerall = command != "TsukiemiBomb"
triggerall = command != "TsukiemiRaven"
triggerall = command != "TsukiemiAmaterasu"
triggerall = command != "RisingSun"
triggerall = command != "Suasano"
triggerall = command = "x"
trigger1 = statetype = S
trigger1 = ctrl

; Stand Light Punch1
[State -2, Stand Light Punch]
type = ChangeState
value = 201
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "Storm"
triggerall = command != "TsukiemiBomb"
triggerall = command != "TsukiemiRaven"
triggerall = command != "TsukiemiAmaterasu"
triggerall = command != "RisingSun"
triggerall = command != "Suasano"
triggerall = command = "x"
trigger2 = stateno = 200
trigger1 = statetype = S
trigger1 = ctrl
value = 201

; Stand Light Punch2
[State -3, Stand Light Punch]
type = ChangeState
value = 202
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "Storm"
triggerall = command != "TsukiemiBomb"
triggerall = command != "TsukiemiRaven"
triggerall = command != "TsukiemiAmaterasu"
triggerall = command != "RisingSun"
triggerall = command != "Suasano"
triggerall = command = "x"
trigger2 = stateno = 201
trigger1 = statetype = S
trigger1 = ctrl
value = 202

; Stand Light Punch1
[State -2, Stand Light Punch]
type = ChangeState
value = 201
value = 200
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "Storm"
triggerall = command != "TsukiemiBomb"
triggerall = command != "TsukiemiRaven"
triggerall = command != "TsukiemiAmaterasu"
triggerall = command != "RisingSun"
triggerall = command != "Suasano"
triggerall = command = "x"
trigger2 = stateno = 201
trigger1 = statetype = S
trigger1 = ctrl
value = 200

; Stand Light Punch1
[State -2, Stand Light Punch]
type = ChangeState
value = 201
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "Storm"
triggerall = command != "TsukiemiBomb"
triggerall = command != "TsukiemiRaven"
triggerall = command != "TsukiemiAmaterasu"
triggerall = command != "RisingSun"
triggerall = command != "Suasano"
triggerall = command = "x"
trigger2 = stateno = 200
trigger1 = statetype = S
trigger1 = ctrl
value = 201

; Stand Light Punch1
[State -2, Stand Light Punch]
type = ChangeState
value = 201
value = 200
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "Storm"
triggerall = command != "TsukiemiBomb"
triggerall = command != "TsukiemiRaven"
triggerall = command != "TsukiemiAmaterasu"
triggerall = command != "RisingSun"
triggerall = command != "Suasano"
triggerall = command = "x"
trigger2 = stateno = 201
trigger1 = statetype = S
trigger1 = ctrl
value = 200

; Stand Light Punch1
[State -2, Stand Light Punch]
type = ChangeState
value = 201
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "Storm"
triggerall = command != "TsukiemiBomb"
triggerall = command != "TsukiemiRaven"
triggerall = command != "TsukiemiAmaterasu"
triggerall = command != "RisingSun"
triggerall = command != "Suasano"
triggerall = command = "x"
trigger2 = stateno = 200
trigger1 = statetype = S
trigger1 = ctrl
value = 201

[State -1, Rasengan]
type = ChangeState
value = 1148
triggerall = command = "x"
triggerall = command = "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 2000

[State -1, SnowRasengan]
type = ChangeState
value = 1150
triggerall = command = "x"
triggerall = command = "holdback"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1500

[State -1, Storm]
type = ChangeState
value = 1152
triggerall = command = "Storm"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 3000

;---------------------------------------------------------------------------
; Stand Medium Punch
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "cool"
triggerall = command != "Drake"
triggerall = command != "holddown"
triggerall = command != "New"
triggerall = command != "Hosenka"
triggerall = command != "HosenkaBird"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "WGloud"
trigger1 = statetype = S
trigger1 = ctrl

[State -2, Stand Medium Punch]
type = ChangeState
value = 211
triggerall = command = "y"
triggerall = command != "cool"
triggerall = command != "Drake"
triggerall = command != "holddown"
triggerall = command != "New"
triggerall = command != "Hosenka"
triggerall = command != "HosenkaBird"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "WGloud"
trigger1 = statetype = S
trigger2 = stateno = 210
trigger1 = statetype = S
trigger1 = ctrl
value = 211

[State -3, Stand Medium Punch]
type = ChangeState
value = 212
triggerall = command = "y"
triggerall = command != "cool"
triggerall = command != "Drake"
triggerall = command != "holddown"
triggerall = command != "New"
triggerall = command != "Hosenka"
triggerall = command != "HosenkaBird"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "WGloud"
trigger1 = statetype = S
trigger2 = stateno = 211
trigger1 = statetype = S
trigger1 = ctrl
value = 212

[State -1, Wbomb]
type = ChangeState
value = 1184
triggerall = command = "y"
triggerall = command = "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 500

[State -1, Wind]
type = ChangeState
value = 1186
triggerall = command = "y"
triggerall = command = "holdback"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1000

[State -1, WGloud]
type = ChangeState
value = 1188
triggerall = command = "y"
triggerall = command = "WGloud"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1100

;---------------------------------------------------------------------------
; Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 220
triggerall = command = "z"
triggerall = command != "holddown"
triggerall = command != "Kawarimi"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Amaterasu]
type = ChangeState
value = 1140
triggerall = command = "z"
triggerall = command = "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 2000

[State -1, redAmaterasu]
type = ChangeState
value = 1142
triggerall = command = "z"
triggerall = command = "holdback"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 2000

;---------------------------------------------------------------------------
; Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holdfwd"
triggerall = command != "holddown"
triggerall = command != "holdback"
triggerall = command != "Brus"
triggerall = command != "Tree"
triggerall = command != "Class"
triggerall = command != "Hokage"
triggerall = command != "Wood"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, BigAmaterasu]
type = ChangeState
value = 1144
triggerall = command = "a"
triggerall = command = "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 4000

[State -1, AmaterDrag]
type = ChangeState
value = 1146
triggerall = command = "a"
triggerall = command = "holdback"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 3700

;---------------------------------------------------------------------------

;Standing Medium Kick
[State -1, Standing Medium Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = command != "DorBunshin"
triggerall = command != "Fish"
triggerall = command != "Arm"
triggerall = command != "holdback"
triggerall = command != "BigWatDragon"
triggerall = command != "WatDragon"
triggerall = command != "Chidori"
triggerall = command != "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl

[State -3, Standing Medium Kick]
type = ChangeState
value = 241
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = command != "DorBunshin"
triggerall = command != "Fish"
triggerall = command != "Arm"
triggerall = command != "holdback"
triggerall = command != "BigWatDragon"
triggerall = command != "WatDragon"
triggerall = command != "Chidori"
triggerall = command != "holdfwd"
trigger1 = statetype = S
trigger2 = stateno = 240
trigger1 = statetype = S
trigger1 = ctrl
value = 241

[State -4, Standing Medium Kick]
type = ChangeState
value = 242
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = command != "DorBunshin"
triggerall = command != "Fish"
triggerall = command != "Arm"
triggerall = command != "holdback"
triggerall = command != "BigWatDragon"
triggerall = command != "WatDragon"
triggerall = command != "Chidori"
triggerall = command != "holdfwd"
trigger1 = statetype = S
trigger2 = stateno = 241
trigger1 = statetype = S
trigger1 = ctrl
value = 242

[State -1, Poloska]
type = ChangeState
value = 1180
triggerall = command = "b"
triggerall = command = "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 700

[State -1, Kosti]
type = ChangeState
value = 1182
triggerall = command = "b"
triggerall = command = "holdback"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1500

;---------------------------------------------------------------------------
; Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = 250
triggerall = command = "c"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
triggerall = command != "holdback"
triggerall = command != "Summon"
triggerall = command != "Summoning"
triggerall = command != "MWaterDragon"
triggerall = command != "BFDragon"
triggerall = command != "FireDragon"
triggerall = command != "IceDragon"
triggerall = command != "WindDragon"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ThrowT]
type = ChangeState
value = 1112
triggerall = command = "c"
triggerall = command = "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ThrowTh]
type = ChangeState
value = 1114
triggerall = command = "c"
triggerall = command = "holdback"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ThrowF]
type = ChangeState
value = 1116
triggerall = command = "c"
triggerall = command = "holdback"
trigger1 = stateno = 1114
trigger1 = time > 5

;---------------------------------------------------------------------------
; Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
triggerall = power <= 2999

[State -1, TsukiemiBomb]
type = ChangeState
value = 1205
triggerall = command = "TsukiemiBomb"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 3100

[State -1, TsukiemiRaven]
type = ChangeState
value = 1208
triggerall = command = "TsukiemiRaven"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 4100

[State -1, TsukiemiRaven]
type = ChangeState
value = 1211
triggerall = command = "TsukiemiAmaterasu"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 5100

[State -1, RisingSun]
type = ChangeState
value = 1214
triggerall = command = "RisingSun"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 4000

[State -1, Suasano]
type = ChangeState
value = 1216
triggerall = command = "Suasano"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 5900

;---------------------------------------------------------------------------
; Crouching Medium Punch
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
triggerall = power >= 300

[State -1, Katondzyau]
type = ChangeState
value = 1128
triggerall = command = "cool"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 800

[State -1, Katonik]
type = ChangeState
value = 1130
triggerall = command = "Drake"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 600

[State -1, BiggestK]
type = ChangeState
value = 1132
triggerall = command = "New"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1500

[State -1, Hosenka]
type = ChangeState
value = 1134
triggerall = command = "Hosenka"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1000

[State -1, HosenkaBird]
type = ChangeState
value = 1136
triggerall = command = "HosenkaBird"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1500

;---------------------------------------------------------------------------
; Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 420
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
triggerall = power >= 10

[State -1, Crazy]
type = ChangeState
value = 1138
triggerall = command = "Kawarimi"
Trigger1 = StateNo = 5001
Trigger2 = StateNo = 5010
Trigger3 = StateNo = 5011
Trigger4 = StateNo = 5020
Trigger5 = StateNo = 5030
Trigger6 = StateNo = 5035
Trigger7 = StateNo = 5040
Trigger8 = StateNo = 5050
Trigger9 = StateNo = 5070
Trigger10 = StateNo = 5071
Trigger11 = StateNo = 5000
Trigger12 = StateNo = 5002
trigger1 = stateno = 200
trigger1 = time > 3
triggerall = power >= 20
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
; Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
triggerall = power >= 100

[State -1, Brus]
type = ChangeState
value = 1155
triggerall = command = "Brus"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 200

[State -1, Crash]
type = ChangeState
value = 1157
triggerall = command = "Tree"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 200

[State -1, Class]
type = ChangeState
value = 1159
triggerall = command = "Class"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 100

[State -1, Hokage]
type = ChangeState
value = 1161
triggerall = command = "Hokage"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1500

[State -1, Wood]
type = ChangeState
value = 1164
triggerall = command = "Wood"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 5000

[State -1, Fish]
type = ChangeState
value = 1169
triggerall = command = "Fish"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1000

;---------------------------------------------------------------------------
; Crouching Medium Kick
[State -1, Crouching Medium Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
triggerall = numhelper(20000) < 4
triggerall = power >= 500

[State -1, DorBunshin]
type = ChangeState
value = 1167
triggerall = command = "DorBunshin"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 800

[State -1, Arm]
type = ChangeState
value = 1171
triggerall = command = "Arm"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 2000

[State -1, BigWatDragon]
type = ChangeState
value = 1173
triggerall = command = "BigWatDragon"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1500

[State -1, WatDragon]
type = ChangeState
value = 1175
triggerall = command = "WatDragon"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1500

[State -1, Chidori]
type = ChangeState
value = 1177
triggerall = command = "Chidori"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 1000

;---------------------------------------------------------------------------
; Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 450
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
triggerall = power >= 1500

[State -1, Summon]
type = ChangeState
value = 1190
triggerall = command = "Summon"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 2000

[State -1, Summoning]
type = ChangeState
value = 1192
triggerall = command = "Summoning"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 2500

[State -1, MWaterDragon]
type = ChangeState
value = 1195
triggerall = command = "MWaterDragon"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 700

[State -1, BFDragon]
type = ChangeState
value = 1197
triggerall = command = "BFDragon"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 2500

[State -1, FireDragon]
type = ChangeState
value = 1199
triggerall = command = "FireDragon"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 700

[State -1, IceDragon]
type = ChangeState
value = 1201
triggerall = command = "IceDragon"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 500

[State -1, WindDragon]
type = ChangeState
value = 1203
triggerall = command = "WindDragon"
trigger1 = statetype = S
trigger1 = ctrl
triggerall = power >= 2500

;---------------------------------------------------------------------------
; Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Medium Punch
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 620
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Medium Kick
[State -1, Jump Medium Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = 650
triggerall = command = "c"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
