; The CMD file.

[command]
name = "globo"
command = B,F,y
time = 15

[command]
name = "PSP"
command = B,F,a
time = 15

[command]
name = "C1"
command = y+z
time = 15

[command]
name = "ARCILLA"
command = a+y
time = 15

[command]
name = "Avesita"
command = /$B,c
time = 15

[command]
name = "AVE"
command = x+c
time = 15

[command]
name = "explo"
command = b+y
time = 15

[Command]
name = "CPU1"
command = B,F,B,a
time = 0

[Command]
name = "CPU2"
command = B,F,B,b
time = 0

[Command]
name = "CPU3"
command = B,F,B,c
time = 0

[Command]
name = "CPU4"
command = B,F,B,x
time = 0

[Command]
name = "CPU5"
command = B,F,B,y
time = 0

[Command]
name = "CPU6"
command = B,F,B,z
time = 0

[Command]
name = "CPU7"
command = B,D,B,a
time = 0

[Command]
name = "CPU8"
command = B,D,B,b
time = 0

[Command]
name = "CPU9"
command = B,D,B,c
time = 0

[Command]
name = "CPU10"
command = B,D,B,x
time = 0

[Command]
name = "CPU11"
command = B,D,B,y
time = 0

[Command]
name = "CPU12"
command = B,D,B,z
time = 0


;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

;-| AI Activators|-------------------------------------------------------------------

[Command]
name = "CPU"
command = a
time = 1

[Command]
name = "CPU"
command = b
time = 1

[Command]
name = "CPU"
command = c
time = 1

[Command]
name = "CPU"
command = x
time = 1

[Command]
name = "CPU"
command = y
time = 1

[Command]
name = "CPU"
command = z
time = 1

[Command]
name = "CPU"
command = s
time = 1

[Command]
name = "CPU"
command = F
time = 1

[Command]
name = "CPU"
command = B
time = 1

[Command]
name = "CPU"
command = U
time = 1

[Command]
name = "CPU"
command = D
time = 1

[Command]
name = "AI"
command = U, U, U, U, U, U, U, U, b, U, a, U, U, U, U, U, c, U, z, U
time = 1

[Command]
name = "AI1"
command = D, D, D, U, U, U, x, U, U, U, a, U, U, U, U, U, U, U, b, U
time = 1

[Command]
name = "AI2"
command = F, F, F, U, U, U, U, U, x, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI3"
command = B, B, B, U, U, U, U, U, x, U, U, U, z, U, U, U, U, U, U, b
time = 1

[Command]
name = "AI4"
command = U, U, U, U, U, U, U, a, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI5"
command = D, D, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI6"
command = F, F, F, U, U, U, U, U, U, y, U, U, z, y, U, U, U, U, U, U
time = 1

[Command]
name = "AI7"
command = B, B, B, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI8"
command = U, U, U, U, U, U, U, a, U, U, U, U, U, y, y, U, U, U, U, U
time = 1

[Command]
name = "AI9"
command = D, D, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI10"
command = F, B, F, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI11"
command = D, U, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI12"
command = F, B, F, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI13"
command = B, F, B, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI14"
command = U, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI15"
command = D, U, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI16"
command = F, B, F, U, U, U, U, U, U, U, F, U, a, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI17"
command = B, F, B, U, U, U, U, a, U, U, B, U, U, U, U, U, c, U, U, b
time = 1

[Command]
name = "AI18"
command = U, D, U, U, U, U, U, z, U, U, U, y, U, y, U, D, U, U, U, U
time = 1

[Command]
name = "AI19"
command = D, U, D, U, U, U, U, U, U, U, U, U, U, U, U, U, D, U, U, U
time = 1

[Command]
name = "AI20"
command = F, B, F, U, U, U, U, U, U, F, B, z, a, U, U, U, D, U, U, U
time = 1


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------

[command]
name = "C-2"
command = ~D,DB,B,c
time = 15


[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.


; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
[command]
name = "SPI"
command = D,F,a
time = 15

command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------

;-| Special Motions |------------------------------------------------------

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states

;===========================================================================
;---------------------------------------------------------------------------
;=========================================================================
;-------------------------------------------------------------------
; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;globo
[State -1, globo]
type = ChangeState
value = 301
triggerall = command = "globo"
triggerall = power > 2800
trigger1 = (statetype = s) && ctrl


;PSP
[State -1, PSP]
type = ChangeState
value = 30001
triggerall = command = "PSP"
triggerall = power > 7500
triggerall = life < 9999999999999999999999999999999999999
trigger1 = (statetype = s) && ctrl


;C1
[State -1, C1]
type = ChangeState
value = 227
triggerall = command = "C1"
triggerall = power > 2600
trigger1 = (statetype = s) && ctrl


;AVE
[State -1, AVE]
type = ChangeState
value = 2003
triggerall = command = "AVE"
triggerall = life < 8000000000
triggerall = power > 5800
trigger1 = (statetype = s) && ctrl


;explo
[State -1, explo]
type = ChangeState
value = 12121212
triggerall = command = "explo"
triggerall = life < 800000000000
triggerall = power > 100
trigger1 = (statetype = s) && ctrl


;deidaras
[State -1, deidaras]
type = ChangeState
value = 1011
triggerall = command = "hold_s"
triggerall = power > 5000
triggerall = life < 8000000000000
trigger1 = (statetype = s) && ctrl

;ARCILLA
[State -1, arcilla1]
type = ChangeState
value = 100000
triggerall = command = "ARCILLA"
triggerall = numhelper(200000) < 4
triggerall = numhelper(300000) < 8
triggerall = power > 6700
triggerall = life < 900999999999999999999999999999999999
trigger1 = (statetype = s) && ctrl


[State -1]
type = VarSet
triggerall = statetype = S
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
v = 50
value = 1

[State -1]
type = VarSet
triggerall = statetype = S
triggerall = p2statetype = S
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
v = 50
value = 1

[State -1]
type = VarSet
triggerall = statetype = A
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
v = 50
value = 1

;===========================================================================
;---------------------------------------------------------------------------

[State -1, AI armadillo]
type = ChangeState
value = 1003
triggerall = power >= 1200
triggerall = Var(50) = 1
triggerall = random >= 200 && random < 250 || random >= 100 && random <= 910
triggerall = p2bodydist X > 300
trigger1 = statetype = c
trigger1 = ctrl

[State -1, AI mole]
type = ChangeState
value = 1002
triggerall = power >= 1300
triggerall = Var(50) = 1
triggerall = random >= 200 && random < 250 || random >= 50 && random <= 900
triggerall = p2bodydist X > 100
trigger1 = statetype = c
trigger1 = ctrl


[State -1, AI deidara muere issca]
type = ChangeState
value = 1011
triggerall = power > 2000
triggerall = life < 9999999999999999999999999999999999999999999999999999
triggerall = Var(50) = 1
triggerall = random >= 200 && random < 300 || random >= 300 && random <= 1200
triggerall = p2bodydist X > 50
trigger1 = statetype = S
trigger1 = ctrl


[State -1, AI arcillas]
type = ChangeState
value = 100000
triggerall = command = "ARCILLA"
triggerall = numhelper(200000) < 4
triggerall = numhelper(300000) < 8
triggerall = power > 1100
triggerall = life < 90099999999999999999999999999999999999999999999999999
triggerall = Var(50) = 1
triggerall = random >= 200 && random < 200 || random >= 500&& random <= 1300
triggerall = p2bodydist X > 600
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI explo]
type = ChangeState
value = 12121212
triggerall = life < 4009999999999999999999999999999999999999999999999999
triggerall = power > 100
triggerall = Var(50) = 1
triggerall = random >= 200 && random < 200 || random >= 500 && random <= 1300
triggerall = p2bodydist X > 500
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI ave]
type = ChangeState
value = 2003
triggerall = power >= 2000
triggerall = Var(50) = 1
triggerall = random >= 200 && random < 200 || random >= 500 && random <= 1100
triggerall = p2bodydist X > 130
triggerall = p2life > 4009999999999999999999999999999999
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI psp]
type = ChangeState
value = 30001
triggerall = power >= 2000
triggerall = Var(50) = 1
triggerall = random >= 200 && random < 200 || random >= 500 && random <= 1400
triggerall = p2bodydist X > 200
triggerall = p2life > 400999999999999999999999999999999999999
trigger1 = statetype = S
trigger1 = ctrl


[State -1, AI globo]
type = ChangeState
value = 301
triggerall = power >= 2200
triggerall = Var(50) = 1
triggerall = random >= 200 && random < 200 || random >= 500 && random <= 950
triggerall = p2bodydist X > 20
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI Run]
type = ChangeState
value = 100
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = p2bodydist X > 420
trigger2 = power >= 0
trigger1 = statetype = S
trigger1 = ctrl

; AI Kynai
[State -1, AI Kynai]
type = ChangeState
value = 999
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < !500
trigger1 = statetype = S
trigger1 = ctrl


; AI combo
[State -1, AI combo]
type = ChangeState
value = 200
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl


; AI combo1
[State -1, AI combo1]
type = ChangeState
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 200
value = 210

; AI combo2
[State -1, AI combo2]
type = ChangeState
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 210
value = 220

;----------------------------------------
; AI com
[State -1, AI comb]
type = ChangeState
value = 260
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 1000
triggerall = p2life > 0
triggerall = p2bodydist X <20
trigger1 = statetype = S
trigger1 = ctrl


; AI comb1
[State -1, AI comb1]
type = ChangeState
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 1000
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 260
value = 261

; AI comb2
[State -1, AI comb2]
type = ChangeState
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 1000
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 261
value = 262


; AI Crouching Light Punch
[State -1, AI Crouching Light Punch]
type = ChangeState
value = 420
value = 99999
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl


[State -1, AI 3 Exploder Birds]
type = ChangeState
value = 99999
triggerall = power >= 1300
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 1000
triggerall = p2life > 0
triggerall = p2bodydist X < 200
trigger1 = statetype = S
trigger1 = ctrl


[state -1, AI 40 Legs]
type = ChangeState
value = 1717
triggerall = numhelper(20000) < 1
triggerall = power >= 2000
triggerall = Var(50) = 1
triggerall = random >= 200 && random < 280 || random >= 400 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 100
trigger1 = statetype = S
trigger1 = ctrl



[State -1, AI Mine]
type = ChangeState
value = 876
triggerall = power >= 500
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 200 || random >= 550 && random <= 600
triggerall = p2life > 0
triggerall = p2bodydist X < 200
trigger1 = statetype = S
trigger1 = ctrl

[state -1, AI Bunshin]
type = ChangeState
value = 1100
triggerall = numhelper(20000) < 1
triggerall = power >= 2000
triggerall = Var(50) = 1
triggerall = random >= 300 && random < 200 || random >= 500 && random <= 1050
triggerall = p2life > 0
triggerall = p2bodydist X < 200
trigger1 = statetype = S
trigger1 = ctrl


[State -1, AI Fly]
type = ChangeState
value = 191919
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 200 || random >= 500 && random <= 900
triggerall = power >= 50
triggerall = power > 5000
triggerall = p2bodydist Y < -200
trigger1 = statetype = S
trigger1 = statetype = A
trigger1 = ctrl

[State -1, AI Fly a]
type = ChangeState
value =  1800
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 920
triggerall = power > 1000
triggerall = p2bodydist Y < -100
trigger1 = statetype = S
trigger1 = statetype = A
trigger1 = ctrl


;===========================================================================
;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
; Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;combo
[State -1, combo]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;combo1
[State -1, combo1]
type = ChangeState
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 200
value = 210
;---------------------------------------------------------------------------
;combo2
[State -1, combo2]
type = ChangeState
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 210
value = 220

;---------------------------------------------------------------------------
;cunai
[State -1, combo]
type = ChangeState
value = 260
triggerall = command = "y"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;patada
[State -1, combo1]
type = ChangeState
triggerall = command = "y"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 260
value = 261
;---------------------------------------------------------------------------
;cunai 2
[State -1, combo2]
type = ChangeState
triggerall = command = "y"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 261
value = 262

;---------------------------------------------------------------------------
[State -1,  Fwdattack]
type = ChangeState
value = 204
triggerall = command = "x"
triggerall = command = "holdfwd"
triggerall = statetype = s
trigger1 = ctrl
trigger2 = stateno = 100
;---------------------------------------------------------------------------
; Explosion del suelo
[State -1, Crouching Light Punch]
type = ChangeState
value = 420
triggerall = command = "x"
triggerall = power >= 1000
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
 ; Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
triggerall = power >= 1100
trigger1 = statetype = A

[state -1, Teleport]
type = ChangeState
value = 666
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

; Chakra
[State -1, Chakra]
type = ChangeState
value = 444
triggerall = command = "hold_a"
triggerall = power < 8000
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1, KATSU]
type = ChangeState
value = 696
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, KATSU air]
type = ChangeState
value = 698
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, 40 Legs]
type = ChangeState
value = 1717
triggerall = numhelper(20000) < 1
triggerall = power >= 3300
triggerall = command = "a"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Mine]
type = ChangeState
value = 876
triggerall = power >= 500
triggerall = command = "y"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1, Throw Clay]
type = ChangeState
value = 1000
triggerall = command = "Avesita"
triggerall = power >= 1200
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Summon Mole]
type = ChangeState
value = 1002
triggerall = power >= 1400
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Summon Armadillo]
type = ChangeState
value = 1003
triggerall = power >= 1700
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl


; c
[State -1, Fast Clay]
type = ChangeState
value = 1004
triggerall = command = "c"
triggerall = power >= 1900
trigger1 = statetype = S
trigger1 = ctrl


;abajo + c
[State -1, Fast Clay 3]
type = ChangeState
value = 99999
triggerall = power >= 1300
triggerall = command = "c"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Throw Air Clay]
type = ChangeState
value = 251
triggerall = power >= 1000
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl = 1
;---------------------------------------------------------------------------


[state -1, Bunshin]
type = ChangeState
value = 1100
triggerall = numhelper(20000) < 1
triggerall = power >= 3800
Triggerall = Command = "s"
trigger1 = statetype = C
trigger1 = ctrl

; Fly
[State -1,Fly]
type = ChangeState
value = 1919
triggerall = power > 5000
triggerall = command = "s"
trigger1 = statetype = A
trigger1 = ctrl

; Fly2
[State -1,Fly2]
type = ChangeState
value = 191919
triggerall = Var(50) = 0
triggerall = power >= 50
triggerall = power > 5000
triggerall = command = "s"
trigger1 = statetype = A
trigger1 = ctrl

 ; Fly3
[State -1, Fly3]
type = ChangeState
value = 1800
triggerall = power > 1000
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl


 ; Fly5
[State -1, Fly5]
type = ChangeState
value = 632
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl


;kawarimi
; counter
[State -1, Substitution/Kawarimi no Jutsu]
type = ChangeState
value = 90123
triggerall = statetype = s
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = power >= 1000
trigger1 = movetype = H
trigger1 = MatchOver = 0

; counter
[State -1, Substitution/Kawarimi no Jutsu]
type = ChangeState
value = 90123
triggerall = stateno != 223
triggerall = statetype = a
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = power >= 1000
trigger1 = movetype = H
trigger1 = MatchOver = 0

;=========================================================================
