; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
; 

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------

[command]
name = "Charge"
command = c
time = 50


[command]
name = "Suiton: Hahonryuu"
command = y
time = 50

[command]
name = "Mokuton: Jubaku Eisou"
command = D, B, b
time = 50

[command]
name = "Suiton: Takitsubo no Jutsu"
command = D, F, b
time = 50

[command]
name = "Gufuu suika no jutsu!"
command = D, F, c
time = 30

[command]
name = "Mokuton no Jutsu 1"
command = x
time = 50

[command]
name = "Mokuton no Jutsu 2"
command = z
time = 50

[command]
name = "Mokuton no Jutsu 3"
command = D,B,c
time = 10

[command]
name = "Mokuton no Jutsu 4"
command = c
time = 10

[command]
name = "By"
command = D, B, y
time = 50

[command]
name = "UU"
command = U, U
time = 15

[command]
name = "DD"
command = D, D
time = 15

[command]
name = "superjump"
command = ~$D,U
time = 15

[command]
name = "superjumpf"
command = ~$D,UF
time = 15

[command]
name = "superjumpb"
command = ~$D,UB
time = 15

[command]
name = "Moku Bushin no Jutsu"
command = D, a
time = 15

[command]
name = "Taunt"
command = D,F,D,D,F,x
time = 15

;-| Special Motions |------------------------------------------------------

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
; Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
; Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
; Air Dash - Frente
[State -1, Air Dash - Frente]
type = ChangeState
value = 111
triggerall = command = "FF"
triggerall = power >= 50
trigger1 = statetype = A
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
; Air Dash - Trz
[State -1, Air Dash - Trz]
type = ChangeState
value = 112
triggerall = command = "BB"
triggerall = power >= 50
trigger1 = statetype = A
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
; Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = command = "y" || command = "z"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 10
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 10
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;===========================================================================
;---------------------------------------------------------------------------
; Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "Taunt"
trigger1 = statetype != A
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
;Charge Chakra
[State -1, Charge Chakra]
type = ChangeState
value = 430
triggerall = command = "Charge"
triggerall = power <=3999
trigger1 = (statetype = s) && ctrl
;===========================================================================
;---------------------------------------------------------------------------
; Combo1
[State -1, Combo1]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
; Combo2
[State -1, Combo2]
type = ChangeState
value = 210
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time >= 12
;===========================================================================
;---------------------------------------------------------------------------
; Combo3
[State -1, Combo3]
type = ChangeState
value = 220
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 210
trigger2 = time >= 15
;===========================================================================
;---------------------------------------------------------------------------
; Combo4
[State -1, Combo4]
type = ChangeState
value = 230
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 220
trigger2 = time >= 15
;===========================================================================
;---------------------------------------------------------------------------
; Combo5
[State -1, Combo5]
type = ChangeState
value = 240
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 230
trigger2 = time >= 15
;===========================================================================
;---------------------------------------------------------------------------
;Mokuton Combo1
[State -1, Mokuton Combo1]
type = ChangeState
value = 250
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
; Mokuton Combo2
[State -1, Mokuton Combo2]
type = ChangeState
value = 260
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 250
trigger2 = time >= 50
;===========================================================================
;---------------------------------------------------------------------------
; Mokuton Combo3
[State -1, Mokuton Combo3]
type = ChangeState
value = 270
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 260
trigger2 = time >= 30
;===========================================================================
;---------------------------------------------------------------------------
;Air Combo1
[State -1, Air Combo1]
type = ChangeState
value = 280
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = A
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
; Air Combo2
[State -1, Air Combo2]
type = ChangeState
value = 290
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 280
trigger2 = time >= 20
;===========================================================================
;---------------------------------------------------------------------------
[State -1,Mokuton no Jutsu 1]
type = ChangeState
value = 7223
triggerall = power >= 1500
triggerall = command = "Mokuton no Jutsu 1"
triggerall = var(0) = 0
trigger1 = statetype = c
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
;Mokuton no Jutsu2
[State -1,Mokuton no Jutsu 2]
type = ChangeState
value = 143
triggerall = power >= 1500
triggerall = command = "Mokuton no Jutsu 2"
triggerall = var(0) = 0
trigger1 = statetype = c
trigger1 = ctrl

;Mokuton no Jutsu3
[State -1,Mokuton no Jutsu 3]
type = ChangeState
value = 27
triggerall = power >= 1500
triggerall = command = "Mokuton no Jutsu 3"
triggerall = var(0) = 0
trigger1 = statetype = s
trigger1 = ctrl

;Mokuton no Jutsu4
[State -1,Mokuton no Jutsu 4]
type = ChangeState
value = 675
triggerall = power >= 1000
triggerall = command = "Mokuton no Jutsu 4"
triggerall = var(0) = 0
trigger1 = statetype = c
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
;Moku Bushin no Jutsu
[State -1, Moku Bushin no Jutsu]
type = ChangeState
value = 6000
triggerall = numhelper(6001) <=1
triggerall = var(10) = 0
Triggerall = power >=2000
Triggerall = command = "Moku Bushin no Jutsu"
trigger1 = statetype = c
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time >=7
trigger3 = stateno = 210
trigger3 = time >=7
trigger4 = stateno = 220
trigger4 = time >=7
trigger5 = stateno = 230
trigger5 = time >=7
trigger6 = stateno = 240
trigger6 = time >=7
trigger7 = stateno = 250
trigger7 = time >=7
trigger8 = stateno = 260
trigger8 = time >=7
trigger9 = stateno = 270
trigger9 = time >=7
;===========================================================================
;---------------------------------------------------------------------------
;Kunai Throw
[State -1, Kunai Throw]
type = ChangeState
value = 700
triggerall = command = "y"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = time >= 7
;===========================================================================
;---------------------------------------------------------------------------
; Crouch Kunai Throw
[State -1, Crouch Kunai Throw]
type = ChangeState
value = 703
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger1 = time >= 7
;===========================================================================
;---------------------------------------------------------------------------
;Kunai Throw Air
[State -1, Kunai Throw Air]
type = ChangeState
value = 710
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
;Kunai Explosiva
[State -1, Kunai Explosiva]
type = ChangeState
value = 715
triggerall = power >= 50
triggerall = command = "By"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = time >= 0
;===========================================================================
;---------------------------------------------------------------------------
;Teleport
[State -1, Teleport]
type = ChangeState
value = 65
triggerall = command = "z"
triggerall = power >= 20
trigger1 = statetype != A
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
[State -1, Wall Jump]
type = ChangeState
value = 46
triggerall = backedgebodydist <= 1 && backedgebodydist > -1
triggerall = command = "holdfwd"
triggerall = var(0) = 0
triggerall = Pos Y < -30
trigger1 = StateType = A
trigger1 = Ctrl
trigger1 = Vel X <= 0
;===========================================================================
;---------------------------------------------------------------------------
;Super Pulo
[state -1, Super Pulo]
type = changestate
triggerall = (command = "superjump" || command = "superjumpf" || command = "superjumpb")
trigger1 = ctrl
trigger1 = StateType = C
value = ifelse(command = "superjump",7000,ifelse(command = "superjumpf",7002,7004))
;===========================================================================
;---------------------------------------------------------------------------
;Mokuton: Mokujouheki!
[State -1, Mokuton: Mokujouheki!]
type = ChangeState
value = 400
triggerall = power >= 500
triggerall = command = "s"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
;Suiton: Hahonryuu
[State -1,Suiton: Hahonryuu ]
type = ChangeState
value = 825
triggerall = power >= 1000
triggerall = command = "Suiton: Hahonryuu"
triggerall = var(0) = 0
trigger1 = statetype = c
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
;Suiton: Takitsubo no Jutsu
[State -1,Suiton: Takitsubo no Jutsu ]
type = ChangeState
value = 870
triggerall = power >= 3000
triggerall = command = "Suiton: Takitsubo no Jutsu"
triggerall = var(0) = 0
trigger1 = statetype = S
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
;Gufuu suika no jutsu!
[State -1,Gufuu suika no jutsu!]
type = ChangeState
value = 362
triggerall = power >=2500
triggerall = command = "Gufuu suika no jutsu!"
triggerall = var(0) = 0
trigger1 = statetype = S
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
; Mokuton: Jubaku Eisou
[State -1, Mokuton: Jubaku Eisou]
type = ChangeState
value = 405
triggerall = power >=4000
trigger1 = life <= 500
triggerall = command = "Mokuton: Jubaku Eisou"
triggerall = var(0) = 0
trigger1 = statetype = S
trigger1 = ctrl
;===========================================================================
;---------------------------------------------------------------------------
; Kawarimi
[State -1, Kawarimi]
Type = ChangeState
Value = 500
triggerall = power >= 100
triggerall = var(0) = 0
Triggerall = Command = "a"
Triggerall = StateType != A
Trigger1 = StateNo = 5000
Trigger2 = StateNo = 5001
Trigger3 = StateNo = 5010
Trigger4 = StateNo = 5011
Trigger5 = StateNo = 5020
Trigger6 = StateNo = 5030
Trigger7 = StateNo = 5035
Trigger8 = StateNo = 5040
Trigger9 = StateNo = 5050
Trigger10 = StateNo = 5070
Trigger11 = StateNo = 5071
