; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
; 

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.


;------------------------------------------------------------------------
[command]
name = "powrt2"
command = s
time = 15
;------------------------------------------------------------------------
[command]
name = "powrt1"
command = s
time = 15
;------------------------------------------------------------------------
[command]
name = "slash-nibi1"
command = y
time = 15
;------------------------------------------------------------------------
[command]
name = "slash-nibi"
command = D,x
time = 15
;------------------------------------------------------------------------
[command]
name = "katon-nibi5"
command = z
time = 15
;------------------------------------------------------------------------
[command]
name = "katon dragon-nibi"
command = c
time = 15
;------------------------------------------------------------------------
[command]
name = "raiton-nibi"
command = b
time = 15
;------------------------------------------------------------------------
[command]
name = "katon-nibi4"
command = a
time = 15
;------------------------------------------------------------------------
[command]
name = "katon-nibi3"
command = z
time = 15
;------------------------------------------------------------------------
[command]
name = "katon-nibi2"
command = y
time = 15
;------------------------------------------------------------------------
[command]
name = "katon nibi1"
command = x
time = 15
;------------------------------------------------------------------------
[command]
name = "katon-nibi"
command = /c
time = 15
;------------------------------------------------------------------------
[command]
name = "promie"
command = /b
time = 15
;------------------------------------------------------------------------
[command]
name = "rasengan"
command = a
time = 15
;------------------------------------------------------------------------
[command]
name = "ogie"
command = /F,x
time = 15
;------------------------------------------------------------------------
[command]
name = "powrt"
command = D,F,s
time = 25
;------------------------------------------------------------------------
[command]
name = "katon..."
command = D,B,x
time = 25
;------------------------------------------------------------------------
[command]
name = "katon strzaa"
command = /B,x
time = 15
;------------------------------------------------------------------------
[command]
name = "piorun 6"
command = D,F,y
time = 25
;------------------------------------------------------------------------
[command]
name = "pocisk wybuchajcy"
command = /F,b
time = 25
;------------------------------------------------------------------------
[command]
name = "pocisk"
command = b
time = 15
;------------------------------------------------------------------------
[command]
name = "piorun4"
command = /B,y
time = 40
;------------------------------------------------------------------------
[command]
name = "piorun3"
command = /F,y
time = 40
;------------------------------------------------------------------------
[command]
name = "katon l"
command = z
time = 15
;------------------------------------------------------------------------
[command]
name = "katon-1tail"
command = /c
time = 15
;------------------------------------------------------------------------
[command]
name = "chakra"
command = /s
time = 15
;------------------------------------------------------------------------
[command]
name = "pocisk elektryczny"
command = /B,b
time = 25
;------------------------------------------------------------------------
[command]
name = "smok4"
command = D,B,z
time = 25
;------------------------------------------------------------------------
[command]
name = "smok3"
command = D,F,z
time = 40
;------------------------------------------------------------------------
[command]
name = "piorun2"
command = D,B,a
time = 25
;------------------------------------------------------------------------
[command]
name = "piorun"
command = D,F,a
time = 25
;------------------------------------------------------------------------
[command]
name = "smok1"
command = z
time = 15
;------------------------------------------------------------------------
[command]
name = "housenka"
command = z
time = 15
;------------------------------------------------------------------------
[command]
name = "katon p"
command = c
time = 15
;------------------------------------------------------------------------
[command]
name = "smok"
command = y
time = 15
;------------------------------------------------------------------------
[command]
name = "katon b"
command = y
time = 15
;------------------------------------------------------------------------
[command]
name = "slash"
command = x
time = 15
;------------------------------------------------------------------------
[command]
name = "furia"
command = c
time = 15
;-------------------------------------------------------------------------
[command]
name = "katon go"
command = x
time = 15
;-------------------------------------------------------------------------
[command]
name = "katon"
command = /c
time = 15
;-------------------------------------------------------------------------
[command]
name = "i"
command = b
time = 15
;-------------------------------------------------------------------------
 [command]
name = "c2"
command = c
time = 15
;-------------------------------------------------------------------------
[command]
name = "c1"
command = b
time = 15
;-----------------------------------------------------------------------------
[command]
name = "1a"
command = a
time = 15
;-----------------------------------------------------------------------------
[command]
name = "a1"
command = a
time = 15
;----------------------------------------------------------------------------
[command]
name = "1"
command = a
time = 15
;---------------------------------------------------------------------------
[command]
name = "Atk-1tail"
command = a
time = 15
;-------------------------------------------------------------------------

;-| Default Values |-------------------------------------------------------
[command]
name = "a"
command = a
time = 15

[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
[command]
name = "transformacja 2"
command = s
time = 15

command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
[command]
name = "transformacja 1 tail"
command = s
time = 15

command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------

;-| Special Motions |------------------------------------------------------

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]



;powrt-nibi-1-tail
[State -1, powrt-nibi-1-tail]
type = ChangeState
value = 505060
triggerall = command = "powrt2"
triggerall = var(0) = 2
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;powrt1
[State -1, powrt1]
type = ChangeState
value = 505040
triggerall = command = "powrt1"
triggerall = var(0) = 2
trigger1 = (statetype = c) && ctrl
;-------------------------------------------------------------------------
 ;slash-nibi1
[State -1, slash-nibi1]
type = ChangeState
value = 20219716
triggerall = command = "slash-nibi1"
triggerall = power >= 250
triggerall = var(0) = 2
trigger1 = (statetype = c) && ctrl
;-------------------------------------------------------------------------
 ;slash-nibi
[State -1, slash-nibi]
type = ChangeState
value = 20219715
triggerall = command = "slash-nibi"
triggerall = power >= 200
triggerall = var(0) = 2
trigger1 = (statetype = c) && ctrl
;-------------------------------------------------------------------------
 ;katon-nibi5
[State -1, katon-nibi5]
type = ChangeState
value = 20219712
triggerall = command = "katon-nibi5"
triggerall = power >= 2000
triggerall = var(0) = 2
trigger1 = (statetype = c) && ctrl
;-------------------------------------------------------------------------
;katon dragon-nibi
[State -1, katon dragon-nibi]
type = ChangeState
value = 20219711
triggerall = command = "katon dragon-nibi"
triggerall = power >= 1000
triggerall = var(0) = 2
trigger1 = (statetype = c) && ctrl
;-------------------------------------------------------------------------
;raiton-nibi
[State -1, raiton-nibi]
type = ChangeState
value = 20219710
triggerall = command = "raiton-nibi"
triggerall = power >= 1000
triggerall = var(0) = 2
trigger1 = (statetype = c) && ctrl
;-------------------------------------------------------------------------
;katon-nibi4
[State -1, katon-nibi4]
type = ChangeState
value = 2021979
triggerall = command = "katon-nibi4"
triggerall = power >= 1000
triggerall = var(0) = 2
trigger1 = (statetype = c) && ctrl
;-------------------------------------------------------------------------
 ;katon-nibi3
[State -1, katon-nibi3]
type = ChangeState
value = 2021978
triggerall = command = "katon-nibi3"
triggerall = power >= 1700
triggerall = var(0) = 2
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
 ;katon-nibi2
[State -1, katon-nibi2]
type = ChangeState
value = 2021977
triggerall = command = "katon-nibi2"
triggerall = power >= 900
triggerall = var(0) = 2
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
 ;katon nibi1
[State -1, katon nibi1]
type = ChangeState
value = 2021976
triggerall = var(0) = 2
Triggerall = power > 1500
triggerall = command = "katon nibi1"
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
 ;promie
[State -1, promie]
type = ChangeState
value = 1972
triggerall = command = "promie"
triggerall = var(0) = 2
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;katon
[State -1, Katon-nibi]
type = ChangeState
value = 2021973
Triggerall = power > 60
triggerall = command = "katon-nibi"
triggerall = var(0) = 2
trigger1 = statetype = s
trigger1 = ctrl
;-------------------------------------------------------------------------
;rasengan
[State -1, rasengan]
type = ChangeState
value = 87295
triggerall = command = "rasengan"
triggerall = var(0) = 2
triggerall = power >= 1000
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;ogie
[State -1, ogie]
type = ChangeState
value = 70004
triggerall = command = "ogie"
triggerall = var(0) = 1
triggerall = power >= 1700
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;powrt
[State -1, powrt]
type = ChangeState
value = 70000
triggerall = command = "powrt"
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;katon...
[State -1, katon...]
type = ChangeState
value = 50559
triggerall = command = "katon..."
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
; Chakra
[State -1, Chakra-1tail]
type = ChangeState
value = 7001
triggerall = command = "chakra"
triggerall = var(0) = 1
trigger1 = statetype = S
trigger1 = ctrl
;-------------------------------------------------------------------------
 ;katon strzaa
[State -1, katon strzaa]
type = ChangeState
value = 50557
triggerall = command = "katon strzaa"
triggerall = var(0) = 1
triggerall = power >= 1500
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
 ;piorun 6
[State -1, piorun6]
type = ChangeState
value = 50555
triggerall = command = "piorun 6"
triggerall = var(0) = 1
triggerall = power >= 1000
trigger1 = (statetype = s) && ctrl

;-------------------------------------------------------------------------
;pocisk wybuchajcy
[State -1, pocisk wybuchajcy]
type = ChangeState
value =  40504
triggerall = command = "pocisk wybuchajcy"
triggerall = power >= 30
triggerall = var(0) = 0
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;pocisk wybuchajcy-1tail
[State -1, pocisk wybuchajcy-1tail]
type = ChangeState
value =  40503
triggerall = command = "pocisk wybuchajcy"
triggerall = power >= 30
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;pocisk elektryczny-1tail
[State -1, pocisk elektryczny-1tail]
type = ChangeState
value = 40502
triggerall = command = "pocisk elektryczny"
triggerall = power >= 30
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
 ;pocisk
[State -1, pocisk]
type = ChangeState
value = 40501
triggerall = command = "pocisk"
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;piorun2
[State -1, piorun3]
type = ChangeState
value =  40449
triggerall = command = "piorun4"
triggerall = power >= 1000
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;piorun2
[State -1, piorun3]
type = ChangeState
value =  40339
triggerall = command = "piorun3"
triggerall = power >= 1000
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;piorun2
[State -1, piorun2]
type = ChangeState
value = 43208
triggerall = command = "piorun2"
triggerall = power >= 1000
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;smok4
[State -1, smok4]
type = ChangeState
value = 40315
triggerall = command = "smok4"
triggerall = power >= 1600
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;smok3-1tail
[State -1, smok3-1tail]
type = ChangeState
value = 40312
triggerall = command = "smok3"
triggerall = power >= 1500
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;piorun
[State -1, piorun]
type = ChangeState
value = 403010
triggerall = command = "piorun"
triggerall = power >= 120
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;-------------------------------------------------------------------------
;smok1-1tail
[State -1, smok1-1tail]
type = ChangeState
value = 403007
triggerall = command = "smok1"
triggerall = power >= 1000
triggerall = var(0) = 1
trigger1 = (statetype = c) && ctrl
;-------------------------------------------------------------------------
;housenka
[State -1, housenka]
type = ChangeState
value = 403005
triggerall = command = "katon l"
triggerall = power >= 900
triggerall = command != "holddown"
triggerall = var(0) = 1
trigger1 = (statetype = s) && ctrl
;------------------------------------------------------------------------
;smok-1tail
[State -1,smok-1tail]
type = ChangeState
value = 403002
triggerall = command = "smok"
triggerall = var(0) = 1
triggerall = power >= 1000
trigger1 = (statetype = c) && ctrl
;------------------------------------------------------------------------
;katon b-1tail
[State -1, katonb-1tail]
type = ChangeState
value = 40300
triggerall = command = "katon b"
triggerall = var(0) = 1
triggerall = power >= 850
trigger1 = (statetype = s) && ctrl
;------------------------------------------------------------------------
;katon go
[State -1, katon1-1tail]
type = ChangeState
value = 40225
triggerall = command = "katon go"
triggerall = var(0) = 1
Triggerall = power > 2000
trigger1 = (statetype = c) && ctrl
;------------------------------------------------------------------------
[State -1, slash-1tail]
type = ChangeState
value = 40224
triggerall = power >= 500
triggerall = command = "slash"
triggerall = var(0) = 1
trigger1 = statetype = s
trigger1 = ctrl


[State -1, furia-1tail]
type = ChangeState
value = 40222
triggerall = power >= 100
triggerall = command = "furia"
triggerall = var(0) = 1
trigger1 = statetype = s
trigger1 = ctrl

;katon-1tail
[State -1, katon-1tail]
type = ChangeState
value = 40220
triggerall = command = "katon-1tail"
triggerall = power >= 50
triggerall = var(0) = 1
trigger1 = (statetype = c) && ctrl
;------------------------------------------------------------------------
; Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "s"
trigger1 = statetype = S
trigger1 = ctrl

;----------------------------------------------------------------------
;pocisk elektryczny
[State -1, pocisk elektryczny]
type = ChangeState
value = 40217
triggerall = command = "pocisk elektryczny"
triggerall = power >= 30
triggerall = var(0) = 0
trigger1 = (statetype = s) && ctrl
;----------------------------------------------------------------------
;smok4
[State -1, smok4]
type = ChangeState
value = 40215
triggerall = command = "smok4"
triggerall = power >= 1600
triggerall = var(0) = 0
trigger1 = (statetype = s) && ctrl
;----------------------------------------------------------------------
;smok3
[State -1, smok3]
type = ChangeState
value = 40212
triggerall = command = "smok3"
triggerall = power >= 1500
triggerall = var(0) = 0
trigger1 = (statetype = s) && ctrl
;----------------------------------------------------------------------
;piorun2
[State -1, piorun2]
type = ChangeState
value = 40208
triggerall = command = "piorun2"
triggerall = power >= 1000
triggerall = var(0) = 0
trigger1 = (statetype = s) && ctrl
;----------------------------------------------------------------------
;piorun
[State -1, piorun]
type = ChangeState
value = 40206
triggerall = command = "piorun"
triggerall = power >= 120
triggerall = var(0) = 0
trigger1 = (statetype = s) && ctrl
;----------------------------------------------------------------------
;smok1
[State -1, smok1]
type = ChangeState
value = 40203
triggerall = command = "smok1"
triggerall = power >= 1000
triggerall = var(0) = 0
trigger1 = (statetype = c) && ctrl
;----------------------------------------------------------------------
;housenka
[State -1, housenka]
type = ChangeState
value = 4400
triggerall = command = "housenka"
triggerall = power >= 900
triggerall = command != "holddown"
triggerall = var(0) = 0
trigger1 = (statetype = s) && ctrl
;----------------------------------------------------------------------
;smok
[State -1,smok]
type = ChangeState
value = 32000
triggerall = command = "smok"
triggerall = var(0) = 0
triggerall = power >= 1000
trigger1 = (statetype = c) && ctrl
;----------------------------------------------------------------------
;katon b
[State -1, katonb]
type = ChangeState
value = 31998
triggerall = command = "katon b"
triggerall = var(0) = 0
triggerall = power >= 850
trigger1 = (statetype = s) && ctrl
;----------------------------------------------------------------------
[State -1, slash]
type = ChangeState
value = 31997
triggerall = power >= 500
triggerall = command = "slash"
triggerall = var(0) = 0
trigger1 = statetype = s
trigger1 = ctrl
;----------------------------------------------------------------------
; Suiton: Suirou No Jutsu
[State -1, Suiton: Suirou No Jutsu]
type = ChangeState
value = 31995
triggerall = power >= 100
triggerall = command = "c"
triggerall = var(0) = 0
trigger1 = statetype = s
trigger1 = ctrl
;----------------------------------------------------------------------
;katon go
[State -1, katon1]
type = ChangeState
value = 1110
triggerall = command = "katon go"
triggerall = var(0) = 0
Triggerall = power > 2000
trigger1 = (statetype = c) && ctrl
;--------------------------------------------------------------------
;katon
[State -1, Katon]
type = ChangeState
value = 1717
Triggerall = power > 60
triggerall = command = "katon"
triggerall = var(0) = 0
trigger1 = statetype = c
trigger1 = ctrl
;------------------------------------------------------------------
;kkunai
[State -1, kunai]
type = ChangeState
value = 292
triggerall = var(0) = 0
triggerall = command = "i"
trigger1 = statetype = S
trigger1 = ctrl
;------------------------------------------------------------------
;c1
[State -1, 290]
type = ChangeState
value = 290
triggerall = var(0) = 0
triggerall = power>50
triggerall = command = "c1"
trigger1 = (statetype = c) && ctrl
;------------------------------------------------------------------
;c1
[State -1, 291]
type = ChangeState
value = 291
triggerall = var(0) = 1
triggerall = power>100
triggerall = command = "c1"
trigger1 = (statetype = c) && ctrl
;------------------------------------------------------------------
;250
[State -1, 291]
type = ChangeState
value = 250
triggerall = command = "1"
triggerall = var(0) = 0
trigger1 = (statetype = c) && ctrl
;--------------------------------------------------------------------
[State -1, 1]
type = ChangeState
value = 2501
triggerall = command = "1a"
triggerall = var(0) = 1
trigger1 = (statetype = c) && ctrl
;--------------------------------------------------------------------
;Light Punch
[State -1, Light Punch]
type = ChangeState
value = 200
Triggerall = command = "a"
triggerall = var(0) = 0
Triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;-------------------------------------------------------------------
;medium punch
[state -1, Medium Punch]
type = ChangeState
value = 220
triggerall = stateno = 200
triggerall = command = "a"
triggerall = var(0) = 0
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 5
;-------------------------------------------------------------------
;heavy punch
[state -1, Heavy Punch]
type = ChangeState
value = 230
triggerall = stateno = 220
triggerall = command = "a"
triggerall = var(0) = 0
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 9
;---------------------------------------------------------------------------
;Light Punch-1tail
[State -1, Light Punch-1tail]
type = ChangeState
value = 260
Triggerall = command = "a1"
triggerall = var(0) = 1
Triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;-------------------------------------------------------------------
;medium punch-1tail
[state -1, Medium Punch-1tail]
type = ChangeState
value = 270
triggerall = stateno = 260
triggerall = command = "a1"
triggerall = var(0) = 1
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 5
;-------------------------------------------------------------------
;heavy punch-1tail
[state -1, Heavy Punch-1tail]
type = ChangeState
value = 280
triggerall = stateno = 270
triggerall = command = "a1"
triggerall = var(0) = 1
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 9
;---------------------------------------------------------------------------
;transformacja 2
[State -1, 3000]
type = ChangeState
triggerall = var(0) = 1
value = 3000
triggerall = command = "transformacja 2"
trigger1 = (statetype = c) && ctrl
;----------------------------------------------------------------------------
;transformacja 1 tail
[State -1, 2999]
type = ChangeState
value = 2999
triggerall = var(0) = 0
triggerall = command = "transformacja 1 tail"
trigger1 = (statetype = c) && ctrl

;===========================================================================
;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
; Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = command = "y" || command = "z"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 10
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 10
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;===========================================================================
;---------------------------------------------------------------------------
; Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "s"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------

