;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$;
;---------------------------------------------------------------------------;
;---------------------------------------------------------------------------;
;------------------------------;CLIFF-Rikudo-Sanin--------------------------;
;------------------------------;<----------------->-------------------------;
;--------------------------------------CMD----------------------------------;
;------------------------------------<----->--------------------------------;
;-----------------------------------MOVELIST--------------------------------;
;----------------------------------<-------->-------------------------------;
;---------------------------------------------------------------------------;
;$$$$$$$$$$$$$$$$$$$$$$$$$(=CODING-SCHOOL.UCOZ.COM=)$$$$$$$$$$$$$$$$$$$$$$$$;


; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
; 

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------

;-| Special Motions |------------------------------------------------------

;--------------------------------------------------------------------------
;Charge_Down_Up_High Jump
[Command]
name = "High Jump"
command = ~$D, UF
time = 10
buffer.time = 2

;Charge_Down_Up_High Jump Forward
[Command]
name = "High Jump Forward"
command = ~$D, U
time = 10
buffer.time = 2

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

[command]
name = "DRAGON SUITON"
command = D,F,y
time = 10

[command]
name = "AA"
command = D,F,b
time = 10

[command]
name = "MUTIPLE WATER JUTSU"
command = D,B,b
time = 10

[command]
name = "earth jutsu"
command = D,F,z
time = 10

[command]
name = "earth mud dragon"
command = D,B,z
time = 10

[command]
name = "katon ball flare"
command = D,F,a
time = 10

[command]
name = "magma dragon"
command = D,B,a
time = 10


;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = c+y
time = 1

[Command]
name = "recovery"
command = x+a
time = 1

[Command]
name = "recovery"
command = z+b
time = 1

[Command]
name = "recovery"
command = y+b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

[Command]
name = "fly"
command = ~U,s
time =15



[Command]
name = "fly1"
command = ~U,x
time =15

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

[State -1, rock bolder]
type = ChangeState
value = 1111410
triggerall = command = "magma dragon"
trigger1 = power >= 1000
trigger1 = (statetype = S) && ctrl



[State -1, big dragon eath jutsu]
type = ChangeState
value = 111111410
triggerall = command = "MUTIPLE WATER JUTSU"
trigger1 = power >= 1000
trigger1 = (statetype = S) && ctrl




[State -1, mouth snake eath jutsu]
type = ChangeState
value = 111111222
triggerall = command = "AA"
trigger1 = power >= 1000
trigger1 = (statetype = S) && ctrl



[State -1, EARTH SNAKE JUTSU]
type = ChangeState
value = 11111410
triggerall = numhelper(600412) = 0
triggerall = power >= 1200
triggerall = command = "katon ball flare"
trigger1 = (statetype = s) && ctrl

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$;
;---------------------------------------------------------------------------;
;---------------------------------------------------------------------------;
;------------------------------;CLIFF-Rikudo-Sanin--------------------------;
;------------------------------;<----------------->-------------------------;
;---------------------------------------------------------------------------;
;---------------------------------------------------------------------------;
;-----------------------------------MOVELIST--------------------------------;
;----------------------------------<-------->-------------------------------;
;---------------------------------------------------------------------------;
;$$$$$$$$$$$$$$$$$$$$$$$$$(=CODING-SCHOOL.UCOZ.COM=)$$$$$$$$$$$$$$$$$$$$$$$$;

[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, Air Dash Fwd]
type = ChangeState
value = 1110
trigger1 = command = "FF"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, Air Dash Back]
type = ChangeState
value = 1115
trigger1 = command = "BB"
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = stateno != 105

;---------------------------------------------------------------------------

[State -1, High Jump]
type = ChangeState
value = 1160
triggerall = command = "High Jump"
triggerall = statetype != A
trigger1   = ctrl
trigger2   = stateno = 100
trigger2   = animelemtime(3) >= 0

;---------------------------------------------------------------------------

[State -1, High Jump Forward]
type = ChangeState
value = 1170
triggerall = command = "High Jump Forward"
triggerall = statetype != A
trigger1   = ctrl

;---------------------------------------------------------------------------

[state -1, WallRun]
type = changestate
value = 101
triggerall = stateno = 20 || stateno = 100
triggerall = command = "hold_s" && command = "holdback"
trigger1 = backedgedist < 5
trigger1 = command = "holdback"
trigger2 = frontedgedist < 5
trigger2 = command = "holdfwd"

;---------------------------------------------------------------------------

[state -1, WAll Jump ]
type = changestate
value = 45
triggerall = stateno = 104
triggerall = (ctrl) && (command = "holdup")
trigger1 = pos y <= -170
trigger1 = time > 20
trigger2 = pos y > -170

;---------------------------------------------------------------------------

;Throw 1
[State -1,Throw Enemy 1]
Type = ChangeState
Value = 841
trigger1 = command = "c"
Triggerall = Command != "holddown"
Trigger1 = ctrl = 1
Trigger1 = StateType = S



;---------------------------------------------------------------------------

[State -1, Chacra charge]
type = ChangeState
value = 195
triggerall = command = "hold_x"
triggerall = command != "holddown"
trigger1 = statetype = s
trigger1 = ctrl = 1

;---------------------------------------------------------------------------

[State -1, Teleport]
type = ChangeState
value = 200
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, Combo 1]
type = ChangeState
value = 210
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, Combo 2]
type = ChangeState
value = 220
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = time >= 11
trigger2 = stateno = 210
trigger2 = movecontact

;---------------------------------------------------------------------------

[State -1, Combo 3]
type = ChangeState
value = 11141011
triggerall = power>= 500
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = time >= 11
trigger2 = stateno = 220
trigger2 = movecontact


[State -1, 2 dragon earth ]
type = ChangeState
value = 111410
triggerall = power>= 1000
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl





;---------------------------------------------------------------------------

;---------------------------------------------------------------------------

[State -1, rising earth swamp]
type = ChangeState
value = 11410
TRIGGERALL = POWER >= 1000
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1,Kunai Throw]
type = ChangeState
value = 600
Triggerall = command = "y"
Triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------

[State -1,Kunai Throw]
type = ChangeState
value = 600
Triggerall = command = "s"
Triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1,Kunai Air Throw]
type = ChangeState
value = 610
Triggerall = command = "y"
Triggerall = command != "holddown"
trigger1 = statetype = A
trigger1 = ctrl

[State -1,Kunai Air Throw]
type = ChangeState
value = 610
Triggerall = command = "b"
Triggerall = command != "holddown"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------

[STATE -1, Kunai Air Explode Throw]
TYPE = CHANGESTATE
VALUE = 559333
triggerall = numhelper(1201) < 6
triggerall = command = "c"
trigger1 = statetype = A
trigger1 = ctrl


[STATE -1, Kunai Air Explode Throw]
TYPE = CHANGESTATE
VALUE = 559333
triggerall = numhelper(1201) < 6
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

[STATE -1, Kunai Air Explode Throw]
TYPE = CHANGESTATE
VALUE = 559333
triggerall = numhelper(1201) < 6
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------

;---------------------------------------------------------------------------

[State -1,Bunshin]
type = ChangeState
value = 400
triggerall = numhelper(0) < 4
triggerall = command = "b"
triggerall = power >= 500
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------

[State -1, Kawarimi]
type = ChangeState
value = 8099
triggerall = stateno = [5000,5999]
TRIGGERALL = power >= 20
triggerall = command = "a"
trigger1 = movetype = H

;---------------------------------------------------------------------------

[State -1, Earth swamp dragon]
type = ChangeState
value = 3031
triggerall = power >= 1000
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, Earth spikes charge]
type = ChangeState
value = 428
triggerall = power >= 1000
triggerall = command = "hold_z"
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------

[State -1, Earth jutsu 1]
type = ChangeState
value = 440
triggerall = power >= 1000
triggerall = command = "hold_a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Earth jutsu 2]
type = ChangeState
value = 410
triggerall = power >= 1000
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------

[State -1,EARTH summon 1]
type = ChangeState
value = 17000
triggerall = var(1) = 0
triggerall = power >= 1000
triggerall = command = "s"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------

[state -1,EARTH summon 2]
type = changestate
value = 17000
triggerall = var(1) = 0
triggerall = power >= 1000
triggerall = life <= 100
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
; fly when jumping
[State -1, fly when jumping 1]
type = ChangeState
value = 1900
triggerall = command = "fly"
trigger1 = statetype = A
trigger1 = ctrl = 1
triggerall = var(33) = 0

; fly when jumping
[State -1, fly when jumping 2]
type = ChangeState
value = 1900
triggerall = command = "fly1"
trigger1 = statetype = A
trigger1 = ctrl = 1
triggerall = var(33) = 0

[State -1, fly stance]
type = ChangeState
value = 50
triggerall = command = "fly"
trigger1 = stateno = 1900
trigger1 = statetype = S
trigger1 = ctrl = 0
triggerall = var(33) = 0

[State -1, Fly]
type = ChangeState
triggerall = Var(15)= 1 && movetype != H && (p2statetype = A || p2statetype = S)
trigger1 = ctrl = 1 && alive = 1 && p2dist Y< -30 && p2movetype != A && pos Y= 0 && random = 850
trigger1 = P2Life > 0 && p2stateno != 40 && p2stateno != 45 && p2stateno != 50 && p2stateno != 51 && p2stateno != 52
trigger2 = random = 200 && ctrl = 1
value = 1800
triggerall = var(33) = 0

[State -1, Fly]
type = ChangeState
triggerall = Var(15)= 1 && movetype != H && (p2statetype = A || p2statetype = S)
trigger1 = ctrl = 1 && alive = 1 && p2dist Y< -30 && p2movetype != A && pos Y <-50
trigger1 = P2Life > 0 && p2stateno != 40 && p2stateno != 45 && p2stateno != 50 && p2stateno != 51 && p2stateno != 52
trigger2 = random = 200 && ctrl = 1
value = 1900
triggerall = var(33) = 0

[State -1, Fly]
type = ChangeState
triggerall = Var(15)= 1 && movetype != H && stateno = 1900
trigger1 = alive = 1 && p2statetype = S && p2dist Y> 100
trigger1 = P2Life > 0 && p2stateno = 0 || p2stateno = 20 || p2stateno = 11
trigger2 = p2statetype != A && time > 90 && pos Y!= 0
value = 50
triggerall = var(33) = 0

[State -3, AirGuard]
type = ChangeState
triggerall = (Var(0) = 1) && (StateType = A) && (Pos Y < 0) && (P2BodyDist Y >= -120)
triggerall = (StateType = A) && (P2MoveType = A)
trigger1 = ((P2BodyDist X <= 120) && (Ctrl)) || (StateNo = [140, 155])
value = 132
triggerall = var(33) = 0


;--------------------------------------------------------------------------------------;
;--------------------------------------------------------------------------------------;
;--------------------------------------------------------------------------------------;
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$(=CODING-SCHOOL.UCOZ.COM=)$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$;
;--------------------------------------------------------------------------------------;
;--------------------------------------------------------------------------------------;
