; The CMD file.
[Command]
name = "CPU1"
command = B,F,B,a
time = 0

[Command]
name = "CPU2"
command = B,F,B,b
time = 0

[Command]
name = "CPU3"
command = B,F,B,c
time = 0

[Command]
name = "CPU4"
command = B,F,B,x
time = 0

[Command]
name = "CPU5"
command = B,F,B,y
time = 0

[Command]
name = "CPU6"
command = B,F,B,z
time = 0

[Command]
name = "CPU7"
command = B,D,B,a
time = 0

[Command]
name = "CPU8"
command = B,D,B,b
time = 0

[Command]
name = "CPU9"
command = B,D,B,c
time = 0

[Command]
name = "CPU10"
command = B,D,B,x
time = 0

[Command]
name = "CPU11"
command = B,D,B,y
time = 0

[Command]
name = "CPU12"
command = B,D,B,z
time = 0

[Command]
name = "CPU13"
command = B,D,B,s
time = 0

[Command]
name = "CPU14"
command = B,F,B,s
time = 0

; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;-| AI Activators|--------
[Command]
name = "CPU"
command = a
time = 1

[Command]
name = "CPU"
command = b
time = 1

[Command]
name = "CPU"
command = c
time = 1

[Command]
name = "CPU"
command = x
time = 1

[Command]
name = "CPU"
command = y
time = 1

[Command]
name = "CPU"
command = z
time = 1

[Command]
name = "CPU"
command = s
time = 1

[Command]
name = "CPU"
command = F
time = 1

[Command]
name = "CPU"
command = B
time = 1

[Command]
name = "CPU"
command = U
time = 1

[Command]
name = "CPU"
command = D
time = 1

[Command]
name = "AI"
command = U, U, U, U, U, U, U, U, b, U, a, U, U, U, U, U, c, U, z, U
time = 1

[Command]
name = "AI1"
command = D, D, D, U, U, U, x, U, U, U, a, U, U, U, U, U, U, U, b, U
time = 1

[Command]
name = "AI2"
command = F, F, F, U, U, U, U, U, x, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI3"
command = B, B, B, U, U, U, U, U, x, U, U, U, z, U, U, U, U, U, U, b
time = 1

[Command]
name = "AI4"
command = U, U, U, U, U, U, U, a, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI5"
command = D, D, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI6"
command = F, F, F, U, U, U, U, U, U, y, U, U, z, y, U, U, U, U, U, U
time = 1

[Command]
name = "AI7"
command = B, B, B, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI8"
command = U, U, U, U, U, U, U, a, U, U, U, U, U, y, y, U, U, U, U, U
time = 1

[Command]
name = "AI9"
command = D, D, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI10"
command = F, B, F, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI11"
command = D, U, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI12"
command = F, B, F, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI13"
command = B, F, B, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI14"
command = U, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI15"
command = D, U, D, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI16"
command = F, B, F, U, U, U, U, U, U, U, F, U, a, U, U, U, U, U, U, U
time = 1

[Command]
name = "AI17"
command = B, F, B, U, U, U, U, a, U, U, B, U, U, U, U, U, c, U, U, b
time = 1

[Command]
name = "AI18"
command = U, D, U, U, U, U, U, z, U, U, U, y, U, y, U, D, U, U, U, U
time = 1

[Command]
name = "AI19"
command = D, U, D, U, U, U, U, U, U, U, U, U, U, U, U, U, D, U, U, U
time = 1

[Command]
name = "AI20"
command = F, B, F, U, U, U, U, U, U, F, B, z, a, U, U, U, D, U, U, U
time = 1


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------


[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.


command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.


command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;

;-| Special Motions |------------------------------------------------------


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10


[command]
name = "1"
command = D,F,a
time = 10

[command]
name = "2"
command = D,B,a
time = 10

[command]
name = "3"
command = D,F,x
time = 10

[command]
name = "4"
command = D,B,x
time = 10

[command]
name = "5"
command = D,F,z
time = 10

[command]
name = "6"
command = D,B,z
time = 10

[command]
name = "7"
command = D,B,y
time = 10

[command]
name = "8"
command = D,F,y
time = 10

[command]
name = "9"
command = D,F,c
time = 10

[command]
name = "10"
command = D,B,c
time = 10

[command]
name = "11"
command = D,B,b
time = 10

[command]
name = "111"
command = D,F,b
time = 10

[Command]
name = "Five water defence"
command = x+z
time = 1



;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1


[command]
name = "down_s"
command = /$D,s
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1


[Command]
name = "start"
command = s
time = 1

[command]
name = "down_s"
command = s
time = 1
;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[command]
name = "hold_x"
command = /$x
time = 1

[command]
name = "hold_y"
command = /$y
time = 1

[command]
name = "hold_c"
command = /$c
time = 1

[command]
name = "hold_a"
command = /$a
time = 1

[command]
name = "hold_b"
command = /$b
time = 1

[command]
name = "hold_z"
command = /$z
time = 1

[command]
name = "hold_s"
command = /$s
time = 1
;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1,]


[State -1,AI KILLER XOR]
type = VarSet
triggerall = var(50)=1
trigger1 = (command = "a") ^^ (command = "a")
trigger2 = (command = "b") ^^ (command = "b")
trigger3 = (command = "c") ^^ (command = "c")
trigger4 = (command = "x") ^^ (command = "x")
trigger5 = (command = "y") ^^ (command = "y")
trigger6 = (command = "z") ^^ (command = "z")
trigger7 = (command = "start") ^^ (command = "start")
trigger8 = (command = "hold_a") ^^ (command = "hold_a")
trigger9 = (command = "hold_b") ^^ (command = "hold_b")
trigger10 = (command = "hold_c") ^^ (command = "hold_c")
trigger11 = (command = "hold_x") ^^ (command = "hold_x")
trigger12 = (command = "hold_y") ^^ (command = "hold_y")
trigger13 = (command = "hold_z") ^^ (command = "hold_z")
trigger14 = (command = "hold_s") ^^ (command = "hold_s")
trigger15 = (command = "holdfwd") ^^ (command = "holdfwd")
trigger16 = (command = "holdback") ^^ (command = "holdback")
trigger17 = (command = "holdup") ^^ (command = "holdup")
trigger18 = (command = "holddown") ^^ (command = "holddown")
trigger19 = (command = "recovery") ^^ (command = "recovery")
v = 50
value = 1

;---------------------------------------------------------------------------
[STATE ,-1
;---------------------------------------------------------------------------

[State -1,AI ON air attacks]
type = VarSet
triggerall = statetype = A
triggerall = command = "CPU"
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
trigger13 = command = "CPU13"
trigger14 = command = "CPU14"
v = 50
value = 1

[State -1, AI ON stand basic attacks]
type = VarSet
triggerall = statetype = S
trigger1 = command = "AI1"
trigger2 = command = "AI2"
trigger3 = command = "AI3"
trigger4 = command = "AI4"
trigger5 = command = "AI5"
trigger6 = command = "AI6"
trigger7 = command = "AI7"
trigger8 = command = "AI8"
trigger9 = command = "AI9"
trigger10 = command = "AI10"
trigger11 = command = "AI11"
trigger12 = command = "AI12"
trigger13 = command = "AI13"
trigger14 = command = "AI14"
trigger15 = command = "AI15"
trigger16 = command = "AI16"
trigger17 = command = "AI17"
trigger18 = command = "AI18"
trigger19 = command = "AI19"
trigger20 = command = "AI20"
v = 50
value = 1

[State -1,AI ON stand specials]
type = VarSet
triggerall = statetype = S
triggerall = command = "CPU"
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
trigger13 = command = "CPU13"
trigger14 = command = "CPU14"
v = 50
value = 1

[State -1,AI ON stand super specials]
type = VarSet
triggerall = statetype = S
triggerall = p2statetype = S
triggerall = command = "CPU"
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
trigger13 = command = "CPU13"
trigger14 = command = "CPU14"
v = 50
value = 1

[State -1,AI ON crouch basic attacks]
type = VarSet
triggerall = statetype = C
trigger1 = command = "AI1"
trigger2 = command = "AI2"
trigger3 = command = "AI3"
trigger4 = command = "AI4"
trigger5 = command = "AI5"
trigger6 = command = "AI6"
trigger7 = command = "AI7"
trigger8 = command = "AI8"
trigger9 = command = "AI9"
trigger10 = command = "AI10"
trigger11 = command = "AI11"
trigger12 = command = "AI12"
trigger13 = command = "AI13"
trigger14 = command = "AI14"
trigger15 = command = "AI15"
trigger16 = command = "AI16"
trigger17 = command = "AI17"
trigger18 = command = "AI18"
trigger19 = command = "AI19"
trigger20 = command = "AI20"
v = 50
value = 1

[State -1,AI ON crouch specials]
type = VarSet
triggerall = statetype = C
triggerall = command = "CPU"
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
trigger13 = command = "CPU13"
trigger14 = command = "CPU14"
v = 50
value = 1

[State -1,AI ON crouch super specials]
type = VarSet
triggerall = statetype = C
triggerall = p2statetype = C
triggerall = command = "CPU"
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
trigger13 = command = "CPU13"
trigger14 = command = "CPU14"
v = 50
value = 1

;---------------------------------------------------------------------------
[STATE ,-1
;---------------------------------------------------------------------------



[State -1, AI RUN]
type = ChangeState
value = 100
triggerall = RoundState = 2
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = p2bodydist X > 420
trigger2 = power >= 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1,AI shurican 1]
type = ChangeState
value = 987
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < !500
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI shurican 2]
type = ChangeState
value = 770
triggerall = RoundState = 2
triggerall = stateno = 987
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < !500
trigger1 = statetype = S
trigger1 = ctrl

[State -1,  AI combo1]
type = ChangeState
value = 200
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl

[State -1,AI combo2]
type = ChangeState
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 200
value = 210

[State -1,  AI combo3]
type = ChangeState
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 210
value = 230

[State -1,  AI combo4]
type = ChangeState
value = 240
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl

[State -1,AI combo2]
type = ChangeState
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 240
value = 250

[State -1,  AI combo3]
type = ChangeState
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 20
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = stateno = 250
value = 260

[State -1, AI CROUCH SPECIAL (S)ENTER]
type = ChangeState
VALUE = 93832
triggerall = RoundState = 2
TRIGGERALL = POWER >= 700
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = c
trigger1 = ctrl

[State -1, AI CROUCH SPECIAL 1]
type = ChangeState
VALUE = 6666
triggerall = RoundState = 2
TRIGGERALL = POWER >= 1500
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = C
trigger1 = ctrl

[State -1, AI CROUCH SPECIAL 2]
type = ChangeState
value = 9977
triggerall = RoundState = 2
triggerall = power >= 1500
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = C
trigger1 = ctrl

[State -1, AI CROUCH SPECIAL 3]
type = ChangeState
VALUE = 6036
triggerall = RoundState = 2
TRIGGERALL = POWER >= 500
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = C
trigger1 = ctrl

[State -1, AI CROUCH SPECIAL 4]
type = ChangeState
value = 311
triggerall = RoundState = 2
triggerall = power >= 2000
triggerall = Var(50) = 1
trigger1 = random <= 20
triggerall = p2life > 0
trigger1 = statetype = C
trigger1 = ctrl

[State -1,AI CROUCH SPECIAL 5]
type = ChangeState
value = 72
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = C
trigger1 = ctrl

[State -1, AI CROUCH SPECIAL 6]
type = ChangeState
value = 83
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2bodydist X < 5
triggerall = p2life > 0
trigger1 = statetype = C
trigger1 = ctrl

[State -1,AI AIR ATTACK 1]
type = ChangeState
Value = 666
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = A
trigger1 = ctrl

[State -1,AI AIR ATTACK 2]
type = ChangeState
Value = 666
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = A
trigger1 = ctrl

[State -1,AI AIR ATTACK 3]
type = ChangeState
Value = 666
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = A
trigger1 = ctrl

[State -1,AI AIR ATTACK 4]
type = ChangeState
Value = 666
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = A
trigger1 = ctrl

[State -1, AI KAWIMI]
type = ChangeState
value = 505
triggerall = RoundState = 2
trigger1 = movetype = H
triggerall = backedgebodydist <= 1 && backedgebodydist > -1
Triggerall = Power >= 200
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = ctrl

[State -1, AI BUNCHIN]
type = ChangeState
value = 8999
triggerall = RoundState = 2
triggerall = numhelper(20000) < 6
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI Teleport]
type = ChangeState
value = 2022
triggerall = RoundState = 2
triggerall = Var(50) = 1
triggerall = random >= 250 && random < 299 || random >= 550 && random <= 999
triggerall = p2life > 0
triggerall = p2bodydist X < 100
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 1]
type = ChangeState
value = 84567
triggerall = RoundState = 2
triggerall = power >= 500
triggerall = numhelper(84568) < 1
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 2]
type = ChangeState
value = 45674
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 3]
type = ChangeState
value = 5676
triggerall = RoundState = 2
triggerall = (var(4) = 0)
triggerall = (var(5) = 0)
Triggerall = numexplod(769) <1
triggerall = power >= 500
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 4]
type = ChangeState
value = 54674
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall= p2dist x>=0 && random<50
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 5]
type = ChangeState
value = 842
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 6]
type = ChangeState
value = 1656
triggerall = RoundState = 2
triggerall = power >= 200
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 7]
type = ChangeState
value = 62333
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 8]
type = ChangeState
value = 76272
triggerall = RoundState = 2
triggerall = power >= 500
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 9]
type = ChangeState
value = 76
triggerall = RoundState = 2
triggerall = power >= 800
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 10]
type = ChangeState
value = 80
triggerall = RoundState = 2
triggerall = power >= 500
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 11]
type = ChangeState
value = 78
triggerall = RoundState = 2
triggerall = power >= 700
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 12]
type = ChangeState
value = 74
triggerall = RoundState = 2
triggerall = power >= 500
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

[State -1, AI SPECIAL 13]
type = ChangeState
value = 70
triggerall = RoundState = 2
triggerall = power >= 500
triggerall = Var(50) = 1
triggerall = random >= 150 && random < 199 || random >= 250 && random <= 399
triggerall = p2life > 0
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[STATE ,-1
;---------------------------------------------------------------------------


[State -1,Five water defence]
type = ChangeState
value = 84567
triggerall = power >= 500
triggerall = numhelper(84568) < 1
triggerall = command = "Five water defence"
trigger1 = (statetype = s) && ctrl


[State -1,REMOVE WATER DEFENSE]
type = ChangeState
value = 45674
triggerall = command = "111"
trigger1 = (statetype = s) && ctrl

[State -1,11]
type = ChangeState
value = 5676
triggerall = (var(4) = 0)
triggerall = (var(5) = 0)
Triggerall = numexplod(769) <1
triggerall = power >= 500
triggerall = command = "11"
trigger1 = (statetype = s) && ctrl

;h
[State -1,10]
type = ChangeState
value = 54674
triggerall = power >= 1000
triggerall = command = "10"
trigger1 = (statetype = s) && ctrl

;h
[State -1,9]
type = ChangeState
value = 842
triggerall = power >= 1000
triggerall = command = "9"
trigger1 = (statetype = s) && ctrl

;h
[State -1,8]
type = ChangeState
value = 1656
triggerall = power >= 200
triggerall = command = "8"
trigger1 = (statetype = s) && ctrl

;h
[State -1,7]
type = ChangeState
value = 62333
triggerall = power >= 1000
triggerall = command = "7"
trigger1 = (statetype = s) && ctrl

;h
[State -1,6]
type = ChangeState
value = 76272
triggerall = power >= 500
triggerall = command = "6"
trigger1 = (statetype = s) && ctrl


;h
[State -1,5]
type = ChangeState
value = 76
triggerall = power >= 800
triggerall = command = "5"
trigger1 = (statetype = s) && ctrl


;d
[State -1,4]
type = ChangeState
value = 80
triggerall = power >= 500
triggerall = command = "4"
trigger1 = (statetype = s) && ctrl


;w
[State -1, 3]
type = ChangeState
value = 78
triggerall = power >= 700
triggerall = command = "3"
trigger1 = (statetype = s) && ctrl


;sig
[State -1,2]
type = ChangeState
value = 74
triggerall = power >= 500
triggerall = command = "2"
trigger1 = (statetype = s) && ctrl


;blah
[State -1,1]
type = ChangeState
value = 70
triggerall = power >= 500
triggerall = command = "1"
trigger1 = (statetype = s) && ctrl


;===========================================================================
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
[State -1, HOP BACK Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;-------------------------------------------------------------------------

;Wall Run
[state -1, WallRun]
type = changestate
value = 101
triggerall = stateno = 20 || stateno = 100
triggerall = command = "hold_s" && command = "holdback"
trigger1 = backedgedist < 5
trigger1 = command = "holdback"
trigger2 = frontedgedist < 5
trigger2 = command = "holdfwd"


;-----------------------
;-----------------------
;Wall Jump
[state -1, WAll Jump ]
type = changestate
value = 45
triggerall = stateno = 104
triggerall = (ctrl) && (command = "holdup")
trigger1 = pos y <= -170
trigger1 = time > 20
trigger2 = pos y > -170

;---------------------------------------------------------------------------
[State -1,AIR1 SPIKE]
Type = ChangeState
Triggerall = Command = "a"
Trigger1 = ctrl = 1
Trigger1 = StateType = A
Value = 666

[State -1,AIR2 SPIKE]
Type = ChangeState
Triggerall = Command = "start"
Trigger1 = ctrl = 1
Trigger1 = StateType = A
Value = 666

[State -1,AIR3 SPIKE]
Type = ChangeState
Triggerall = Command = "b"
Trigger1 = ctrl = 1
Trigger1 = StateType = A
Value = 666

[State -1,AIR4 SPIKE]
Type = ChangeState
Triggerall = Command = "x"
Trigger1 = ctrl = 1
Trigger1 = StateType = A
Value = 666


[State -1,AIR5 SPIKE]
Type = ChangeState
Triggerall = Command = "z"
Trigger1 = ctrl = 1
Trigger1 = StateType = A
Value = 666

[State -1,AIR6 SPIKE]
Type = ChangeState
Triggerall = Command = "c"
Trigger1 = ctrl = 1
Trigger1 = StateType = A
Value = 666

[State -1,AIR7 SPIKE]
Type = ChangeState
Triggerall = Command = "y"
Trigger1 = ctrl = 1
Trigger1 = StateType = A
Value = 666
;---------------------------------------------------------------------------
;
[State -1,1c1 a1]
Type = ChangeState
Triggerall = Command = "a"
Triggerall = Command != "holddown"
Trigger1 = ctrl = 1
Trigger1 = StateType = S
Value = 200

;---------------------------------------------------------------------------
;
[State -1,2c1 a2]
type = ChangeState
value = 210
triggerall = stateno = 200
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 10
;---------------------------------------------------------------------------
;
[State -1,3c1 a3]
type = ChangeState
value = 230
triggerall = stateno = 210
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 10


;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;
[State -1,4c2 a1]
Type = ChangeState
Triggerall = Command = "x"
Triggerall = Command != "holddown"
Trigger1 = ctrl = 1
Trigger1 = StateType = S
Value = 240

;---------------------------------------------------------------------------
;
[State -1,5c2 a2]
type = ChangeState
value = 250
triggerall = stateno = 240
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 10

;---------------------------------------------------------------------------
;
[State -1,6c2 a3]
type = ChangeState
value = 260
triggerall = stateno = 250
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 10

;---------------------------------------------------------------------------
[state -1, chacra]
type = changestate
value = 195
Triggerall = command = "hold_a"
Triggerall = command = "hold_b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;water
[state -1, water bunchin]
type = ChangeState
value = 8999
triggerall = numhelper(20000) < 6
triggerall = power >= 1000
triggerall = command = "c"
trigger1 = statetype = S
trigger1 = ctrl



;Kawarimi
[State -1, Kawarimi]
type = ChangeState
value = 505
TRIGGERALL = POWER >= 500
triggerall = command = "a"
trigger1 = movetype = H ;&& (statetype = S)


;Kawarimi
[State -1, Kawarimi]
type = ChangeState
value = 505
TRIGGERALL = POWER >= 500
triggerall = command = "b"
trigger1 = movetype = H ;&& (statetype = S)


;Dragon
[State -1, DRAGON]
type = ChangeState
value = 450
triggerall = power >= 1000
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1

[State -1, Guard]
type = ChangeState
value = 120
triggerall = MoveType != H
triggerall = statetype = S
triggerall = ctrl
triggerall = Alive
triggerall = PrevStateNo != 900
trigger1 = command = "hold_s"


;chacra charge
[state -1, teleport 2]
type = changestate
value = 2022
triggerall = command = "z"
triggerall = command !="holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;
[State -1,shiruken 1]
Type = ChangeState
Triggerall = Command = "y"
Triggerall = Command != "holddown"
Trigger1 = ctrl = 1
Trigger1 = StateType = s
Value = 987
;---------------------------------------------------------------------------
;
[State -1,shiruken 2]
type = ChangeState
value = 770
triggerall = stateno = 987
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = time >= 10

;---------------------------------------------------------------------------
[STATE -1, SUNAME]
TYPE = CHANGESTATE
VALUE = 6666
TRIGGERALL = POWER >= 1500
TRIGGERALL = COMMAND = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
[STATE -1, water swirl upwards]
TYPE = CHANGESTATE
VALUE = 93832
TRIGGERALL = POWER >= 700
TRIGGERALL = COMMAND = "start"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1

;-----------------------------------------------------------------
;Hide in mist
[state -1, big dragon waterr]
type = ChangeState
value = 9977
triggerall = power >= 1500
triggerall = command = "down_a"
trigger1 = statetype = C
trigger1 = ctrl

;-------------------------------------------------------------------
[STATE -1,clone summon jail time]
TYPE = CHANGESTATE
VALUE = 6036
TRIGGERALL = POWER >= 500
TRIGGERALL = COMMAND = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;-----------------------------------------------------------------
;shark
[state -1, shark]
type = ChangeState
value = 311
triggerall = power >= 2000
triggerall = command = "down_b"
trigger1 = statetype = C
trigger1 = ctrl

;------------------------------------------------------------------
[state -1, water crush coffine]
type = changestate
value = 72
triggerall = power >= 1000
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;------------------------------------------------------------------
[state -1,giant shark up]
type = changestate
value = 83
triggerall = power >= 1000
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;------------------------------------------------------------------
;------------------------------------------------------------------

