; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below.
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;
;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

[Command]
name = "amaterasu"
command = D,F,/a
time = 15

[Command]
name = "amaterasu2"
command = D,B,/a
time = 15

[Command]
name = "amaterasu3"
command = D,F,/b
time = 15

[Command]
name = "kiri"
command = D,F,/c
time = 15


[Command]
name = "hijinheki"
command = D,B,/b
time = 15


[Command]
name = "ryuuendan"
command = D,B,/c
time = 15


[Command]
name = "hijin"
command = D,B,/x
time = 15


[Command]
name = "sharingan"
command = a+b
time = 1

[Command]
name = "jikunkan"
command = a+x
time = 1


[Command]
name = "iw"
command = b+y
time = 1

--------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]
[State -1,Sharingan]
Type = ChangeState
Value = 18000
triggerall = Var(6) = 0
Triggerall = Command = "sharingan"
triggerall = power >= 1000
Trigger1 = StateType != A
Trigger1 = ctrl
;--------------------------------------------------------------------------
[State -1,SharinganOFF]
Type = ChangeState
Value = 18020
triggerall = Var(6) !=0
Triggerall = Command = "sharingan"
Trigger1 = StateType != A
Trigger1 = ctrl


[state -1]
type=changestate
value=8200
trigger1 = var(33) =0
trigger1 = command = "amaterasu"
triggerall = Statetype !=A
triggerall = ctrl = 1
triggerall = power >= 1000
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

;---------------------------------------------------------------------------

[State -1,Sharingan]
Type = ChangeState
Value = 55000
triggerall = Var(6) = 0
Triggerall = Command = "iw"
triggerall = power >= 4000
Trigger1 = StateType != A
Trigger1 = ctrl
;---------------------------------------------------------------------------

[State -1,Sharingan]
Type = ChangeState
Value = 30000
triggerall = Var(6) = 0
Triggerall = Command = "jikunkan"
triggerall = power >= 1000
Trigger1 = StateType != A
Trigger1 = ctrl
-------------------------------------------------------------------------------------
[state -1]
type=changestate
value=8300
trigger1 = var(33) =0
trigger1 = command = "amaterasu2"
triggerall = Statetype !=A
triggerall = power >= 1000
triggerall = ctrl = 1
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)


------------------------------------------------------------------------------------
[state -1]
type=changestate
value=9700
trigger1 = var(33) =0
trigger1 = command = "kiri"
triggerall = power >= 1000
triggerall = Statetype !=A
triggerall = ctrl = 1
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)
-----------------------------------------------------------------------------------


[state -1]
type=changestate
value=9100
trigger1 = var(33) =0
trigger1 = command = "hijinheki"
triggerall = power >= 1000
triggerall = Statetype !=A
triggerall = ctrl = 1
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)
------------------------------------------------------------------------------------
[state -1]
type=changestate
value=8400
trigger1 = var(33) =0
trigger1 = command = "amaterasu3"
triggerall = Statetype !=A
triggerall = power >= 1000
triggerall = ctrl = 1
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)
-------------------------------------------------------------------------------------
[state -1]
type=changestate
value=9200
trigger1 = var(33) =0
triggerall = command != "holddown"
trigger1 = command = "ryuuendan"
triggerall = power >= 1000
triggerall = Statetype !=A
triggerall = ctrl = 1
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

-----------------------------------------------------------------------------------
[state -1]
type=changestate
value=9300
trigger1 = var(33) =0
trigger1 = command = "hijin"
triggerall = power >= 1000
triggerall = Statetype !=A
triggerall = ctrl = 1
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)
------------------------------------------------------------------------------------
------------------------------------------------------------------------------------
[state -1]
type=changestate
value=300
trigger1 = var(33) =0
trigger1 = command !="holddown"
trigger1 = command = "a"
triggerall = power >= 1000
triggerall = ctrl = 1
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

------------------------------------------------------------------------------------
[state -1]
type=changestate
value=8000
trigger1 = command ="holddown"
trigger1 = command = "a"
trigger1 = var(33) =0
triggerall = power >= 1000
triggerall = ctrl = 1
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

------------------------------------------------------------------------------------
[state -1]
type=changestate
value=310
trigger1 = command = "a"
trigger1 = var(33) =0
trigger1 = command !="holddown"
triggerall = power >= 1000
triggerall = (stateno=300) && (movecontact>1)
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

------------------------------------------------------------------------------------
[state -1]
type=changestate
value=320
trigger1 = command = "a"
trigger1 = var(33) =0
trigger1 = command !="holddown"
triggerall = power >= 1000
triggerall = (stateno=310) && (movecontact>1)
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

------------------------------------------------------------------------------------
[state -1]
type=changestate
value=8100
trigger1 = var(33) =0
trigger1 = command ="holddown"
trigger1 = command = "b"
triggerall = power >= 1000
triggerall = Statetype !=A
triggerall = ctrl = 1
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)


------------------------------------------------------------------------------------
[state -1]
type=changestate
value=8500
trigger1 = var(33) =0
trigger1 = command ="holddown"
trigger1 = command = "c"
triggerall = power >= 1000
triggerall = Statetype !=A
triggerall = ctrl = 1
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)


;===========================================================================

;---------------------------------------------------------------------------
[state -1]
type=changestate
value=500
trigger1 = command = "c"
trigger1 = var(33) =0
trigger1 = command !="holddown"
triggerall = power >= 1000
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

--------------------------------------------------------------------------------------
[state -1]
type=changestate
value=7200
trigger1 = command = "a"
trigger1 = var(33) =0
triggerall = ctrl = 1
triggerall = Statetype =A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)
======================================================================================
[state -1]
type=changestate
value=400
trigger1 = command !="holddown"
trigger1 = var(33) =0
trigger1 = command = "b"
triggerall = ctrl = 1
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

------------------------------------------------------------------------------------
[state -1]
type=changestate
value=410
trigger1 = command !="holddown"
trigger1 = command = "b"
trigger1 = var(33) =0
triggerall = (stateno=400) && (movecontact>1)
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

------------------------------------------------------------------------------------
[state -1]
type=changestate
value=420
trigger1 = command !="holddown"
trigger1 = command = "b"
trigger1 = var(33) =0
triggerall = (stateno=410) && (movecontact>1)
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)


------------------------------------------------------------------------------------
[state -1]
type=changestate
value=430
trigger1 = command !="holddown"
trigger1 = command = "b"
trigger1 = var(33) =0
triggerall = (stateno=420) && (movecontact>1)
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

-----------------------------------------------------------------------------------
;---------------------------------------------------------------------------
 ;Teleport
[State -1, Teleport]
type = ChangeState
value = 7000
triggerall = command != "holddown"
triggerall = command = "x"
trigger1 = statetype = S
trigger1 = ctrl
------------------------------------------------------------------------------------
;---------------------------------------------------------------------------
 ;Teleport
[State -1, Teleport]
type = ChangeState
value = 7100
triggerall = command != "holddown"
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
 ;Teleport
[State -1, Teleport]
type = ChangeState
value = 3700
triggerall = command = "holddown"
triggerall = command = "x"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
 ;Teleport
[State -1, Teleport]
type = ChangeState
value = 1000
triggerall = command != "holddown"
triggerall = command = "y"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
[state -1]
type=changestate
value=8810
trigger1 = command = "z"
trigger1 = var(33) =0
trigger1 = command ="holddown"
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)
;---------------------------------------------------------------------------
 ;Teleport
[State -1, Teleport]
type = ChangeState
value = 1100
triggerall = command != "holddown"
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
; Standing Medium Kick
[State -1, Standing Medium Kick]
type = ChangeState
value = 9600
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
--------------------------------------------------------------------
;housenka
[State -1, Housenka]
type = ChangeState
value = 4200
trigger1 = power >= 500
trigger1 = var(10) = 0
trigger1 = var(15) = 0
trigger1 = statetype = C
trigger1 = command = "y"
trigger1 = ctrl
triggerall = command = "holddown"
---------------------------------------------------------------------------------------

;---------------------------------------------------------------------------
; Invisible
[State -1, Invisible]
type = ChangeState
value = 3400
triggerall = Var(0)=0
triggerall = command = "s"
triggerall = statetype = S
triggerall = power >= 10
trigger1 = command !="holddown"
trigger1 = ctrl
trigger2 = stateno = 5000 || stateno = 5001 || stateno = 5002
;---------------------------------------------------------------------------

[state -1]
type=changestate
value=195
trigger1 = command ="holddown"
trigger1 = command = "s"
trigger1 = var(33) =0
triggerall = power < 9000
triggerall = ctrl = 1
triggerall = Statetype !=A
trigger2 = var(33)  > 0
trigger2 = random < 100 *(var(33) **2 /64.0)

---------------------------------------------------------------------------------
;kawarimi
[State -1, Kawarimi]
type = ChangeState
value = 530
triggerall = command = "a"
triggerall = power >= 350
triggerall = statetype = S
trigger1 = stateno = [5000,5110]




;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl
