-- heap definitions are defined as: <NAME>, <PARENT_HEAP>, <SIZE(MB)>, <AUTOSMALL>, <OVERFLOW_HEAP>

function AddHeap( name, parentHeap, sizeMB, autoSmall, overflowHeapName )
	local data =
	{
		HeapType = "Single",
		Data =
		{
			Name = name,
			ParentHeap = parentHeap,
			SizeMB = sizeMB,
			AutoSmall = autoSmall,
			OverflowHeapName = overflowHeapName,
		},
	}

	return data
end

function AddHeapArray( name, childNameRoot, parentHeap, sizeMB, count, autoSmall, overflowHeapName )
	local data =
	{
		HeapType = "Array",
		Data =
		{
			Name = name,
			ChildNameRoot = childNameRoot,
			ParentHeap = parentHeap,
			SizeMB = sizeMB,
			Count = count,
			ParentBuffer = 0.1,
			AutoSmall = autoSmall,
			OverflowHeapName = overflowHeapName,
		},
	}

	return data
end


Heaps =
{
	default =
	{
		{
			LevelName = "Global",
			Heaps = {},
		},
		{
			LevelName = "Default",
			Heaps = {},
		},
	},
	xb360 =
	{
		{
			LevelName = "Global",
			Heaps = {},
		},
		{
			LevelName = "Default",
			Heaps = {},
		},
	},
	ps3 =
	{
		{
			LevelName = "Global",
			Heaps = {},
		},
		{
			LevelName = "Default",
			Heaps = {},
		},
	},
	wii =
	{
		{
			LevelName = "Global",
			Heaps = {},
		},
		{
			LevelName = "Default",
			Heaps = {},
		},
	},
}