#ifndef __SCREENS_MINI_HAMSTER_DEFINES_H__
#define __SCREENS_MINI_HAMSTER_DEFINES_H__
/************************************************************************/
/* Strings for use in the Mini Hamster menus										*/
/************************************************************************/

#define MH_TAG_TITLE			"Tag"
#define MH_TAG_RULE_1		"- Who ever is \"IT\" at the end loses!"
#define MH_REVERSE_TITLE	"Reverse Tag"
#define MH_REVERSE_RULE_1	"- Who ever is \"IT\" at the end wins!"
#define MH_BLOB_TITLE		"Blob Tag"
#define MH_BLOB_RULE_1		"- Tagged players join the \"IT\" team."
#define MH_BLOB_RULE_2		"- Anyone who survives the whole time wins."  
#define MH_BLOB_RULE_3		"- If everyone is blobbed, the last one looses."
#define MH_FREEZE_TITLE		"Freeze Tag"
#define MH_FREEZE_RULE_1	"- The Freezer is \"IT\", everyone else is a runner."
#define MH_FREEZE_RULE_2	"- Anyone the Freezer tags will become frozen."
#define MH_FREEZE_RULE_3	"- Runners can release Runners by tagging them."
#define MH_FREEZE_RULE_4	"- If everyone is frozen the Freezer wins!"
#define MH_FREEZE_RULE_5	"- If anyone survives the whole time, the Runners win!"
#define MH_CRAZY_TITLE		"Crazy Tag"
#define MH_CRAZY_RULE_1		"- Who ever is \"IT\" for 100 seconds wins!"

#define MH_PLAYER_X_WINS	"Player %d Wins!"
#define MH_PLAYER_X_LOST	"Player %d Lost!"

#define MH_CANCEL				"Cancel"
#define MH_SELECT				"Select"
#define MH_QUIT				"Quit"
#define MH_MAIN				"Menu"
#define MH_START				"Play"

#define MH_SCHOOLYARD		"School Yard"
#define MH_CYROGENIC			"Cyrogenics"
#define MH_GARDEN				"Garden"
#define MH_GYM					"Gymnasium"

#define MH_YES					"Yes"
#define MH_NO					"No"

enum TagMode
{
	MODE_TAG,
	MODE_BLOB,
	MODE_REVERSE,
	MODE_FREEZE,
	MODE_CRAZY,
	NUM_MODES
};

enum PlayerHudStatus
{
	PHS_INVALID = -1,
	PHS_FREE,
	PHS_BLOBBED,
	PHS_FROZEN,
	PHS_FREEZER,
	PHS_IT_GOOD,
	PHS_IT_BAD,
	NUM_PLAYER_HUD_STATUSES
};
#endif // __SCREENS_MINI_HAMSTER_DEFINES_H__

