--********************************************************************************************************************
function public.Init()

  private.current = nil;
  private.pos_beg = nil;
  private.pos_end = nil;
  private.event_anim_end = {};
  private.SUBROOM = "subroom";
  ObjAttach( private.SUBROOM, "ng_level_internal" );

  ModLoad( "assets/levels/common/mod_subroom_impl" );
  subroom_impl.Init();

end;
--********************************************************************************************************************
function public.Destroy()

end;
--********************************************************************************************************************
function public.Define( subroom )
  _G[ subroom ] = {};
end;
--********************************************************************************************************************
function public.EventAnimEnd( event_id )

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    ObjSet( private.current, { input = true } );
    private.Execute( private.current, "Open" );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

    private.Execute( private.current, "Close" );
    ObjDetach( private.current );
    ObjDetach( subroom_impl.BLACK );
    ObjSet( private.SUBROOM, { input = false, visible = false, active = false } );
    private.current = nil;
    private.pos_beg = nil;
    private.pos_end = nil;
    room.SetCurrentRoomActive( true );
    room.SetCurrentRoomInput( true );

  end;

end;
--********************************************************************************************************************
function public.Open( subroom_name, pos_beg, pos_end )
  
  if not private.current then

    room.SetCurrentRoomActive( false );
    room.SetCurrentRoomInput( false );
    ObjSet( private.SUBROOM, { input = true, visible = true, active = true } );
    private.current = subroom_name;
    private.pos_beg = pos_beg; --DbgTrace((pos_beg.x).." "..(pos_beg.y));
    private.pos_end = pos_end; --DbgTrace((pos_end.x).." "..(pos_end.y));
    ObjAttach( subroom_impl.BLACK, private.SUBROOM );
    ObjSet( subroom_name, { pos_z = 1, input = false } );
    ObjAttach( subroom_name, private.SUBROOM );
    subroom_impl.Show( "show", subroom_name, pos_beg, pos_end );  
    local back_params = ObjGet( subroom_name );
    interface.ConstructFrameSubroom( back_params.draw_width, back_params.draw_height );
    private.Execute( private.current, "PreOpen" );

  end;

end;
--********************************************************************************************************************
function public.Close()

  if private.current then

    ObjSet( private.current, { input = false } );
    private.Execute( private.current, "PreClose" );
    subroom_impl.Hide( "hide", private.current, private.pos_beg, private.pos_end );    

  end;

end;
--********************************************************************************************************************
function private.Execute( room, func )

  if room and func and _G[ room ] and _G[ room ][ func ] then
    _G[ room ][ func ]();
  end;

end;
--********************************************************************************************************************
