--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "tutorial" );
  ObjAttach( "int_tutorial", interface.originhub );
  ObjSet( "int_tutorial", { pos_z = pos_z } );
  private.event_anim_end = {};
  private.showing = false;
  private.closing = false;
  private.shown   = false;
  private.closed  = true;
  private.input   = false;

  ObjAttach( "tmr_int_tutorial", InterfaceWidget_Top_Name );

end;
--******************************************************************************************
function public.Destroy()

end;
--******************************************************************************************
function public.IsActive()
  return not private.closed;
end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    private.showing = false;
    private.shown = true;

    ObjSet( "int_tutorial_impl", { input = true } );

    if not private.input then

      ObjSet( "obj_int_tutorial_input", { input = false } );
      ObjSet( "obj_int_tutorial_transpanent", { input = true } );

    end;

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

    private.closing = false;
    private.closed = true;

    ObjSet( "int_tutorial", { active = false, visible = false, input = false } );

    private.input = false;

------------------------------------------------------------------------------------
  end;

end;
--******************************************************************************************
function public.ForceShowEnd ()

  if ( private.showing ) then

    private.showing = false;
    private.shown = true;

  end;

end;
--******************************************************************************************
function public.ForceHideEnd ()

  if ( private.closing ) then

    private.closing = false;
    private.closed = true;

  end;

end;
--******************************************************************************************
function public.Show( tutorial_text, tutorial_input, tutorial_pos, tutorial_arrows )

  if not private.closed then return; end;

  private.showing = true;
  private.closed = false;
  private.input = tutorial_input;
  private.arrows_amount = nil;

  if ( tutorial_arrows ) then

    private.arrows_amount = #tutorial_arrows;

    for arrow_id = 1, #tutorial_arrows, 1 do

       int_tutorial_impl.ArrowShow( arrow_id, tutorial_arrows[ arrow_id ] );

    end;

  end;

  ObjSet( "txt_int_tutorial", { text = tutorial_text } );

  local text_params = ObjGet( "txt_int_tutorial" );

  local out_params = interface.GetParamsForGrid( "int_tutorial_impl", text_params.draw_width, text_params.draw_height );
  
  local tutorial_w = out_params.width;
  local tutorial_h = out_params.height;

  local grid_corner_w = int_tutorial_impl.GRID_CORNER_W;
  local grid_corner_h = int_tutorial_impl.GRID_CORNER_H;

  local grid_mid_w = int_tutorial_impl.GRID_MID_W;
  local grid_mid_h = int_tutorial_impl.GRID_MID_H;

  interface.FrameGridSet( "int_tutorial",
  {
    grid_w   = tutorial_w,
    grid_h   = tutorial_h,
    corner_w = grid_corner_w,
    corner_h = grid_corner_h,
    mid_w    = grid_mid_w,
    mid_h    = grid_mid_h
  } );

  local tutorial_full_w = tutorial_w;
  local tutorial_full_h = tutorial_h;

  ObjSet( "int_tutorial", { active = true, visible = true, input = true } );

  ObjSet( "int_tutorial_impl",
  {
    input          = false,
    inputrect_init = true,
    inputrect_x    = - ( 0.5 * tutorial_full_w ),
    inputrect_y    = - ( 0.5 * tutorial_full_h ),
    inputrect_w    = tutorial_full_w,
    inputrect_h    = tutorial_full_h,
    pos_x          = tutorial_pos.x,
    pos_y          = tutorial_pos.y,
    pos_z          = 1
  } );

  ObjSet( "obj_int_tutorial_input", { input = private.input } );
  ObjSet( "obj_int_tutorial_transpanent", { input = false } );

  local event_id = "show";
  private.event_anim_end[ event_id ] = {};
  int_tutorial_impl.ShowAnim( event_id );

end;
--******************************************************************************************
function public.Hide()

  if not private.shown then return; end;

  if ( private.arrows_amount ) then

    for arrow_id = 1, private.arrows_amount, 1 do

      int_tutorial_impl.ArrowHide( arrow_id );

    end;

  end;

  ObjSet( "int_tutorial_impl", { input = false } );
  ObjSet( "obj_int_tutorial_input", { input = true } );
  ObjSet( "obj_int_tutorial_transpanent", { input = false } );

  private.shown = false;
  private.closing = true;

  local event_id = "hide";
  private.event_anim_end[ event_id ] = {};
  int_tutorial_impl.HideAnim( event_id );

end;
--******************************************************************************************
function public.MouseDown( button_id )
  
  if not private.shown then return; end;
  MsgSend( Event_Tutorial_Click, { button_id = button_id } );

end;
--******************************************************************************************