--******************************************************************************************
function public.Init( pos_z )
  
  interface.LoadImplementation( "taskheader" );
  ObjAttach( "int_taskheader", interface.originhub );
  ObjSet( "int_taskheader", { pos_z = pos_z } );
  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  private.already_hide = nil;
  private.is_task = true;
  private.m_state = "hide";
  private.event_anim_end = {};

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    ObjSet( "int_taskheader", { input = true } );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

    if private.m_state == "hiding" then

      private.m_state = "hide";
      private.SwitchToTasks();
      interface.WidgetSetInput( InterfaceWidget_Inventory, true );

      ObjSet( "int_taskheader", { active = false, visible = false } );

    end;

------------------------------------------------------------------------------------
  end;

end;
--******************************************************************************************
function public.MouseDown( objname )

  if     ( objname == "inventory" ) then

    if private.m_state == "show" then

      private.SwitchToInventory();
      interface.WidgetSetInput( InterfaceWidget_Inventory, true );

      int_taskheader_impl.InventoryActivateAnim();

    end;

  elseif ( objname == "taskpanel" ) then

    if private.m_state == "show" then

      private.SwitchToTasks();
      interface.WidgetSetInput( InterfaceWidget_Inventory, false );

      int_taskheader_impl.TaskPanelActivateAnim();

    end;

  end;

end;
--******************************************************************************************
function public.Show()

  if private.m_state ~= "show" then

    private.SwitchToTasks();
    private.m_state = "show";
    interface.WidgetSetInput( InterfaceWidget_Inventory, false );

    ObjSet( "int_taskheader", { active = true, visible = true } );

    local event_id = "show";
    private.event_anim_end[ event_id ] = {};
    int_taskheader_impl.ShowAnim( event_id );

  end;

end;
--******************************************************************************************
function public.Hide()

  if private.m_state ~= "hiding" then

    private.SwitchToTasks();
    private.m_state = "hiding";
    interface.WidgetSetInput( InterfaceWidget_Inventory, false );

    ObjSet( "int_taskheader", { input = false } );

    local event_id = "hide";
    private.event_anim_end[ event_id ] = {};
    int_taskheader_impl.HideAnim( event_id );

  end;

end;
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "taskheader" );

end;
--******************************************************************************************
function private.SwitchToInventory()

  if private.is_task then
    private.is_task = false;
    MsgSend( Command_TaskPanel_DecreaseZ, {} );
    MsgSend( Command_Inventory_IncreaseZ, {} );
  end;

end;
--******************************************************************************************
function private.SwitchToTasks()

  if not private.is_task then
    private.is_task = true;
    MsgSend( Command_TaskPanel_IncreaseZ, {} );
    MsgSend( Command_Inventory_DecreaseZ, {} );
  end;

end;
--******************************************************************************************