--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "popup" );
  ObjAttach( "int_popup", interface.originhub );
  ObjSet( "int_popup", { pos_z = pos_z } );

  private.event_anim_end = {};
  private.SHOW_TIME = 0.35;
  private.ishide = true;

  ObjAttach( "tmr_int_popup_show", InterfaceWidget_Top_Name );

end;
--******************************************************************************************
function public.Destroy()


end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

------------------------------------------------------------------------------------
    elseif ( event_id == "hide" ) then

    ObjSet( "int_popup", { active = false, visible = false } );

  end;

end;
--******************************************************************************************
function public.Show( popup_text, popup_param0, popup_param1, popup_param2, popup_param3, popup_param4 )

  local trigger = function () 
    private.Show( popup_text, popup_param0, popup_param1, popup_param2, popup_param3, popup_param4 ); end;

  ObjSet( "tmr_int_popup_show",
  {
    endtrig = trigger,
    time    = private.SHOW_TIME,
    playing = true
  } );

end;
--******************************************************************************************
function public.Hide()

  ObjSet( "tmr_int_popup_show", { playing = false } );

  if ( not private.ishide ) then

    private.ishide = true;

    local event_id = "hide";
    private.event_anim_end[ event_id ] = {};
    int_popup_impl.HideAnim( event_id );

  end;

end;
--******************************************************************************************
function private.Show( popup_text, popup_param0, popup_param1, popup_param2, popup_param3, popup_param4 )
      
  private.ishide = false;

  ObjSet( "txt_int_popup",
  {
    text   = popup_text,
    param0 = popup_param0,
    param1 = popup_param1,
    param2 = popup_param2,
    param3 = popup_param3,
    param4 = popup_param4
  } );

  local pos_beg = GetGameCursorPos();

  ObjSet( "int_popup", { active = true, visible = true, pos_x = pos_beg[ 1 ], pos_y = pos_beg[ 2 ] } );

  local border_w = int_popup_impl.GRID_BORDER_W;
  local border_h = int_popup_impl.GRID_BORDER_H;

  local popup_w = ObjGet( "txt_int_popup" ).draw_width  + border_w;
  local popup_h = ObjGet( "txt_int_popup" ).draw_height + border_h;

  local pos_end = {};

  pos_end[ 1 ] = pos_beg[ 1 ];
  pos_end[ 2 ] = pos_beg[ 2 ];

  local pos_off_x = int_popup_impl.OFFSET_POS_X;
  local pos_off_y = int_popup_impl.OFFSET_POS_Y;

  local screen_off = 0.5 * ( GetAppWidth() - 1024 );

  local screen_min_x = 0    - screen_off;
  local screen_max_x = 1024 + screen_off;

--[[
  if ( GetWideScreen() ) then

  screen_min_x = screen_min_x - (  - 171;
  screen_max_x = screen_max_x + 171;

  end;
]]

  if ( pos_beg[ 1 ] < ( screen_min_x + ( 0.5 * popup_w ) ) ) then

    pos_end[ 1 ] = screen_min_x + ( 0.5 * popup_w ) + pos_off_x;

  end;

  if ( pos_beg[ 1 ] > ( screen_max_x - ( 0.5 * popup_w ) ) ) then
  
    pos_end[ 1 ] = screen_max_x - ( 0.5 * popup_w ) - pos_off_x;

  end;

  if ( pos_beg[ 2 ] < popup_h ) then

    if ( pos_beg[ 1 ] < ( screen_min_x + popup_w ) ) then

      local cursor_w = 32;

      pos_end[ 1 ] = pos_beg[ 1 ] + ( 0.5 * popup_w ) + ( pos_off_x + cursor_w );

    else

      pos_end[ 1 ] = pos_beg[ 1 ] - ( 0.5 * popup_w ) - pos_off_x;

    end;
      
    pos_end[ 2 ] = pos_beg[ 2 ] + ( 0.5 * popup_h ) + pos_off_y;

  else

    pos_end[ 2 ] = pos_beg[ 2 ] - ( 0.5 * popup_h ) - pos_off_y;

  end;

  local grid_corner_w = int_popup_impl.GRID_CORNER_W;
  local grid_corner_h = int_popup_impl.GRID_CORNER_H;

  local grid_mid_w = int_popup_impl.GRID_MID_W;
  local grid_mid_h = int_popup_impl.GRID_MID_H;

  interface.FrameGridSet( "int_popup",
  {
    grid_w   = popup_w,
    grid_h   = popup_h,
    corner_w = grid_corner_w,
    corner_h = grid_corner_h,
    mid_w    = grid_mid_w,
    mid_h    = grid_mid_h
  } );

  local event_id = "show";
  private.event_anim_end[ event_id ] = {};
  int_popup_impl.ShowAnim( pos_beg, pos_end, event_id );

end;
--******************************************************************************************