--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "map" );
  ObjAttach( "int_map", interface.originhub );
  ObjSet( "int_map", { pos_z = pos_z } );
  ObjDetach( "int_map_impl" );
  private.event_anim_end = {};
  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

  ObjSet( "int_map_impl", { input = true });
  ObjSet( "int_map_input", { input = false } );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

  ObjSet( "int_map", { active = false, visible = false, input = false } );
  ObjDetach( "int_map_impl" );
------------------------------------------------------------------------------------
  end;
  
end;
--******************************************************************************************
function public.Close()

  private.Hide();

end;
--******************************************************************************************
function public.Show()

  ObjAttach( "int_map_impl", "int_map" );
  ObjSet( "int_map", { active = true, visible = true, input = true } );
  ObjSet( "int_map_impl", { input = false });
  ObjSet( "int_map_input", { input = true } );

  local event_id = "show";
  private.event_anim_end[ event_id ] = {};
  int_map_impl.ShowAnim( event_id );

end;
--******************************************************************************************
function private.Hide()

  ObjSet( "int_map_impl", { input = false } );
  ObjSet( "int_map_input", { input = true } );

  local event_id = "hide";
  private.event_anim_end[ event_id ] = {};
  int_map_impl.HideAnim( event_id );

end;
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "map" );

end;
--******************************************************************************************