private.fly_itm_count_bag = 0; --костыль изза зависания предметов в воздухе
--******************************************************************************************
function public.Init( pos_z )

  local impl_module_name = nil;

  if ( _G[ "int_taskheader" ] ) then

    impl_module_name = "int_taskheader_inventory_impl";

  end;

  interface.LoadImplementation( "inventory", impl_module_name );

  private.is_autohide = true;
  private.is_objects_moving = false;
  private.is_inventory_opened = false;
  private.is_mouse_over_inventory = false;
  private.is_opened_for_taskheader = false;
  private.count_fly_animation_playing = 0;
  private.count_visible_objects = ConfigGetInventorySize();
  private.m_left_object_index = 0; -- left visible object index
  private.m_objects = {};
  private.m_objects_params = {};
  private.m_dragging_object = nil;

  private.item_positions = {};

  ObjAttach( "int_inventory", interface.originhub );
  ObjSet( "int_inventory", { pos_z = pos_z } );
  private.event_anim_end = {};
  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  MsgSubscribe( Command_Inventory_DecreaseZ, private.DecreaseZ );
  MsgSubscribe( Command_Inventory_IncreaseZ, private.IncreaseZ );

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  MsgUnsubscribe( Command_Inventory_DecreaseZ, private.DecreaseZ );
  MsgUnsubscribe( Command_Inventory_IncreaseZ, private.IncreaseZ );

end;
--******************************************************************************************
function public.Show( mouse_over )

  private.is_mouse_over_inventory = mouse_over or false;

  if not private.is_inventory_opened and 
  ( private.count_fly_animation_playing > 0 or 
    not private.is_autohide or mouse_over ) then

    private.is_inventory_opened = true;

    local event_id = "show";
    private.event_anim_end[ event_id ] = {};
    int_inventory_impl.ShowAnim( event_id );

  end;

end;
--******************************************************************************************
function public.Hide( mouse_over )

  if mouse_over ~= nil then
    private.is_mouse_over_inventory = mouse_over;
  end;

  ObjSet( "tmr_int_inventory_items_move",
  {
    endtrig = private.StartHide,
    time    = 0.1,
    playing = true
  } );

end;
--******************************************************************************************
function public.ArrowClick( arrow )

  if not private.is_objects_moving then

    if ( arrow == "left" and private.m_left_object_index > 0 ) then

      private.m_left_object_index = private.m_left_object_index  - 1;
      private.MoveObjects();

    elseif ( arrow == "right" and private.m_left_object_index + private.count_visible_objects < #private.m_objects ) then

      private.m_left_object_index = private.m_left_object_index + 1;
      private.MoveObjects();

    end;

  end;

end;
--******************************************************************************************
function public.StdItemFlyAnimation( anim_obj_name, target_obj_name, trigger_end, first_item )

  private.fly_itm_count_bag = private.fly_itm_count_bag + 1;
  --DbgTrace("AAAAAAAAAAAA "..private.fly_itm_count_bag );
  --костыль изза зависания предметов в воздухе
  ObjSet( "obj_int_inventory", { input = false } );

  first_item = first_item or 0;

  MsgSend( Command_Transporter_MoveObject,
  {
  type       = Trans_SceneToInventory,
  obj_name   = anim_obj_name,
  toobj_name = target_obj_name,
  show       = first_item,
  end_trig   = trigger_end
  } );

end;
--******************************************************************************************
function public.StdItemDragAnimation( anim_obj_name, target_obj_name, trigger_end )

  MsgSend( Command_Transporter_MoveObject,
  {
  type       = Trans_InventoryToCursor,
  obj_name   = anim_obj_name,
  toobj_name = target_obj_name,
  end_trig   = trigger_end
  } );

end;
--******************************************************************************************
function public.StdItemDropAnimation( anim_obj_name, target_obj_name, trigger_end, scale_end )

  private.fly_itm_count_bag = 1;
  --DbgTrace("BBBBBBBBBBBBBB "..private.fly_itm_count_bag);
  --костыль изза зависания предметов в воздухе
  ObjSet( "obj_int_inventory", { input = false } );

  MsgSend( Command_Transporter_MoveObject,
  {
  type       = Trans_CursorToInventory,
  obj_name   = anim_obj_name,
  toobj_name = target_obj_name,
  scale      = scale_end,
  end_trig   = trigger_end
  } );

end;
--******************************************************************************************
function public.Switch()

  if ( _G[ "int_taskheader" ] ) then

    int_taskheader.MouseDown( "inventory" );

  end;

end;
--******************************************************************************************
function public.SetAutohide( autohide, force )

  private.is_autohide = autohide;

  if ( not private.is_autohide and force ) then
    private.is_inventory_opened = true;
    int_inventory_impl.ForceShow();
  end;

end;
--******************************************************************************************
function public.GetAutohide()

  return private.is_autohide;

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

  --

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

  --

------------------------------------------------------------------------------------
  elseif ( event_id == "taskheader_show" ) then

  --

------------------------------------------------------------------------------------
  elseif ( event_id == "taskheader_hide" ) then

  private.is_opened_for_taskheader = false;
  private.is_inventory_opened = false;

------------------------------------------------------------------------------------
  elseif ( string.find( event_id, "item_fly" ) ) then

  private.fly_itm_count_bag = private.fly_itm_count_bag - 1;
  --DbgTrace("CCCCCCCCCCCC "..private.fly_itm_count_bag);
  --костыль изза зависания предметов в воздухе
  if ( private.fly_itm_count_bag == 0 ) then
    ObjSet( "obj_int_inventory", { input = true } );
  end;

  local item_name      = event_params[ "name" ];
  local item_game_name = event_params[ "game_name" ];
  local item_count     = event_params[ "count" ];

  ObjDelete( item_game_name );
  private.ExecuteAddEndFunc( item_name );

  private.count_fly_animation_playing = private.count_fly_animation_playing - 1;

  local fly_def_name = interface.GetObjectName( item_name ).."_"..item_count;
  local fly_obj_name = "fly_int_inventory_"..fly_def_name;

  ObjDelete( fly_obj_name );

  public.Hide();

------------------------------------------------------------------------------------
  elseif ( string.find( event_id, "item_move" ) ) then

    private.is_objects_moving = false;
    --local item_name = event_params[ "name" ];
    --local item_pos  = event_params[ "pos"  ];

    --private.item_positions[ item_name ] = item_pos;

------------------------------------------------------------------------------------
  elseif ( string.find( event_id, "item_drag" ) ) then

  local item_name      = event_params[ "name" ];

  private.m_dragging_object = item_name;
  ObjSet( private.m_dragging_object, { input = true } );

------------------------------------------------------------------------------------
  elseif ( string.find( event_id, "item_drop" ) ) then

  private.fly_itm_count_bag = private.fly_itm_count_bag - 1;
  --DbgTrace("DDDDDDDDDDDD "..private.fly_itm_count_bag);
  --костыль изза зависания предметов в воздухе
  if ( private.fly_itm_count_bag == 0 ) then
    ObjSet( "obj_int_inventory", { input = true } );
  end;

  local item_name = event_params[ "name" ];

  ObjSet( item_name, { input = true } );
  private.count_fly_animation_playing = private.count_fly_animation_playing - 1;

  public.Hide( false );

------------------------------------------------------------------------------------
  elseif ( event_id == "item_menter" ) then

  --

------------------------------------------------------------------------------------
  elseif ( event_id == "item_mleave" ) then

  --

------------------------------------------------------------------------------------
  end;

end;
--******************************************************************************************
function public.ShowForTaskHeader()

  local event_id = "taskheader_show";
  private.event_anim_end[ event_id ] = {};
  int_inventory_impl.TaskHeaderShowAnim( event_id );
  private.is_opened_for_taskheader = true;
  private.is_inventory_opened = true;

end;
--******************************************************************************************
function public.HideForTaskHeader()

  local event_id = "taskheader_hide";
  private.event_anim_end[ event_id ] = {};
  int_inventory_impl.TaskHeaderHideAnim( event_id );
  private.is_opened_for_taskheader = false;
  private.is_inventory_opened = false;

end;
--******************************************************************************************
function public.AddObject( item_name, item_game_name, func )
  
  ObjSet( item_game_name, { input = false } );

  local answer = MsgSend( Request_Level_IsLoading, {} );
  if answer.loading == 1 then

    ObjDelete( item_game_name );
    item_game_name = "";    

  end;

  local index = 0;
  for i = 1, #private.m_objects do
    if private.m_objects[ i ].name == item_name then
      private.m_objects[ i ].count = private.m_objects[ i ].count + 1;
      index = i;
      break;
    end;
  end;

  if index == 0 then
    table.insert( private.m_objects, { name = item_name, count = 1 } );
    index = #private.m_objects;

    private.m_objects_params[ item_name ] = {};
    local item_params = ObjGet( item_name );

    if item_params.event_startdrag == nil then
      item_params.event_startdrag = function () end;
    end;
    private.m_objects_params[ item_name ].event_startdrag = item_params.event_startdrag;

    if item_params.event_dragdrop == nil then
      item_params.event_dragdrop = function () end;
    end;
    private.m_objects_params[ item_name ].event_dragdrop = item_params.event_dragdrop;

    if item_params.event_menter == nil then
      item_params.event_menter = function () end;
    end;
    private.m_objects_params[ item_name ].event_menter = item_params.event_menter;

    if item_params.event_mleave == nil then
      item_params.event_mleave = function () end;
    end;
    private.m_objects_params[ item_name ].event_mleave = item_params.event_mleave;

    ObjSet( item_name, { 
      drag = true,
      event_startdrag = function () private.StartDrag( item_name ); end,
      event_dragdrop  = function () private.StopDrag( item_name ); end,
      event_menter    = function () private.ItemMouseEnter( item_name ); end,
      event_mleave    = function () private.ItemMouseLeave( item_name ); end
    } );
  end;

  private.m_objects[ index ].func = func;
  if index - 1 <= private.m_left_object_index then
    private.m_left_object_index = index - 1;

  elseif index - 1 > private.m_left_object_index then
    while index - 1 >= private.m_left_object_index + private.count_visible_objects do
      private.m_left_object_index = private.m_left_object_index + 1;
    end;

  end;

  local item_count = private.m_objects[ index ].count;
  local item_pos = private.InvGetObjPos( index - 1, private.m_left_object_index, private.count_visible_objects );

  --DbgTrace( "INV ADD: "..item_name.." ( "..item_game_name.." ), pos = "..item_pos..", count = "..item_count );

  local def_name = interface.GetObjectName( item_name );
  local hub_name = "hub_int_inventory_"..def_name;
  local sub_name = "sub_int_inventory_"..def_name;
  local obj_name = "itm_int_inventory_"..def_name;

  if ( item_count == 1 ) then

    -- основной хаб ( движение по позиции, наведение )
    ObjCreate( hub_name, "obj" );
    ObjSet( hub_name,
    {
      pos_x = ( int_inventory_impl.ITEM_POSITION_OFFSET * item_pos ),
      pos_y = 0
    } );
    private.item_positions[ item_name ] = item_pos;

    ObjAttach( hub_name, "obj_int_inventory" );

    -- под-хаб ( появление после полета, исчезание при драге )
    ObjCreate( sub_name, "obj" );
    ObjAttach( sub_name, hub_name );

    -- объект предмета
    ObjCreate( obj_name, "obj" );
    ObjAttach( obj_name, sub_name );

    -- спрайт предмета
    ObjSet( item_name, { input = true, pos_x = 0, pos_y = 0 } );
    ObjAttach( item_name, obj_name );

    local item_params = ObjGet( item_name );

    ObjSet( obj_name,
    {
      pos_z = 13,

      scale_x = int_inventory_impl.ITEM_SCALE,
      scale_y = int_inventory_impl.ITEM_SCALE,

      --inputrect_init = 1,
      --inputrect_x    = - ( 0.5 * item_params.draw_width  ),
      --inputrect_y    = - ( 0.5 * item_params.draw_height ),
      --inputrect_w    = item_params.draw_width,
      --inputrect_h    = item_params.draw_height
    } );

    -- бэк
    private.ItemCreate( item_name, sub_name );
    
  end;

  if ( item_game_name == "" ) then

    private.ExecuteAddEndFunc( item_name );

  else

    local fly_def_name = interface.GetObjectName( item_name ).."_"..item_count;
    local fly_obj_name = "fly_int_inventory_"..fly_def_name;

    ObjCreate( fly_obj_name, "obj" );
    ObjAttach( fly_obj_name, InterfaceWidget_Top_Name );

    local item_game_pos = GetObjPosByObj( item_game_name );

    ObjSet( fly_obj_name,
    {
      input      = 0,
      pos_x      = item_game_pos[ 1 ],
      pos_y      = item_game_pos[ 2 ]
    } );

    ObjSet( item_game_name, { pos_x = 0, pos_y = 0 } );
    ObjAttach( item_game_name, fly_obj_name );

    private.count_fly_animation_playing = private.count_fly_animation_playing + 1;

    local event_id = "item_fly_"..item_name.."_"..item_count;
    private.event_anim_end[ event_id ] = { name = item_name, 
                                           game_name = item_game_name, 
                                           pos = item_pos, 
                                           count = item_count, 
                                           func = func };

    int_inventory_impl.ItemFlyAnim( fly_obj_name, sub_name, item_count, event_id );

  end;

  public.Show();
  private.MoveObjects();

end;
--******************************************************************************************
function public.DeleteObject( item_name )

  local index = 0;

  if (private.m_objects) then

    for i = 1, #private.m_objects do
      if private.m_objects[ i ].name == item_name then
        index = i;
        break;
      end;
    end;

  end;

  if index ~= 0 then

    if item_name == private.m_dragging_object then
      MsgSend( Command_Transporter_StopAnim, { type = Trans_InventoryToCursor } );
      --DbgTrace(private.count_fly_animation_playing);
      if (private.count_fly_animation_playing > 0) then
        private.count_fly_animation_playing = private.count_fly_animation_playing - 1;
      end;
      private.m_dragging_object = nil; 
      SetCursor( CURSOR_DEFAULT );
      public.Hide( false );
    end;

    ObjDetach( item_name );

    if index - 1 < private.m_left_object_index then
      private.m_left_object_index = private.m_left_object_index - 1;

    elseif index - 1 >= private.m_left_object_index and 
           index - 1 < private.m_left_object_index + private.count_visible_objects then
      if private.m_left_object_index > 0 then
        private.m_left_object_index = private.m_left_object_index - 1;
      end;

    end;

    table.remove( private.m_objects, index );

    ObjSet( item_name, private.m_objects_params[ item_name ] );

    private.m_objects_params[ item_name ] = nil;
    private.MoveObjects();

    local def_name = interface.GetObjectName( item_name );
    local hub_name = "hub_int_inventory_"..def_name;
    local sub_name = "sub_int_inventory_"..def_name;
    local obj_name = "itm_int_inventory_"..def_name;

    if ( int_inventory_impl.DONT_DELETE_ITEMS ) then

      ObjAttach( item_name, "int_inventory_items_hub" );

    else

      ObjDelete( item_name );

    end;

    ObjDelete( obj_name );
    ObjDelete( hub_name );

    public.Hide();

  end;

end;
--******************************************************************************************
function public.ShowObject( item_name )

  local index = 0;
  for i = 1, #private.m_objects do
    if private.m_objects[ i ].name == item_name then
      index = i;
      break;
    end;
  end;

  if index ~= 0 then

    if index - 1 < private.m_left_object_index then
      private.m_left_object_index = index - 1;
      private.MoveObjects();

    elseif index - 1 >= private.m_left_object_index + private.count_visible_objects then
      private.m_left_object_index = index - private.count_visible_objects;
      private.MoveObjects();

    end;

  end;

end;
--******************************************************************************************
function private.ZoomIn( item_name )

  local def_name = interface.GetObjectName( item_name );
  local hub_name = "hub_int_inventory_"..def_name;
  local sub_name = "sub_int_inventory_"..def_name;
  local obj_name = "itm_int_inventory_"..def_name;

  local event_id = "item_menter";
  private.event_anim_end[ event_id ] = {};

  int_inventory_impl.ItemMouseEnterAnim( obj_name, event_id );

end;
--******************************************************************************************
function private.ZoomOut( item_name )

  local def_name = interface.GetObjectName( item_name );
  local hub_name = "hub_int_inventory_"..def_name;
  local sub_name = "sub_int_inventory_"..def_name;
  local obj_name = "itm_int_inventory_"..def_name;

  local event_id = "item_mleave";
  private.event_anim_end[ event_id ] = {};

  int_inventory_impl.ItemMouseLeaveAnim( obj_name, event_id );

end;
--******************************************************************************************
function private.MoveObjects()

  private.is_objects_moving = true;
  local size = private.count_visible_objects;
  local objects = {};

  for i = 1, #private.m_objects do
    table.insert( objects, { name = private.m_objects[ i ].name, 
                             pos = private.InvGetObjPos( i - 1, 
                                                         private.m_left_object_index, 
                                                         private.count_visible_objects ) } );
  end;

  --DbgTrace( "INV MOVE: size = "..size..", objects count = "..#objects );

  ObjSet( "obj_int_inventory_btn_left",  { input = false } );
  ObjSet( "obj_int_inventory_btn_right", { input = false } );

  if ( not int_inventory_impl.ArrowSetVisible ) then

    ObjSet( "spr_int_inventory_btn_left_na",  { visible = true } );
    ObjSet( "spr_int_inventory_btn_right_na", { visible = true } );

  else

    int_inventory_impl.ArrowSetVisible( "left",  false );
    int_inventory_impl.ArrowSetVisible( "right", false );

  end;

  for i = 1, #objects, 1 do

    local item_name = objects[ i ][ "name" ];
    local item_pos  = objects[ i ][ "pos" ];

    local hub_name = "hub_int_inventory_"..interface.GetObjectName( item_name );

    local move_type = 0;

    local item_pos_old = private.item_positions[ item_name ];--( ObjGet( hub_name ).pos_x ) / interface.inventory.ITEM_POSITION_OFFSET;

    private.item_positions[ item_name ] = item_pos;

    local move_pos = int_inventory_impl.ITEM_POSITION_OFFSET * item_pos;

    if ( item_pos == - 1 ) then

      ObjSet( "obj_int_inventory_btn_left", { input = true } );

      if ( not int_inventory_impl.ArrowSetVisible ) then

        ObjSet( "spr_int_inventory_btn_left_na", { visible = false } );

      else

        int_inventory_impl.ArrowSetVisible( "left", true );

      end;

    end;

    if ( item_pos == size ) then

      ObjSet( "obj_int_inventory_btn_right", { input = true } );

      if ( not int_inventory_impl.ArrowSetVisible ) then

        ObjSet( "spr_int_inventory_btn_right_na", { visible = false } );

      else

        int_inventory_impl.ArrowSetVisible( "right", true );

      end;

    end;

    if     ( ( item_pos_old >=  - 1 ) and ( item_pos <=  - 1 ) )
    or     ( ( item_pos_old < size ) and  ( item_pos == size ) )
    then

      move_type = 1;
      
    --end;

    elseif ( ( item_pos_old ==  - 1 ) and ( item_pos >  - 1 ) )
    or     ( ( item_pos_old == size ) and ( item_pos < size ) )
    then

      move_type = 2;

    end;

  --[[
    if     ( ( item_pos_old ==  - 1 ) and ( item_pos == size ) )
    or     ( ( item_pos_old == size ) and ( item_pos ==  - 1 ) )
    then

      move_type = 3;

    end;
  ]]

    --DbgTrace( "INV MOVE: object "..i..": "..item_name..", pos = "..item_pos.." ( old = "..item_pos_old.." ), move_type = "..move_type.."." );

    local event_id = "item_move_"..item_name;
    private.event_anim_end[ event_id ] = {};--{ name = item_name, pos = item_pos };
    int_inventory_impl.ItemMoveAnim( hub_name, move_type, move_pos, event_id );

  end;

  ObjSet( "tmr_int_inventory_items_move",
  {
    endtrig = function () private.is_objects_moving = false; end,
    time    = int_inventory_impl.ITEM_MOVE_ANIM_TIME,
    playing = true
  } );

end;
--******************************************************************************************
function private.FlyToCursor( item_name )

  SetCursor( CURSOR_NULL );

  local def_name = interface.GetObjectName( item_name );
  local hub_name = "hub_int_inventory_"..def_name;
  local sub_name = "sub_int_inventory_"..def_name;
  local obj_name = "itm_int_inventory_"..def_name;

  --MsgSend( Event_Inventory_FlyAnimationStart );
  
  local event_id = "item_drag";
  private.event_anim_end[ event_id ] = { name = item_name };

  int_inventory_impl.ItemDragAnim( obj_name, sub_name, event_id );

end;
--******************************************************************************************
function private.FlyToInventory( item_name )

  SetCursor( CURSOR_DEFAULT );

  local def_name = interface.GetObjectName( item_name );
  local hub_name = "hub_int_inventory_"..def_name;
  local sub_name = "sub_int_inventory_"..def_name;
  local obj_name = "itm_int_inventory_"..def_name;

  private.count_fly_animation_playing = private.count_fly_animation_playing + 1;

  local event_id = "item_drop_"..item_name;
  private.event_anim_end[ event_id ] = { name = item_name };

  int_inventory_impl.ItemDropAnim( obj_name, sub_name, event_id );

end;
--******************************************************************************************
function private.ItemCreate( item_name, hub_name )

  local back_name = "spr_int_inventory_"..interface.GetObjectName( item_name ).."_back";

  ObjCreate( back_name, "spr" );

  ObjSet( back_name,
  {
  res = "assets/interface/int_inventory/inventory_back",
  alp = 0.6,
  input = false,
  blendmode = 0,
  pos_z = 0
  } );

  ObjAttach( back_name, hub_name );

end;
--******************************************************************************************
function private.StartHide()

  --if not private.is_opened_for_taskheader then
  --  DbgTrace("not private.is_opened_for_taskheader");
  --end;
  --if private.is_inventory_opened then
  --  DbgTrace("private.is_inventory_opened");
  --end;
  --if not private.is_mouse_over_inventory then
  --  DbgTrace("not private.is_mouse_over_inventory");
  --end;
  --if private.count_fly_animation_playing == 0 then
  --  DbgTrace("private.count_fly_animation_playing == 0");
  --end;
  --if private.is_autohide then
  --  DbgTrace("private.is_autohide");
  --end;


  if not private.is_opened_for_taskheader and 
     private.is_inventory_opened and
     not private.is_mouse_over_inventory and
     private.count_fly_animation_playing == 0 and 
     private.is_autohide then

    private.is_inventory_opened = false;

    local event_id = "hide";
    private.event_anim_end[ event_id ] = {};
    int_inventory_impl.HideAnim( event_id );

  end;

end;
--******************************************************************************************
function private.StartDrag( item_name )

  private.FlyToCursor( item_name );
  private.m_dragging_object = item_name;  

  ObjSet( item_name, { input = false } );
  SetCursor( CURSOR_NULL );

  if private.m_objects_params[ item_name ] and 
     private.m_objects_params[ item_name ].event_startdrag ~= nil then 
     private.m_objects_params[ item_name ].event_startdrag(); 
  end;

end;
--******************************************************************************************
function private.StopDrag( item_name )

  MsgSend( Command_Transporter_StopAnim, { type = Trans_InventoryToCursor } );
  ObjSet( item_name, { input = false } );

  if private.m_objects_params[ item_name ] and 
     private.m_objects_params[ item_name ].event_dragdrop ~= nil then 
     private.m_objects_params[ item_name ].event_dragdrop(); 
  end;

  private.m_dragging_object = nil; 
  SetCursor( CURSOR_DEFAULT );

  if ObjGet( item_name ) ~= nil then
    private.FlyToInventory( item_name );
  end;

end;
--******************************************************************************************
function private.ItemMouseEnter( item_name ) 

  private.ZoomIn( item_name ); 
  public.Show( true ); 

  if private.m_objects_params[ item_name ] and 
     private.m_objects_params[ item_name ].event_menter ~= nil then 
     private.m_objects_params[ item_name ].event_menter(); 
  end;

end
--******************************************************************************************
function private.ItemMouseLeave( item_name ) 

  private.ZoomOut( item_name ); 

  if private.m_objects_params[ item_name ] and 
     private.m_objects_params[ item_name ].event_mleave ~= nil then 
     private.m_objects_params[ item_name ].event_mleave(); 
  end;

end
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "inventory" );

end;
--******************************************************************************************
function private.InvGetObjPos( idx, start, m )

  if idx < start then
    return -1;
  elseif idx - start < m then
    return idx - start;
  else
    return m;
  end;

end;
--******************************************************************************************
function private.ExecuteAddEndFunc( item_name )

  for i = 1, #private.m_objects do
    if private.m_objects[ i ].name == item_name then
      if private.m_objects[ i ].func then
        private.m_objects[ i ].func();
      end;
      break;
    end;
  end;

end;
--******************************************************************************************
function private.DecreaseZ()
  ObjSet( "int_inventory", { pos_z = ObjGet( "int_inventory" ).pos_z - 1 } );
end;
--******************************************************************************************
function private.IncreaseZ()
  ObjSet( "int_inventory", { pos_z = ObjGet( "int_inventory" ).pos_z + 1 } );
end;
--******************************************************************************************