--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "frame_subroom" );
  ObjAttach( "int_frame_subroom", interface.originhub );
  ObjSet( "int_frame_subroom", { pos_z = pos_z } );
  private.event_anim_end = {};
  private.block = false;

end;
--******************************************************************************************
function public.Destroy()

end;
--******************************************************************************************
function public.BlockClose( flag )

  private.block = flag;

end;
--******************************************************************************************
function public.BlockClose( flag )

  private.block = flag;

end;
--********************************************************************************************************************
function public.Show( alpha_anm_table, pos_xy_anm_table, scale_xy_anm_table )

  ObjSet( "int_frame_subroom", { input = false, visible = true, active = true } );
  private.Anim( alpha_anm_table, pos_xy_anm_table, scale_xy_anm_table, private.ShowAnimEnd );

end;
--********************************************************************************************************************
function public.Hide( alpha_anm_table, pos_xy_anm_table, scale_xy_anm_table )

  ObjSet( "int_frame_subroom", { input = false } );
  private.Anim( alpha_anm_table, pos_xy_anm_table, scale_xy_anm_table, private.HideAnimEnd );

end;
--******************************************************************************************
function private.HideAnimEnd()

  ObjSet( "int_frame_subroom", { visible = false, active = false } );

end;
--******************************************************************************************
function private.ShowAnimEnd( alpha_anm_table, pos_xy_anm_table, scale_xy_anm_table )

  ObjSet( "int_frame_subroom", { input = true } );

end;
--******************************************************************************************
function private.Anim( alpha_anm_table, pos_xy_anm_table, scale_xy_anm_table, func )

  ObjAnimate( "int_frame_subroom", "alp", 0, 0, func, alpha_anm_table );
  ObjAnimate( "int_frame_subroom", "scale_xy", 0, 0, "", scale_xy_anm_table );
  ObjAnimate( "int_frame_subroom", "pos_xy", 0, 0, "", pos_xy_anm_table );

end;
--******************************************************************************************
function public.Construct( frame_w, frame_h, extended )
  
  --local frame_w = frame_w  + border_w;
  --local frame_h = frame_h + border_h;

  --DbgTrace( "Frame Subroom Show: w = "..frame_w..", h = "..frame_h );

  ObjSet( "obj_int_frame_subroom_top",   { inputrect_x = ( - 0.5 * frame_w ), inputrect_w = frame_w, pos_y = ( - 0.5 * frame_h ) } );
  ObjSet( "obj_int_frame_subroom_bot",   { inputrect_x = ( - 0.5 * frame_w ), inputrect_w = frame_w, pos_y = (   0.5 * frame_h ) } );
  ObjSet( "obj_int_frame_subroom_left",  { pos_x = ( - 0.5 * frame_w ) } );
  ObjSet( "obj_int_frame_subroom_right", { pos_x = (   0.5 * frame_w ) } );

  local border_w = int_frame_subroom_impl.GRID_BORDER_W;
  local border_h = int_frame_subroom_impl.GRID_BORDER_H;

  frame_w = frame_w + border_w;
  frame_h = frame_h + border_h;

  local frame_corner_w = int_frame_subroom_impl.GRID_CORNER_W;
  local frame_corner_h = int_frame_subroom_impl.GRID_CORNER_H;

  local frame_mid_w = int_frame_subroom_impl.GRID_MID_W;
  local frame_mid_h = int_frame_subroom_impl.GRID_MID_H;

  interface.FrameGridSet( "int_frame_subroom",
  {
    grid_w   = frame_w,
    grid_h   = frame_h,
    corner_w = frame_corner_w,
    corner_h = frame_corner_h,
    mid_w    = frame_mid_w,
    mid_h    = frame_mid_h
  } );

  if ( int_frame_subroom_impl.ShowExtended ) then

    int_frame_subroom_impl.ShowExtended( frame_w, frame_h, extended );

  end;

end;
--******************************************************************************************
function public.ButtonCloseClick()

  if not private.block then

    MsgSend( Event_FrameSubroom_Click, {} );

  end;

end;
--******************************************************************************************
function public.FieldCloseMouseEnter()

  SetCursor( CURSOR_DOWN );

end;
--******************************************************************************************
function public.FieldCloseMouseLeave()

  SetCursor( CURSOR_DEFAULT );

end;
--******************************************************************************************