--******************************************************************************************
function public.Init( pos_z )

  private.event_anim_end = {};
  interface.LoadImplementation( "effects" );
  ObjAttach( "int_effects", interface.originhub );
  ObjSet( "int_effects", { pos_z = pos_z } );
  MsgSubscribe( Command_Effect_ShowHoHint, private.ShowHoHint );

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Effect_ShowHoHint, private.ShowHoHint );

end;
--******************************************************************************************
function private.ShowHoHint( msg, params )

  local ho_hint = params.hint;

  for i = 1, #ho_hint, 1 do

    local target_name = ho_hint[ i ][ "obj_name" ];
    
    local hint_pos_x = ho_hint[ i ][ "pos_x" ];
    local hint_pos_y = ho_hint[ i ][ "pos_y" ];

    local event_id = "ho_hint_show_"..target_name;
    private.event_anim_end[ event_id ] = {};
    int_effects_impl.HoHintShowAnim( target_name, hint_pos_x, hint_pos_y, event_id );

  end;

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( string.find( event_id, "ho_hint_show" ) ) then

  --

  end;
------------------------------------------------------------------------------------
end;
--******************************************************************************************